/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.provider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.repository.p2base.artifact.provider.ArtifactProviderImplUtilities;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;

public abstract class CompositeArtifactProviderBaseImpl
implements IRawArtifactProvider {
    @Override
    public final IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        HashSet<IArtifactDescriptor> result = new HashSet<IArtifactDescriptor>();
        this.getArtifactDescriptorsOfAllSources(key, result);
        return result.toArray(new IArtifactDescriptor[result.size()]);
    }

    protected abstract void getArtifactDescriptorsOfAllSources(IArtifactKey var1, Set<IArtifactDescriptor> var2);

    @Override
    public final IStatus getArtifact(IArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException {
        ArtifactProviderImplUtilities.canWriteToSink(sink);
        ArtifactProviderImplUtilities.canWriteCanonicalArtifactToSink(sink);
        ArrayList<IStatus> statusOfAllAttempts = new ArrayList<IStatus>();
        this.getArtifactFromAnySource(sink, statusOfAllAttempts, CompositeArtifactProviderBaseImpl.nonNull(monitor));
        if (statusOfAllAttempts.size() == 1) {
            return (IStatus)statusOfAllAttempts.get(0);
        }
        return this.getOverallStatus(statusOfAllAttempts, sink.getArtifactToBeWritten().toString());
    }

    protected abstract void getArtifactFromAnySource(IArtifactSink var1, List<IStatus> var2, IProgressMonitor var3) throws ArtifactSinkException;

    @Override
    public final IStatus getRawArtifact(IRawArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException {
        ArtifactProviderImplUtilities.canWriteToSink(sink);
        ArrayList<IStatus> statusOfAllAttempts = new ArrayList<IStatus>();
        this.getRawArtifactFromAnySource(sink, CompositeArtifactProviderBaseImpl.nonNull(monitor), statusOfAllAttempts);
        if (statusOfAllAttempts.size() == 1) {
            return (IStatus)statusOfAllAttempts.get(0);
        }
        return this.getOverallStatus(statusOfAllAttempts, sink.getArtifactFormatToBeWritten().toString());
    }

    protected abstract void getRawArtifactFromAnySource(IRawArtifactSink var1, IProgressMonitor var2, List<IStatus> var3) throws ArtifactSinkException;

    private IStatus getOverallStatus(List<IStatus> statusOfAllAttempts, String artifact) {
        int childCount = statusOfAllAttempts.size();
        if (childCount == 0) {
            return this.getArtifactNotFoundError(artifact);
        }
        if (!CompositeArtifactProviderBaseImpl.isFatal(statusOfAllAttempts.get(childCount - 1))) {
            return ArtifactProviderImplUtilities.createMultiStatusWithFixedSeverity(2, "org.eclipse.tycho.p2.maven.repository", statusOfAllAttempts, "Some attempts to read artifact " + artifact + " failed");
        }
        return new MultiStatus("org.eclipse.tycho.p2.maven.repository", 0, CompositeArtifactProviderBaseImpl.toArray(statusOfAllAttempts), "All attempts to read artifact " + artifact + " failed", null);
    }

    protected abstract IStatus getArtifactNotFoundError(String var1);

    protected static IProgressMonitor nonNull(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    protected static boolean isFatal(IStatus status) {
        return status.matches(12);
    }

    private static IStatus[] toArray(List<IStatus> statusList) {
        return statusList.toArray(new IStatus[statusList.size()]);
    }
}

