/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.action;

import java.util.LinkedList;
import org.jemmy.JemmyException;
import org.jemmy.TimeoutExpiredException;
import org.jemmy.action.Action;

class ActionQueue {
    private Thread queueThread;
    private final LinkedList<ActionRecord> queue = new LinkedList();
    private boolean stop = false;

    public ActionQueue() {
        this.queueThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ActionQueue.this.stop) {
                    ActionRecord r;
                    int size;
                    LinkedList linkedList = ActionQueue.this.queue;
                    synchronized (linkedList) {
                        size = ActionQueue.this.queue.size();
                        if (size == 0) {
                            try {
                                ActionQueue.this.queue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (size <= 0) continue;
                    LinkedList linkedList2 = ActionQueue.this.queue;
                    synchronized (linkedList2) {
                        r = (ActionRecord)ActionQueue.this.queue.poll();
                    }
                    try {
                        r.execute();
                    }
                    catch (Exception e) {
                        System.err.println("Action '" + r + "' failed with the following exception: ");
                        e.printStackTrace(System.err);
                        System.err.flush();
                    }
                    r.setCompleted(true);
                }
            }
        }, "ActionQueue.queueThread");
        this.queueThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int actionsInQueue() {
        LinkedList<ActionRecord> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.size();
        }
    }

    public void stop() {
        this.stop = true;
    }

    public Thread getQueueThread() {
        return this.queueThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Action action, Object ... parameters) {
        LinkedList<ActionRecord> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(new ActionRecord(action, parameters));
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Action action, Object ... parameters) {
        ActionRecord r = new ActionRecord(action, parameters);
        LinkedList<ActionRecord> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(r);
            this.queue.notifyAll();
        }
        r.waitCompleted();
        if (r.failed()) {
            throw new JemmyException("Action '" + r + "' invoked through ActionQueue failed", r.getThrowable());
        }
    }

    private class ActionRecord {
        Action action;
        Object[] parameters;
        boolean completed;
        boolean started;

        public ActionRecord(Action action, Object[] parameters) {
            this.action = action;
            this.parameters = parameters;
        }

        public boolean failed() {
            return this.action.failed();
        }

        public Throwable getThrowable() {
            return this.action.getThrowable();
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            ActionRecord actionRecord = this;
            synchronized (actionRecord) {
                this.started = true;
                this.notifyAll();
            }
            this.action.execute(this.parameters);
        }

        public synchronized void waitCompleted() {
            try {
                while (!this.started) {
                    this.wait();
                }
                if (!this.completed) {
                    this.wait(this.action.getAllowedTime());
                    if (!this.completed) {
                        this.action.interrupt();
                        throw new TimeoutExpiredException("Action did not finish in " + this.action.getAllowedTime() + " ms: " + this.action);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.action.toString();
        }
    }
}

