/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnSetProperty;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgSetProperty
extends SvnNgOperationRunner<SVNPropertyData, SvnSetProperty> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SVNPropertyData run(SVNWCContext context) throws SVNException {
        SvnNgPropertiesManager.checkPropertyName(((SvnSetProperty)this.getOperation()).getPropertyName(), ((SvnSetProperty)this.getOperation()).getPropertyValue());
        for (SvnTarget target : ((SvnSetProperty)this.getOperation()).getTargets()) {
            Object var8_8;
            File localAbsPath = target.getFile();
            SVNNodeKind kind = SVNNodeKind.NONE;
            try {
                kind = this.getWcContext().readKind(this.getFirstTarget(), false);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    this.notifyNonExistentPath(localAbsPath);
                }
                throw e;
            }
            if (kind == SVNNodeKind.NONE || kind == SVNNodeKind.UNKNOWN) {
                this.notifyNonExistentPath(localAbsPath);
            }
            File lockedPath = context.acquireWriteLock(localAbsPath, false, true);
            try {
                SvnNgPropertiesManager.setProperty(this.getWcContext(), localAbsPath, ((SvnSetProperty)this.getOperation()).getPropertyName(), ((SvnSetProperty)this.getOperation()).getPropertyValue(), ((SvnSetProperty)this.getOperation()).getPropertyValueProvider(), ((SvnSetProperty)this.getOperation()).getDepth(), ((SvnSetProperty)this.getOperation()).isForce(), ((SvnSetProperty)this.getOperation()).getEventHandler(), (ISvnObjectReceiver)this.getOperation(), ((SvnSetProperty)this.getOperation()).getApplicableChangelists());
                var8_8 = null;
            }
            catch (Throwable throwable) {
                var8_8 = null;
                context.releaseWriteLock(lockedPath);
                throw throwable;
            }
            context.releaseWriteLock(lockedPath);
            {
            }
        }
        return (SVNPropertyData)((SvnSetProperty)this.getOperation()).first();
    }

    private void notifyNonExistentPath(File localAbsPath) throws SVNException {
        SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.PATH_NONEXISTENT, SVNEventAction.PATH_NONEXISTENT, null, null, -1L, -1L);
        if (((SvnSetProperty)this.getOperation()).getEventHandler() != null) {
            ((SvnSetProperty)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
        }
    }

    @Override
    public boolean isApplicable(SvnSetProperty operation, SvnWcGeneration wcGeneration) throws SVNException {
        return !operation.isRevisionProperty() && super.isApplicable(operation, wcGeneration);
    }
}

