/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.util.ScanResult;
import org.eclipse.tycho.surefire.AbstractTestMojo;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;

@Mojo(name="integration-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TychoIntegrationTestMojo
extends AbstractTestMojo {
    @Parameter(property="project.build.testOutputDirectory")
    private File testClassesDirectory;
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports", required=true)
    private File reportDirectory;

    @Override
    protected boolean shouldRun() {
        return "eclipse-plugin".equals(this.project.getPackaging()) && this.scanForTests().size() > 0;
    }

    @Override
    protected List<String> getDefaultInclude() {
        return Arrays.asList("**/PluginTest*.class", "**/*IT.class");
    }

    @Override
    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    protected File getReportsDirectory() {
        return this.reportDirectory;
    }

    @Override
    protected boolean shouldSkip() {
        return this.skipITs || super.shouldSkip();
    }

    @Override
    protected PropertiesWrapper createSurefireProperties(TestFrameworkProvider provider, ScanResult scanResult) throws MojoExecutionException {
        PropertiesWrapper properties = super.createSurefireProperties(provider, scanResult);
        properties.setProperty("failifnotests", String.valueOf(false));
        properties.setProperty("failsafe", this.summaryFile.getAbsolutePath());
        return properties;
    }

    @Override
    protected void handleNoTestsFound() throws MojoFailureException {
        this.getLog().info((CharSequence)"No tests found");
    }

    @Override
    protected void handleSuccess() {
    }

    @Override
    protected void handleTestFailures() throws MojoFailureException {
    }
}

