/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.lifecycle.internal.CurrentPhaseForThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadLockedArtifact
implements Artifact {
    private final Artifact real;
    private final CountDownLatch artifactLocked = new CountDownLatch(1);
    private static final InheritableThreadLocal<ThreadLockedArtifact> THREAD_ARTIFACT = new InheritableThreadLocal();

    ThreadLockedArtifact(Artifact real) {
        this.real = real;
    }

    public boolean hasReal() {
        return this.real != null && (!(this.real instanceof ThreadLockedArtifact) || ((ThreadLockedArtifact)this.real).hasReal());
    }

    public String getGroupId() {
        return this.real.getGroupId();
    }

    public String getArtifactId() {
        return this.real.getArtifactId();
    }

    public String getVersion() {
        return this.real.getVersion();
    }

    public void setVersion(String version) {
        this.real.setVersion(version);
    }

    public String getScope() {
        return this.real.getScope();
    }

    public String getType() {
        return this.real.getType();
    }

    public String getClassifier() {
        return this.real.getClassifier();
    }

    public boolean hasClassifier() {
        return this.real.hasClassifier();
    }

    public void attachToThread() {
        THREAD_ARTIFACT.set(this);
    }

    public File getFile() {
        ThreadLockedArtifact lockedArtifact = (ThreadLockedArtifact)THREAD_ARTIFACT.get();
        if (lockedArtifact != null && this != lockedArtifact && this.mustLock()) {
            try {
                this.artifactLocked.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.real.getFile();
    }

    private boolean mustLock() {
        boolean dontNeedLock = CurrentPhaseForThread.isPhase("compile") || CurrentPhaseForThread.isPhase("test");
        return !dontNeedLock;
    }

    public void setFile(File destination) {
        if (destination != null && destination.exists() && destination.isFile()) {
            this.artifactLocked.countDown();
        }
        this.real.setFile(destination);
    }

    public String getBaseVersion() {
        return this.real.getBaseVersion();
    }

    public void setBaseVersion(String baseVersion) {
        this.real.setBaseVersion(baseVersion);
    }

    public String getId() {
        return this.real.getId();
    }

    public String getDependencyConflictId() {
        return this.real.getDependencyConflictId();
    }

    public void addMetadata(ArtifactMetadata metadata) {
        this.real.addMetadata(metadata);
    }

    public Collection<ArtifactMetadata> getMetadataList() {
        return this.real.getMetadataList();
    }

    public void setRepository(ArtifactRepository remoteRepository) {
        this.real.setRepository(remoteRepository);
    }

    public ArtifactRepository getRepository() {
        return this.real.getRepository();
    }

    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.real.updateVersion(version, localRepository);
    }

    public String getDownloadUrl() {
        return this.real.getDownloadUrl();
    }

    public void setDownloadUrl(String downloadUrl) {
        this.real.setDownloadUrl(downloadUrl);
    }

    public ArtifactFilter getDependencyFilter() {
        return this.real.getDependencyFilter();
    }

    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.real.setDependencyFilter(artifactFilter);
    }

    public ArtifactHandler getArtifactHandler() {
        return this.real.getArtifactHandler();
    }

    public List<String> getDependencyTrail() {
        return this.real.getDependencyTrail();
    }

    public void setDependencyTrail(List<String> dependencyTrail) {
        this.real.setDependencyTrail(dependencyTrail);
    }

    public void setScope(String scope) {
        this.real.setScope(scope);
    }

    public VersionRange getVersionRange() {
        return this.real.getVersionRange();
    }

    public void setVersionRange(VersionRange newRange) {
        this.real.setVersionRange(newRange);
    }

    public void selectVersion(String version) {
        this.real.selectVersion(version);
    }

    public void setGroupId(String groupId) {
        this.real.setGroupId(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.real.setArtifactId(artifactId);
    }

    public boolean isSnapshot() {
        return this.real.isSnapshot();
    }

    public void setResolved(boolean resolved) {
        this.real.setResolved(resolved);
    }

    public boolean isResolved() {
        return this.real.isResolved();
    }

    public void setResolvedVersion(String version) {
        this.real.setResolvedVersion(version);
    }

    public void setArtifactHandler(ArtifactHandler handler) {
        this.real.setArtifactHandler(handler);
    }

    public boolean isRelease() {
        return this.real.isRelease();
    }

    public void setRelease(boolean release) {
        this.real.setRelease(release);
    }

    public List<ArtifactVersion> getAvailableVersions() {
        return this.real.getAvailableVersions();
    }

    public void setAvailableVersions(List<ArtifactVersion> versions) {
        this.real.setAvailableVersions(versions);
    }

    public boolean isOptional() {
        return this.real.isOptional();
    }

    public void setOptional(boolean optional) {
        this.real.setOptional(optional);
    }

    public ArtifactVersion getSelectedVersion() throws OverConstrainedVersionException {
        return this.real.getSelectedVersion();
    }

    public boolean isSelectedVersionKnown() throws OverConstrainedVersionException {
        return this.real.isSelectedVersionKnown();
    }

    public int compareTo(Artifact o) {
        return this.real.compareTo((Object)o);
    }
}

