/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.FileReadRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.FileWriteRule;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.FileTestEvent;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.MockEventCollection;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;

public class TestFileReadWriteRule {
    private static final String FILE_NAME_1 = "/user/dir/file1.dat";
    private static final String FILE_NAME_2 = "/user/dir/file2.dat";

    @Test
    public void testReadRule() {
        this.testFileRule("jdk.FileRead", (IRule)new FileReadRule(), "The longest recorded file read took 5\u00a0s to read 4\u00a0KiB from /user/dir/file1.dat. Average time of recorded IO: 4.500\u00a0s. Total time of recorded IO: 13.500\u00a0s. Total time of recorded IO for the file /user/dir/file1.dat: 9.500\u00a0s.");
    }

    @Test
    public void testWriteRule() {
        this.testFileRule("jdk.FileWrite", (IRule)new FileWriteRule(), "The longest recorded file write took 5\u00a0s to write 4\u00a0KiB to /user/dir/file1.dat. Average time of recorded IO: 4.500\u00a0s. Total time of recorded IO: 13.500\u00a0s. Total time of recorded IO for the file /user/dir/file1.dat: 9.500\u00a0s.");
    }

    private void testFileRule(String eventType, IRule rule, String expectedLongDesc) {
        TestEvent[] testEvents = new TestEvent[]{new FileTestEvent(eventType, FILE_NAME_1, 4500L, 4096L), new FileTestEvent(eventType, FILE_NAME_1, 5000L, 4096L), new FileTestEvent(eventType, FILE_NAME_2, 4000L, 4096L)};
        MockEventCollection events = new MockEventCollection(testEvents);
        RunnableFuture future = rule.createEvaluation((IItemCollection)events, IPreferenceValueProvider.DEFAULT_VALUES, (IResultValueProvider)new ResultProvider());
        try {
            future.run();
            IResult res = (IResult)future.get();
            String longDesc = ResultToolkit.populateMessage((IResult)res, (String)res.getExplanation(), (boolean)false);
            Assert.assertEquals((Object)expectedLongDesc, (Object)longDesc);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

