/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt.lookup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Item;
import org.jemmy.resources.StringComparePolicy;
import org.jemmy.swt.lookup.QueueLookup;

public class ByItemStringsLookup<T extends Item>
extends QueueLookup<T> {
    private final StringComparePolicy policy;
    private final String text;

    public ByItemStringsLookup(String text) {
        this(text, StringComparePolicy.SUBSTRING);
    }

    public ByItemStringsLookup(String text, StringComparePolicy policy) {
        this.policy = policy;
        this.text = text;
    }

    public static <V extends Item> List<String> getTexts(V item) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(item.getText());
        try {
            Method getText = item.getClass().getMethod("getText", Integer.TYPE);
            Method getParent = item.getClass().getMethod("getParent", new Class[0]);
            Object parent = getParent.invoke(item, new Object[0]);
            Method getColumnCount = parent.getClass().getMethod("getColumnCount", new Class[0]);
            int columnCount = (Integer)getColumnCount.invoke(parent, new Object[0]);
            for (int i = 0; i < columnCount; ++i) {
                result.add((String)getText.invoke(item, i));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.err.println("Exception when using reflection to get additional text elements: " + ex.getMessage());
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean doCheck(T control) {
        try {
            control.getClass().getMethod("getText", Integer.TYPE);
            return ByItemStringsLookup.getTexts(control).stream().map(textElement -> this.policy.compare(this.text, textElement)).anyMatch(matches -> matches);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Class " + control.getClass() + " isn't supported by " + this.getClass().getSimpleName() + " (i.e has no getText(int) method");
            return false;
        }
    }

    public String toString() {
        return "Text = " + this.text;
    }
}

