/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt.lookup;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.jemmy.resources.StringComparePolicy;
import org.jemmy.swt.lookup.ByItemStringsLookup;
import org.jemmy.swt.lookup.QueueLookup;

public class ByItemLookup<T extends Composite>
extends QueueLookup<T> {
    private final StringComparePolicy policy;
    private final String text;

    public ByItemLookup(String text) {
        this(text, StringComparePolicy.SUBSTRING);
    }

    public ByItemLookup(String text, StringComparePolicy policy) {
        this.policy = policy;
        this.text = text;
    }

    @Override
    public boolean doCheck(T control) {
        block19: {
            Object[] items;
            block18: {
                items = null;
                if (Tree.class.isInstance(control)) {
                    items = ((Tree)Tree.class.cast(control)).getItems();
                } else if (ToolBar.class.isInstance(control)) {
                    items = ((ToolBar)ToolBar.class.cast(control)).getItems();
                } else if (CTabFolder.class.isInstance(control)) {
                    items = ((CTabFolder)CTabFolder.class.cast(control)).getItems();
                } else if (TabFolder.class.isInstance(control)) {
                    items = ((TabFolder)TabFolder.class.cast(control)).getItems();
                } else if (Table.class.isInstance(control)) {
                    items = ((Table)Table.class.cast(control)).getItems();
                } else if (Combo.class.isInstance(control)) {
                    items = ((Combo)Combo.class.cast(control)).getItems();
                } else {
                    System.err.println("Class " + control.getClass() + " does not match any supported class in ByItemLookup");
                    return false;
                }
                if (!(items instanceof Item[])) break block18;
                for (Item item : (Item[])Item[].class.cast(items)) {
                    if (this.policy.compare(this.text, item.getText())) {
                        return true;
                    }
                    try {
                        item.getClass().getMethod("getText", Integer.TYPE);
                        return ByItemStringsLookup.getTexts(item).stream().map(textElement -> this.policy.compare(this.text, textElement)).anyMatch(matches -> matches);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException e) {
                        System.err.println("SecurityException when using reflection to get method 'getText(int)' from " + item);
                        e.printStackTrace();
                    }
                }
                break block19;
            }
            if (!(items instanceof String[])) break block19;
            for (String stringItem : (String[])String[].class.cast(items)) {
                if (!this.policy.compare(this.text, stringItem)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Text = " + this.text;
    }
}

