/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.FormatToolkit;

abstract class StructuredWriter {
    private static final String LINE_SEPARATOR = String.format("%n", new Object[0]);
    private final Writer out;
    private final StringBuilder builder = new StringBuilder(4000);
    private char[] indentionArray = new char[0];
    private int indent = 0;
    private int column;

    StructuredWriter(Writer p) {
        this.out = p;
    }

    protected String stringify(Object value) {
        return this.stringify("", value, false);
    }

    protected String stringify(String indent, Object value) {
        return this.stringify(indent, value, true);
    }

    protected String stringify(String indent, Object value, boolean formatValues) {
        if (value instanceof IMCMethod) {
            return indent + this.stringifyMethod((IMCMethod)value);
        }
        if (value instanceof IMCType) {
            return indent + this.stringifyType((IMCType)value);
        }
        if (value instanceof IQuantity) {
            if (formatValues) {
                return ((IQuantity)value).displayUsing("auto");
            }
            IQuantity quantity = (IQuantity)value;
            return String.valueOf(quantity.numberValue());
        }
        if (value instanceof IDescribable) {
            String name = ((IDescribable)value).getName();
            return name != null ? name : value.toString();
        }
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            Object[] values = (Object[])value;
            buffer.append(" [").append(values.length).append("]");
            for (Object o : values) {
                buffer.append(indent);
                buffer.append(this.stringify(indent + "  ", o));
            }
            return buffer.toString();
        }
        return value.toString();
    }

    private String stringifyType(IMCType type) {
        return this.formatPackage(type.getPackage()) + "." + type.getTypeName();
    }

    protected String stringifyMethod(IMCMethod method) {
        return this.formatPackage(method.getType().getPackage()) + "." + method.getType().getTypeName() + "#" + method.getMethodName() + method.getFormalDescriptor();
    }

    private String formatPackage(IMCPackage mcPackage) {
        return FormatToolkit.getPackage((IMCPackage)mcPackage);
    }

    protected final int getColumn() {
        return this.column;
    }

    public final void flush() throws IOException {
        this.out.write(this.builder.toString());
        this.out.flush();
        this.builder.setLength(0);
    }

    public final void writeIndent() {
        this.builder.append(this.indentionArray, 0, this.indent);
        this.column += this.indent;
    }

    public final void writeln() {
        this.builder.append(LINE_SEPARATOR);
        this.column = 0;
    }

    public final void write(String ... texts) {
        for (String text : texts) {
            this.write(text);
        }
    }

    public final void writeAsString(Object o) {
        this.write(String.valueOf(o));
    }

    public final void write(String text) {
        this.builder.append(text);
        this.column += text.length();
    }

    public final void write(char c) {
        this.builder.append(c);
        ++this.column;
    }

    public final void write(int value) {
        this.write(String.valueOf(value));
    }

    public final void indent() {
        this.indent += 2;
        this.updateIndent();
    }

    public final void retract() {
        this.indent -= 2;
        this.updateIndent();
    }

    public final void writeln(String text) {
        this.write(text);
        this.writeln();
    }

    private void updateIndent() {
        if (this.indent > this.indentionArray.length) {
            this.indentionArray = new char[this.indent];
            Arrays.fill(this.indentionArray, ' ');
        }
    }
}

