/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.timing;

import java.util.LinkedList;
import org.jemmy.JemmyException;
import org.jemmy.action.GetAction;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.timing.TimedCriteria;

public class Timeline<T> {
    private LinkedList<TimedAction> list = new LinkedList();
    private Environment env;
    private T control;
    private long startTime = 0L;
    private long tic = 10L;

    public Timeline(long startTime, Environment env, T control) {
        this.startTime = startTime;
        this.env = env;
        this.control = control;
    }

    public Timeline(long startTime, Wrap<? extends T> wrap) {
        this(startTime, wrap.getEnvironment(), wrap.getControl());
    }

    public Timeline(Environment env, T control) {
        this(0L, env, control);
    }

    public Timeline(Wrap<T> wrap) {
        this(wrap.getEnvironment(), wrap.getControl());
    }

    public final synchronized Timeline<T> schedule(long when, TimedCriteria<T> frame) {
        if (when >= 0L) {
            if (this.list.size() > 0) {
                for (int i = 0; i < this.list.size(); ++i) {
                    if (this.list.get((int)i).when < when) continue;
                    this.list.add(i, new TimedAction(frame, when));
                    return this;
                }
                this.list.add(new TimedAction(frame, when));
            } else {
                this.list.add(new TimedAction(frame, when));
            }
        }
        return this;
    }

    public final synchronized Timeline<T> schedule(long start, long until, long delta, TimedCriteria<T> frame) {
        long when = start;
        do {
            this.schedule(when, frame);
        } while ((when += delta) <= until);
        return this;
    }

    synchronized TimedAction next(long until) {
        if (this.list.get((int)0).when <= until) {
            return this.remove();
        }
        return null;
    }

    synchronized TimedAction remove() {
        return this.list.removeFirst();
    }

    public void start() {
        if (this.startTime > 0L) {
            long before = System.currentTimeMillis();
            while (System.currentTimeMillis() < this.startTime + before) {
                try {
                    Thread.sleep(this.tic);
                }
                catch (InterruptedException ex) {
                    throw new JemmyException("Sleep interrupted.", ex);
                }
            }
        }
        long start = System.currentTimeMillis();
        while (this.hasMore()) {
            long now = System.currentTimeMillis() - start;
            TimedAction next = this.next(now);
            if (next != null) {
                this.env.getExecutor().execute(this.env, true, next, now);
                if (!((Boolean)next.getResult()).booleanValue()) {
                    throw new JemmyException("Check failed on " + now + ":", next.criteria);
                }
            }
            try {
                Thread.sleep(this.tic);
            }
            catch (InterruptedException ex) {
                throw new JemmyException("Sleep interrupted.", ex);
            }
        }
    }

    public boolean hasMore() {
        return this.list.size() > 0;
    }

    private class TimedAction
    extends GetAction<Boolean> {
        long when;
        TimedCriteria<T> criteria;

        public TimedAction(TimedCriteria<T> criteria, long when) {
            this.criteria = criteria;
            this.when = when;
        }

        @Override
        public void run(Object ... parameters) {
            this.setResult(this.criteria.check(Timeline.this.control, (Long)parameters[0]));
        }
    }
}

