/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree.traversal;

import java.util.LinkedList;
import java.util.Queue;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeVisitor;
import org.openjdk.jmc.flightrecorder.rules.tree.ItemTreeToolkit;

public abstract class BFTreeVisitor<T>
implements ITreeVisitor<T> {
    private Queue<ITreeNode<T>> next = new LinkedList<ITreeNode<T>>();

    @Override
    public void visit(ITreeNode<T> node) {
        this.processPayload(node.getValue(), ItemTreeToolkit.getDepth(node));
        this.next.addAll(node.getChildren());
        while (!this.next.isEmpty()) {
            ITreeNode<T> nextNode = this.next.poll();
            nextNode.accept(this);
        }
    }

    protected abstract void processPayload(T var1, int var2);
}

