/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public abstract class AbstractRule
implements IRule {
    protected FutureTask<IResult> evaluationTask;
    private final String id;
    private final String name;
    private final String topic;
    private final Collection<TypedPreference<?>> configAttributes;
    private final Collection<TypedResult<?>> resultAttributes;
    private final Map<String, RulesToolkit.EventAvailability> requiredEvents;

    public AbstractRule(String id, String name, String topic, Collection<TypedPreference<?>> configAttributes, Collection<TypedResult<?>> resultAttributes, Map<String, RulesToolkit.EventAvailability> requiredEvents) {
        this.id = id;
        this.name = name;
        this.topic = topic;
        this.configAttributes = configAttributes;
        this.resultAttributes = resultAttributes;
        this.requiredEvents = requiredEvents;
    }

    protected abstract IResult getResult(IItemCollection var1, IPreferenceValueProvider var2, IResultValueProvider var3);

    @Override
    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return AbstractRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        this.evaluationTask = evaluationTask;
        return evaluationTask;
    }

    @Override
    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return this.configAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Collection<TypedResult<?>> getResults() {
        return this.resultAttributes;
    }

    @Override
    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return this.requiredEvents;
    }
}

