/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.general.VerifyNoneRule;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.MockEventCollection;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.VMInfoTestEvent;

public class VerifyNoneRuleTest {
    @Test
    public void verifyNone_jvmArguments() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("-Xverify:none", "")};
        this.testVerifyNoneRule(testEvents, "The application ran with bytecode verification disabled with '-Xverify:none' argument. Disabling bytecode verification is unsafe and should not be done in a production system. If it is not necessary for the application, then dont use -Xverify:none or -noverify on the command line. See the [Secure Coding Standard for Java](https://www.securecoding.cert.org/confluence/display/java/ENV04-J.+Do+not+disable+bytecode+verification).");
    }

    @Test
    public void verifyNone_javaArguments() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("", "-Xverify:none")};
        this.testVerifyNoneRule(testEvents, "The application ran with bytecode verification disabled with '-Xverify:none' argument. Disabling bytecode verification is unsafe and should not be done in a production system. If it is not necessary for the application, then dont use -Xverify:none or -noverify on the command line. See the [Secure Coding Standard for Java](https://www.securecoding.cert.org/confluence/display/java/ENV04-J.+Do+not+disable+bytecode+verification).");
    }

    @Test
    public void noVerify_jvmArguments() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("-noverify", "")};
        this.testVerifyNoneRule(testEvents, "The application ran with bytecode verification disabled with '-noverify' argument. Disabling bytecode verification is unsafe and should not be done in a production system. If it is not necessary for the application, then dont use -Xverify:none or -noverify on the command line. See the [Secure Coding Standard for Java](https://www.securecoding.cert.org/confluence/display/java/ENV04-J.+Do+not+disable+bytecode+verification).");
    }

    @Test
    public void noVerify_javaArguments() {
        TestEvent[] testEvents = new TestEvent[]{new VMInfoTestEvent("", "-noverify")};
        this.testVerifyNoneRule(testEvents, "The application ran with bytecode verification disabled with '-noverify' argument. Disabling bytecode verification is unsafe and should not be done in a production system. If it is not necessary for the application, then dont use -Xverify:none or -noverify on the command line. See the [Secure Coding Standard for Java](https://www.securecoding.cert.org/confluence/display/java/ENV04-J.+Do+not+disable+bytecode+verification).");
    }

    private void testVerifyNoneRule(TestEvent[] testEvents, String descriptionExpected) {
        MockEventCollection events = new MockEventCollection(testEvents);
        VerifyNoneRule verifyNoneRule = new VerifyNoneRule();
        RunnableFuture future = verifyNoneRule.createEvaluation((IItemCollection)events, IPreferenceValueProvider.DEFAULT_VALUES, (IResultValueProvider)new ResultProvider());
        try {
            future.run();
            IResult res = (IResult)future.get();
            String longDesc = ResultToolkit.populateMessage((IResult)res, (String)res.getExplanation(), (boolean)false);
            Assert.assertEquals((Object)descriptionExpected, (Object)longDesc);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

