/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEventItem;

public class MockEventCollection
implements IItemCollection {
    private final List<TestEventItem> items = new ArrayList<TestEventItem>();

    public MockEventCollection(TestEvent[] values) {
        for (TestEvent value : values) {
            this.items.add(new TestEventItem(value));
        }
    }

    public IItemCollection apply(IItemFilter filter) {
        ArrayList<TestEvent> newEntries = new ArrayList<TestEvent>();
        for (TestEventItem item : this.items) {
            if (!filter.getPredicate(item.getType()).test(item)) continue;
            newEntries.add(item.getEvent());
        }
        return new MockEventCollection(newEntries.toArray(new TestEvent[0]));
    }

    public Iterator<IItemIterable> iterator() {
        return Collections.unmodifiableList(this.items).iterator();
    }

    public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
        return MockEventCollection.aggregate(aggregator, this.items.iterator());
    }

    private static <V, C extends IItemConsumer<C>> V aggregate(final IAggregator<V, C> aggregator, final Iterator<? extends IItem> items) {
        return (V)aggregator.getValue((Object)new Iterator<C>(){
            TestEventItem next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public C next() {
                IItemConsumer calc = aggregator.newItemConsumer(this.next.getType());
                calc.consume((IItem)this.next);
                this.next = this.findNext();
                return calc;
            }

            TestEventItem findNext() {
                while (items.hasNext()) {
                    TestEventItem ii = (TestEventItem)items.next();
                    if (!aggregator.acceptType(ii.getType())) continue;
                    return ii;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public Set<IRange<IQuantity>> getUnfilteredTimeRanges() {
        return null;
    }
}

