/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.browser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jemmy.control.ControlInterfaces;
import org.jemmy.control.Property;
import org.jemmy.control.Wrap;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.InterfaceException;

public class InterfacesPanel
extends JPanel {
    private static final String OFFSET = "    ";
    Wrap<?> wrap;
    DefaultTableModel tableModel = new DefaultTableModel();
    private JTable interfacesTable;
    private JScrollPane jScrollPane1;

    public InterfacesPanel() {
        this.tableModel.addColumn("Interface/Property");
        this.tableModel.addColumn("Class/Value");
        this.initComponents();
    }

    public void setWrap(Wrap<?> wrap) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.wrap = wrap;
        this.buildModel();
        this.revalidate();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.interfacesTable = new JTable();
        this.interfacesTable.setModel(this.getTableModel());
        this.jScrollPane1.setViewportView(this.interfacesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 481, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 480, Short.MAX_VALUE));
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    private void buildModel() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        while (this.getTableModel().getRowCount() > 0) {
            this.getTableModel().removeRow(0);
        }
        Class<?> cls = this.wrap.getClass();
        ArrayList<Class> interfaces = new ArrayList<Class>();
        do {
            ControlInterfaces cis = cls.getAnnotation(ControlInterfaces.class);
            for (Class c : cis.value()) {
                if (interfaces.contains(c)) continue;
                interfaces.add(c);
            }
        } while (Wrap.class.isAssignableFrom(cls = cls.getSuperclass()));
        Collections.sort(interfaces, new Comparator(){

            public int compare(Object t, Object t1) {
                return t.toString().compareTo(t1.toString());
            }
        });
        for (Class c : interfaces) {
            String iName = c.getName();
            try {
                ControlInterface iInstance = this.wrap.as(c);
                this.getTableModel().addRow(new Object[]{iName, iInstance.getClass().getName()});
                for (Method m : c.getMethods()) {
                    if (!m.isAnnotationPresent(Property.class)) continue;
                    String name = m.getAnnotation(Property.class).value();
                    this.getTableModel().addRow(new Object[]{OFFSET + name, this.wrap.getProperty(name, c)});
                }
            }
            catch (InterfaceException interfaceException) {
            }
        }
    }
}

