/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.dot.test;

import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.TestToolkit;
import org.openjdk.jmc.common.test.io.IOResource;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.serializers.dot.DotSerializer;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.StacktraceGraphModel;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;

public class DotSerializerTest {
    @Test
    public void testGetRecording() throws IOException, CouldNotLoadRecordingException {
        IItemCollection collection = RecordingToolkit.getFlightRecording((IOResource)TestToolkit.getNamedResource(DotSerializerTest.class, (String)"recordings", (String)"hotmethods.jfr"));
        Assert.assertNotNull((Object)collection);
        String dot = DotSerializer.toDot((StacktraceGraphModel)new StacktraceGraphModel(new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false), collection, null), (int)Integer.MAX_VALUE, (Map)DotSerializer.getDefaultConfiguration());
        Assert.assertTrue((String)"Dot file should contain digraph element", (boolean)dot.contains("digraph"));
        Assert.assertTrue((String)"Dot file should contain at least 50 nodes", (boolean)dot.contains("N50"));
        Assert.assertTrue((String)"Dot file should contain a link between N1 and N2", (boolean)dot.contains("N1 -> N2"));
    }
}

