/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.booterclient.DefaultForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ModularClasspath;
import org.apache.maven.surefire.booter.ModularClasspathConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class ModularClasspathForkConfiguration
extends DefaultForkConfiguration {
    public ModularClasspathForkConfiguration(@Nonnull Classpath bootClasspath, @Nonnull File tempDirectory, @Nullable String debugLine, @Nonnull File workingDirectory, @Nonnull Properties modelProperties, @Nullable String argLine, @Nonnull Map<String, String> environmentVariables, boolean debug, @Nonnegative int forkCount, boolean reuseForks, @Nonnull Platform pluginPlatform, @Nonnull ConsoleLogger log) {
        super(bootClasspath, tempDirectory, debugLine, workingDirectory, modelProperties, argLine, environmentVariables, debug, forkCount, reuseForks, pluginPlatform, log);
    }

    @Override
    protected void resolveClasspath(@Nonnull OutputStreamFlushableCommandline cli, @Nonnull String startClass, @Nonnull StartupConfiguration config) throws SurefireBooterForkException {
        try {
            AbstractPathConfiguration pathConfig = config.getClasspathConfiguration();
            ModularClasspathConfiguration modularClasspathConfiguration = (ModularClasspathConfiguration)pathConfig.toRealPath(ModularClasspathConfiguration.class);
            ModularClasspath modularClasspath = modularClasspathConfiguration.getModularClasspath();
            File descriptor = modularClasspath.getModuleDescriptor();
            List modulePath = modularClasspath.getModulePath();
            Collection packages = modularClasspath.getPackages();
            File patchFile = modularClasspath.getPatchFile();
            List<String> classpath = this.toCompleteClasspath(config);
            File argsFile = this.createArgsFile(descriptor, modulePath, classpath, packages, patchFile, startClass);
            cli.createArg().setValue("@" + SurefireHelper.escapeToPlatformPath(argsFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating args file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    File createArgsFile(@Nonnull File moduleDescriptor, @Nonnull List<String> modulePath, @Nonnull List<String> classPath, @Nonnull Collection<String> packages, @Nonnull File patchFile, @Nonnull String startClassName) throws IOException {
        File surefireArgs = File.createTempFile("surefireargs", "", this.getTempDirectory());
        if (!this.isDebug()) {
            surefireArgs.deleteOnExit();
        }
        BufferedWriter writer = null;
        try {
            Iterator<String> it;
            writer = new BufferedWriter(new FileWriter(surefireArgs));
            if (!modulePath.isEmpty()) {
                writer.write("--module-path");
                writer.newLine();
                it = modulePath.iterator();
                while (it.hasNext()) {
                    writer.append(it.next());
                    if (!it.hasNext()) continue;
                    writer.append(File.pathSeparatorChar);
                }
                writer.newLine();
            }
            if (!classPath.isEmpty()) {
                writer.write("--class-path");
                writer.newLine();
                it = classPath.iterator();
                while (it.hasNext()) {
                    writer.append(it.next());
                    if (!it.hasNext()) continue;
                    writer.append(File.pathSeparatorChar);
                }
                writer.newLine();
            }
            String moduleName = this.toModuleName(moduleDescriptor);
            writer.write("--patch-module");
            writer.newLine();
            writer.append(moduleName).append('=').append(patchFile.getPath());
            writer.newLine();
            for (String pkg : packages) {
                writer.write("--add-exports");
                writer.newLine();
                writer.append(moduleName).append('/').append(pkg).append('=').append("ALL-UNNAMED");
                writer.newLine();
            }
            writer.write("--add-modules");
            writer.newLine();
            writer.append(moduleName);
            writer.newLine();
            writer.write("--add-reads");
            writer.newLine();
            writer.append(moduleName).append('=').append("ALL-UNNAMED");
            writer.newLine();
            writer.write(startClassName);
            writer.newLine();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return surefireArgs;
    }

    @Nonnull
    String toModuleName(@Nonnull File moduleDescriptor) throws IOException {
        if (!moduleDescriptor.isFile()) {
            throw new IOException("No such Jigsaw module-descriptor exists " + moduleDescriptor.getAbsolutePath());
        }
        final StringBuilder sb = new StringBuilder();
        new ClassReader((InputStream)new FileInputStream(moduleDescriptor)).accept(new ClassVisitor(393216){

            public ModuleVisitor visitModule(String name, int access, String version) {
                sb.setLength(0);
                sb.append(name);
                return super.visitModule(name, access, version);
            }
        }, 0);
        return sb.toString();
    }
}

