/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.test.unit.AdHocQuantityTest;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;

public class QuantityArithmeticsTest
extends MCTestCase {
    private static long BIG_LONG = 0x2000000000000001L;
    private IUnit y;
    private IUnit d;
    private IUnit h;
    private IUnit min;
    private IUnit s;
    private IUnit ms;
    private IUnit ns;
    private IUnit ps;
    private IUnit msBiased;

    @Before
    public void setUp() throws Exception {
        this.y = UnitLookup.TIMESPAN.getUnit("a");
        this.h = UnitLookup.TIMESPAN.getUnit("h");
        this.d = UnitLookup.TIMESPAN.getUnit("d");
        this.min = UnitLookup.MINUTE;
        this.s = UnitLookup.SECOND;
        this.ms = UnitLookup.MILLISECOND;
        this.ns = UnitLookup.NANOSECOND;
        this.ps = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.PICO);
        this.msBiased = UnitLookup.EPOCH_MS;
    }

    protected void assertSum(IQuantity expectedSum, IQuantity a, IQuantity b) {
        IQuantity sum = a.add(b);
        String msg = null;
        if (!expectedSum.equals(sum)) {
            msg = a + " + " + b + " =";
        }
        AdHocQuantityTest.assertNearlySame(msg, expectedSum, sum);
        Assert.assertEquals(msg, (Object)expectedSum, (Object)sum);
    }

    protected void assertDiff(IQuantity expectedDiff, IQuantity a, IQuantity b) {
        IQuantity diff = a.subtract(b);
        String msg = null;
        if (!expectedDiff.equals(diff)) {
            msg = a + " - " + b + " =";
        }
        AdHocQuantityTest.assertNearlySame(msg, expectedDiff, diff);
        Assert.assertEquals(msg, (Object)expectedDiff, (Object)diff);
    }

    @Test
    public void testBigLong() {
        Assert.assertFalse((BIG_LONG + 1L == BIG_LONG ? 1 : 0) != 0);
        Assert.assertEquals((double)BIG_LONG, (double)((double)BIG_LONG + 1.0), (double)0.0);
        Assert.assertTrue((BIG_LONG * 2L > BIG_LONG ? 1 : 0) != 0);
        Assert.assertFalse((BIG_LONG * 4L > BIG_LONG * 2L ? 1 : 0) != 0);
    }

    @Test
    public void testDurationLongSum() {
        this.assertSum(this.s.quantity(100L), this.s.quantity(17L), this.s.quantity(83L));
        this.assertSum(this.s.quantity(BIG_LONG + 1L), this.s.quantity(BIG_LONG), this.s.quantity(1L));
        this.assertSum(this.s.quantity(BIG_LONG + 1L), this.s.quantity(1L), this.s.quantity(BIG_LONG));
    }

    @Test
    public void testDurationDoubleSum() {
        this.assertSum(this.s.quantity(100.0), this.s.quantity(17.0), this.s.quantity(83.0));
    }

    @Test
    public void testDurationMixSum() {
        this.assertSum(this.s.quantity(100.0), this.s.quantity(17.0), this.s.quantity(83L));
        this.assertSum(this.s.quantity(100.0), this.s.quantity(17L), this.s.quantity(83.0));
    }

    @Test
    public void testDurationLongDiff() {
        this.assertDiff(this.s.quantity(42L), this.s.quantity(59L), this.s.quantity(17L));
        this.assertDiff(this.s.quantity(1L), this.s.quantity(BIG_LONG + 1L), this.s.quantity(BIG_LONG));
    }

    @Test
    public void testDurationDoubleDiff() {
        this.assertDiff(this.s.quantity(42.0), this.s.quantity(59.0), this.s.quantity(17.0));
    }

    @Test
    public void testDurationMixDiff() {
        this.assertDiff(this.s.quantity(42.0), this.s.quantity(59.0), this.s.quantity(17L));
        this.assertDiff(this.s.quantity(42.0), this.s.quantity(59L), this.s.quantity(17.0));
    }

    @Test
    public void testTimestampSum() {
        try {
            this.assertSum(this.msBiased.quantity(100L), this.msBiased.quantity(17L), this.msBiased.quantity(83L));
            Assert.fail((String)"Shouldn't be possible to add two timestamps!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTimestampPlusDuration() {
        this.assertSum(this.msBiased.quantity(100L), this.msBiased.quantity(17L), this.ms.quantity(83L));
        this.assertSum(this.msBiased.quantity(BIG_LONG + 1L), this.msBiased.quantity(BIG_LONG), this.ms.quantity(1L));
        this.assertSum(this.msBiased.quantity(BIG_LONG + 1L), this.msBiased.quantity(1L), this.ms.quantity(BIG_LONG));
    }

    @Test
    public void testDurationPlusTimestamp() {
        this.assertSum(this.msBiased.quantity(100L), this.ms.quantity(17L), this.msBiased.quantity(83L));
        this.assertSum(this.msBiased.quantity(BIG_LONG + 1L), this.ms.quantity(1L), this.msBiased.quantity(BIG_LONG));
        this.assertSum(this.msBiased.quantity(BIG_LONG + 1L), this.ms.quantity(BIG_LONG), this.msBiased.quantity(1L));
    }

    @Test
    public void testTimestampDiff() {
        this.assertDiff(this.ms.quantity(42L), this.msBiased.quantity(59L), this.msBiased.quantity(17L));
        this.assertDiff(this.ms.quantity(1L), this.msBiased.quantity(BIG_LONG + 1L), this.msBiased.quantity(BIG_LONG));
    }

    @Test
    public void testMillisPlusSeconds() {
        this.assertSum(this.ms.quantity(1001L), this.ms.quantity(1L), this.s.quantity(1L));
        this.assertSum(this.ms.quantity(2003L), this.ms.quantity(3L), this.s.quantity(2L));
        this.assertSum(this.ms.quantity(BIG_LONG / 1000L * 1000L + 3L), this.ms.quantity(3L), this.s.quantity(BIG_LONG / 1000L));
        this.assertSum(this.ms.quantity((double)BIG_LONG * 1000.0), this.ms.quantity(3L), this.s.quantity(BIG_LONG));
    }

    @Test
    public void testSecondsPlusMillis() {
        this.assertSum(this.ms.quantity(1001L), this.s.quantity(1L), this.ms.quantity(1L));
        this.assertSum(this.ms.quantity(2003L), this.s.quantity(2L), this.ms.quantity(3L));
        this.assertSum(this.ms.quantity(BIG_LONG / 1000L * 1000L + 3L), this.s.quantity(BIG_LONG / 1000L), this.ms.quantity(3L));
        this.assertSum(this.ms.quantity((double)BIG_LONG * 1000.0), this.s.quantity(BIG_LONG), this.ms.quantity(3L));
    }

    @Test
    public void testMinutesPlusSeconds() {
        this.assertSum(this.s.quantity(61L), this.min.quantity(1L), this.s.quantity(1L));
        this.assertSum(this.s.quantity(123L), this.min.quantity(2L), this.s.quantity(3L));
    }

    @Test
    public void testSecondsPlusMinutes() {
        this.assertSum(this.s.quantity(61L), this.s.quantity(1L), this.min.quantity(1L));
        this.assertSum(this.s.quantity(123L), this.s.quantity(3L), this.min.quantity(2L));
    }

    @Test
    public void testHoursPlusMinutes() {
        this.assertSum(this.min.quantity(61L), this.h.quantity(1L), this.min.quantity(1L));
        this.assertSum(this.min.quantity(123L), this.h.quantity(2L), this.min.quantity(3L));
        this.assertSum(this.min.quantity(BIG_LONG / 60L * 60L + 3L), this.min.quantity(3L), this.h.quantity(BIG_LONG / 60L));
        this.assertSum(this.min.quantity((double)BIG_LONG * 60.0), this.min.quantity(3L), this.h.quantity(BIG_LONG));
    }

    @Test
    public void testMinutesPlusHours() {
        this.assertSum(this.min.quantity(61L), this.min.quantity(1L), this.h.quantity(1L));
        this.assertSum(this.min.quantity(123L), this.min.quantity(3L), this.h.quantity(2L));
        this.assertSum(this.min.quantity(BIG_LONG / 60L * 60L + 3L), this.h.quantity(BIG_LONG / 60L), this.min.quantity(3L));
        this.assertSum(this.min.quantity((double)BIG_LONG * 60.0), this.h.quantity(BIG_LONG), this.min.quantity(3L));
    }

    @Test
    public void testHourAddition() {
        this.assertSum(this.h.quantity(BIG_LONG * 2L), this.h.quantity(BIG_LONG), this.h.quantity(BIG_LONG));
        this.assertSum(this.h.quantity((double)BIG_LONG * 4.0), this.h.quantity(BIG_LONG * 2L), this.h.quantity(BIG_LONG * 2L));
    }

    @Test
    public void testMillisPlusMinutes() {
        this.assertSum(this.ms.quantity(60001L), this.ms.quantity(1L), this.min.quantity(1L));
        this.assertSum(this.ms.quantity(120003L), this.ms.quantity(3L), this.min.quantity(2L));
    }

    @Test
    public void testMinutesPlusMillis() {
        this.assertSum(this.ms.quantity(60001L), this.min.quantity(1L), this.ms.quantity(1L));
        this.assertSum(this.ms.quantity(120003L), this.min.quantity(2L), this.ms.quantity(3L));
    }

    @Test
    public void testDaysPlusNanos() {
        this.assertSum(this.ns.quantity(86400000000003L), this.d.quantity(1L), this.ns.quantity(3L));
    }

    @Test
    public void testYearsPlusHours() {
        this.assertSum(this.h.quantity(8790L), this.y.quantity(1L), this.h.quantity(24L));
    }

    @Test
    public void testYearsPlusDays() {
        this.assertSum(this.d.quantity(366.25), this.y.quantity(1L), this.d.quantity(1L));
    }

    @Test
    public void testYearsPlusPicos() {
        this.assertSum(this.ps.quantity(3.15576E19), this.y.quantity(1L), this.ps.quantity(3L));
    }
}

