/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.test.io.IOResource;

public final class JarFileResource
implements IOResource {
    private final JarEntry m_jarEntry;
    private final JarFile m_file;

    public JarFileResource(JarFile file, JarEntry jarEntry) {
        this.m_file = file;
        this.m_jarEntry = jarEntry;
    }

    @Override
    public InputStream open() throws IOException {
        return this.m_file.getInputStream(this.m_jarEntry);
    }

    @Override
    public void close() {
        IOToolkit.closeSilently((Closeable)this.m_file);
    }

    @Override
    public String getName() {
        String name = this.m_jarEntry.getName();
        int index = name.lastIndexOf(47);
        return name.substring(index + 1);
    }

    public String toString() {
        return this.getName();
    }
}

