/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

public class TypeUtils {
    private static final Map<Types.Builtin, List<Object>> BUILTIN_VALUES_MAP = new HashMap<Types.Builtin, List<Object>>();

    public static <T> List<T> getBuiltinValues(Types.Builtin target) {
        return BUILTIN_VALUES_MAP.get(target);
    }

    static {
        BUILTIN_VALUES_MAP.put(Types.Builtin.BOOLEAN, Arrays.asList(true, false));
        BUILTIN_VALUES_MAP.put(Types.Builtin.BYTE, Collections.singletonList((byte)18));
        BUILTIN_VALUES_MAP.put(Types.Builtin.CHAR, Collections.singletonList(Character.valueOf('h')));
        BUILTIN_VALUES_MAP.put(Types.Builtin.SHORT, Collections.singletonList((short)4));
        BUILTIN_VALUES_MAP.put(Types.Builtin.INT, Collections.singletonList(7));
        BUILTIN_VALUES_MAP.put(Types.Builtin.LONG, Collections.singletonList(1256L));
        BUILTIN_VALUES_MAP.put(Types.Builtin.FLOAT, Collections.singletonList(Float.valueOf(3.14f)));
        BUILTIN_VALUES_MAP.put(Types.Builtin.DOUBLE, Collections.singletonList(Math.sqrt(2.0)));
        BUILTIN_VALUES_MAP.put(Types.Builtin.STRING, Arrays.asList(null, "", "hello"));
    }
}

