/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt.lookup;

import java.lang.reflect.Method;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jemmy.resources.StringComparePolicy;
import org.jemmy.swt.lookup.QueueLookup;

public class ByItemToolTipLookup<T extends Composite>
extends QueueLookup<T> {
    private final StringComparePolicy policy;
    private final String text;

    public ByItemToolTipLookup(String text) {
        this(text, StringComparePolicy.SUBSTRING);
    }

    protected ByItemToolTipLookup(String text, StringComparePolicy policy) {
        this.policy = policy;
        this.text = text;
    }

    @Override
    public boolean doCheck(T control) {
        ToolItem[] items = null;
        if (ToolBar.class.isInstance(control)) {
            items = ((ToolBar)ToolBar.class.cast(control)).getItems();
        } else if (CTabFolder.class.isInstance(control)) {
            items = ((CTabFolder)CTabFolder.class.cast(control)).getItems();
        } else if (TabFolder.class.isInstance(control)) {
            items = ((TabFolder)TabFolder.class.cast(control)).getItems();
        } else {
            System.err.println("Class " + control.getClass() + " does not match any supported class in ByItemLookup");
            return false;
        }
        try {
            for (ToolItem item : items) {
                Method mthd = item.getClass().getMethod("getToolTipText", new Class[0]);
                if (!this.policy.compare(this.text, (String)mthd.invoke((Object)item, new Object[0]))) continue;
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Exception when using reflection to get tooltip text from items of " + control);
            e.printStackTrace();
        }
        return false;
    }
}

