/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jemmy.Point;
import org.jemmy.action.GetAction;
import org.jemmy.control.ControlType;
import org.jemmy.control.Property;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.input.StringTree;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.Focusable;
import org.jemmy.interfaces.Parent;
import org.jemmy.interfaces.Selector;
import org.jemmy.interfaces.TypeControlInterface;
import org.jemmy.swt.ItemParent;
import org.jemmy.swt.SWTTree;
import org.jemmy.swt.ScrollableWrap;
import org.jemmy.swt.input.KeyboardSelectable;
import org.jemmy.swt.input.KeyboardSelector;

@ControlType(value={Tree.class})
public class TreeWrap<T extends Tree>
extends ScrollableWrap<T>
implements KeyboardSelectable<String>,
Focusable {
    private KeyboardSelector<String> selector = null;
    private ItemParent<TreeItem> items;
    private SWTTree tree = null;

    public TreeWrap(Environment env, T node) {
        super(env, node);
    }

    private void addItems(TreeItem[] items, LinkedList<TreeItem> list) {
        for (TreeItem item : items) {
            list.add(item);
            if (!item.getExpanded()) continue;
            this.addItems(item.getItems(), list);
        }
    }

    public List<TreeItem> getItems() {
        return (List)new GetAction<List<TreeItem>>(){

            public void run(Object ... parameters) throws Exception {
                LinkedList res = new LinkedList();
                TreeWrap.this.addItems(((Tree)TreeWrap.this.getControl()).getItems(), res);
                this.setResult(res);
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    public TreeItem getSelectedItem() {
        return (TreeItem)new GetAction<TreeItem>(){

            public void run(Object ... parameters) throws Exception {
                if (((Tree)TreeWrap.this.getControl()).getSelection().length > 0) {
                    this.setResult(((Tree)TreeWrap.this.getControl()).getSelection()[0]);
                } else {
                    this.setResult(null);
                }
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    @Override
    public int selection() {
        return (Integer)new GetAction<Integer>(){

            public void run(Object ... parameters) throws Exception {
                if (((Tree)TreeWrap.this.getControl()).getSelection().length > 0) {
                    TreeItem selection = ((Tree)TreeWrap.this.getControl()).getSelection()[0];
                    this.setResult(0);
                    if (selection != null) {
                        List<TreeItem> items = TreeWrap.this.getItems();
                        for (int i = 0; i < items.size(); ++i) {
                            if (items.get(i) != selection) continue;
                            this.setResult(i);
                        }
                    }
                } else {
                    this.setResult(0);
                }
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    @Override
    public boolean isVertical() {
        return true;
    }

    @Override
    public int index(TreeItem item) {
        return this.getItems().indexOf(item);
    }

    public Selector<String> selector() {
        if (this.selector == null) {
            this.selector = new KeyboardSelector<String>(this, this);
        }
        return this.selector;
    }

    public Class<String> getType() {
        return String.class;
    }

    @Property(value="clickPoint")
    public Point getClickPoint() {
        return new Point(this.getScreenBounds().getWidth() / 2.0, 1.0);
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> INTERFACE as(Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        if (interfaceClass.equals(Parent.class) && TreeItem.class.equals(type)) {
            if (this.items == null) {
                this.items = new ItemParent<TreeItem>((Wrap)this, TreeItem.class){

                    @Override
                    protected List<TreeItem> getItems() {
                        return TreeWrap.this.getItems();
                    }
                };
            }
            return (INTERFACE)((Object)this.items);
        }
        if (org.jemmy.interfaces.Tree.class.isAssignableFrom(interfaceClass) && interfaceClass.isAssignableFrom(StringTree.class) && TreeItem.class.equals(type)) {
            if (this.tree == null) {
                this.tree = new SWTTree(this);
            }
            return (INTERFACE)((Object)this.tree);
        }
        return (INTERFACE)super.as(interfaceClass, type);
    }

    @Override
    public <INTERFACE extends ControlInterface> INTERFACE as(Class<INTERFACE> interfaceClass) {
        if (org.jemmy.interfaces.Tree.class.isAssignableFrom(interfaceClass) && interfaceClass.isAssignableFrom(StringTree.class)) {
            if (this.tree == null) {
                this.tree = new SWTTree(this);
            }
            return (INTERFACE)((Object)this.tree);
        }
        return super.as(interfaceClass);
    }

    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> boolean is(Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        if (interfaceClass.equals(Parent.class) && TreeItem.class.equals(type)) {
            return true;
        }
        if (org.jemmy.interfaces.Tree.class.isAssignableFrom(interfaceClass) && interfaceClass.isAssignableFrom(StringTree.class) && TreeItem.class.equals(type)) {
            return true;
        }
        return super.is(interfaceClass, type);
    }

    @Override
    public <INTERFACE extends ControlInterface> boolean is(Class<INTERFACE> interfaceClass) {
        if (org.jemmy.interfaces.Tree.class.isAssignableFrom(interfaceClass) && interfaceClass.isAssignableFrom(StringTree.class)) {
            return true;
        }
        return super.is(interfaceClass);
    }

    @Override
    public int index(String item) {
        return this.getStates().indexOf(item);
    }

    @Property(value="states")
    public List<String> getStates() {
        return (List)new GetAction<List<String>>(){

            public void run(Object ... parameters) throws Exception {
                List<TreeItem> itms = TreeWrap.this.getItems();
                ArrayList res = new ArrayList(itms.size());
                itms.stream().forEach(i -> res.add(i.getText()));
                this.setResult(res);
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    @Property(value="state")
    public String getState() {
        return (String)new GetAction<String>(){

            public void run(Object ... parameters) throws Exception {
                this.setResult(TreeWrap.this.getSelectedItem() == null ? "" : TreeWrap.this.getSelectedItem().getText());
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }
}

