/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.jemmy.action.Action;
import org.jemmy.action.GetAction;
import org.jemmy.control.ControlType;
import org.jemmy.control.Property;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.input.SelectionText;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.Focusable;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Modifier;
import org.jemmy.interfaces.Selector;
import org.jemmy.swt.ControlWrap;
import org.jemmy.swt.input.KeyboardSelectable;
import org.jemmy.swt.input.KeyboardSelector;

@ControlType(value={Combo.class})
public class ComboWrap<T extends Combo>
extends ControlWrap<T>
implements KeyboardSelectable<String>,
Focusable {
    public static final String DISMISSAL_BUTTON_PROP = ComboWrap.class.getName() + ".dismissal.button";
    public static final String DISMISSAL_MODIFIER_PROP = ComboWrap.class.getName() + ".dismissal.modifier";
    private final Keyboard.KeyboardButtons dismissalButton;
    private final Keyboard.KeyboardModifier[] dismissalModifier;
    FocusableSelectionText text = new FocusableSelectionText(this);
    private ComboKeyboardSelector<String> selector = null;

    public ComboWrap(Environment env, T node) {
        super(env, node);
        Keyboard.KeyboardButtons defaultDismissalButton = System.getProperty("os.name").toLowerCase().contains("windows") ? Keyboard.KeyboardButtons.ESCAPE : Keyboard.KeyboardButtons.SPACE;
        Keyboard.KeyboardModifier[] defaultDismissalModifiers = new Keyboard.KeyboardModifier[]{};
        this.dismissalButton = (Keyboard.KeyboardButtons)env.getProperty(Keyboard.KeyboardButtons.class, (Object)DISMISSAL_BUTTON_PROP, (Object)defaultDismissalButton);
        this.dismissalModifier = (Keyboard.KeyboardModifier[])env.getProperty(Keyboard.KeyboardModifier[].class, (Object)DISMISSAL_MODIFIER_PROP, (Object)defaultDismissalModifiers);
    }

    public List<String> getStates() {
        return (List)new GetAction<List<String>>(){

            public void run(Object ... parameters) throws Exception {
                this.setResult(Arrays.asList(((Combo)ComboWrap.this.getControl()).getItems()));
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    public String getState() {
        return (String)new GetAction<String>(){

            public void run(Object ... parameters) throws Exception {
                if (((Combo)ComboWrap.this.getControl()).getSelectionIndex() >= 0) {
                    this.setResult(((Combo)ComboWrap.this.getControl()).getItem(((Combo)ComboWrap.this.getControl()).getSelectionIndex()));
                } else {
                    this.setResult(null);
                }
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    @Override
    public int selection() {
        return (Integer)new GetAction<Integer>(){

            public void run(Object ... parameters) throws Exception {
                this.setResult(((Combo)ComboWrap.this.getControl()).getSelectionIndex());
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    public Selector<String> selector() {
        if (this.selector == null) {
            this.selector = new ComboKeyboardSelector<String>(this, this);
        }
        return this.selector;
    }

    public Class<String> getType() {
        return String.class;
    }

    @Override
    public boolean isVertical() {
        return true;
    }

    @Override
    public int index(final String item) {
        return (Integer)new GetAction<Integer>(){

            public void run(Object ... parameters) throws Exception {
                this.setResult(((Combo)ComboWrap.this.getControl()).indexOf(item));
            }
        }.dispatch(this.getEnvironment(), new Object[0]);
    }

    @Override
    public ControlWrap.ClickFocus focuser() {
        if (this.focuser == null) {
            super.focuser().clickCount = 2;
        }
        return this.focuser;
    }

    @Override
    public boolean hasFocus() {
        GetAction<Boolean> action = new GetAction<Boolean>(){

            public void run(Object ... parameters) {
                this.setResult(((Combo)ComboWrap.this.getControl()).isFocusControl() || ((Combo)ComboWrap.this.getControl()).getListVisible());
            }

            public String toString() {
                return "Getting focus state for " + ComboWrap.this.getControl();
            }
        };
        this.getEnvironment().getExecutor().execute(this.getEnvironment(), true, (Action)action, new Object[0]);
        return (Boolean)action.getResult();
    }

    @Property(value="position")
    public Integer position() {
        GetAction<Integer> action = new GetAction<Integer>(){

            public void run(Object ... parameters) {
                this.setResult(((Combo)ComboWrap.this.getControl()).getSelection().x);
            }
        };
        this.getEnvironment().getExecutor().execute(this.getEnvironment(), true, (Action)action, new Object[0]);
        return (Integer)action.getResult();
    }

    @Property(value="selection.anchor")
    public Integer anchor() {
        GetAction<Integer> action = new GetAction<Integer>(){

            public void run(Object ... parameters) {
                Point selection = ((Combo)ComboWrap.this.getControl()).getSelection();
                this.setResult(selection.x == ((Combo)ComboWrap.this.getControl()).getCaretPosition() ? selection.y : selection.x);
            }
        };
        this.getEnvironment().getExecutor().execute(this.getEnvironment(), true, (Action)action, new Object[0]);
        return (Integer)action.getResult();
    }

    @Override
    @Property(value="text")
    public String text() {
        GetAction<String> action = new GetAction<String>(){

            public void run(Object ... parameters) {
                this.setResult(((Combo)ComboWrap.this.getControl()).getText());
            }
        };
        this.getEnvironment().getExecutor().execute(this.getEnvironment(), true, (Action)action, new Object[0]);
        return (String)action.getResult();
    }

    @Override
    public <INTERFACE extends ControlInterface> boolean is(Class<INTERFACE> interfaceClass) {
        if (interfaceClass.isAssignableFrom(SelectionText.class)) {
            return true;
        }
        if (interfaceClass.equals(Focusable.class)) {
            return true;
        }
        return super.is(interfaceClass);
    }

    @Override
    public <INTERFACE extends ControlInterface> INTERFACE as(Class<INTERFACE> interfaceClass) {
        if (interfaceClass.isAssignableFrom(SelectionText.class)) {
            return (INTERFACE)((Object)this.text);
        }
        if (interfaceClass.isAssignableFrom(Focusable.class)) {
            return (INTERFACE)((Object)this.text);
        }
        return super.as(interfaceClass);
    }

    class FocusableSelectionText
    extends SelectionText
    implements Focusable {
        protected ControlWrap.ClickFocus focuser;
        private final ComboWrap<T> comboWrap;

        public FocusableSelectionText(ComboWrap<T> textWrap) {
            super(textWrap);
            this.comboWrap = textWrap;
        }

        public double position() {
            return this.comboWrap.position().intValue();
        }

        public String text() {
            return this.comboWrap.text();
        }

        public double anchor() {
            return this.comboWrap.anchor().intValue();
        }

        public ControlWrap.ClickFocus focuser() {
            if (this.focuser == null) {
                this.focuser = new ControlWrap.ClickFocus(ComboWrap.this);
            }
            return this.focuser;
        }
    }

    class ComboKeyboardSelector<T>
    extends KeyboardSelector<T> {
        private final Wrap<?> comboWrap;

        public ComboKeyboardSelector(Wrap<?> wrap, KeyboardSelectable<T> control) {
            super(wrap, control);
            this.comboWrap = wrap;
        }

        @Override
        public void select(T state) {
            super.select(state);
            this.comboWrap.keyboard().pushKey((Keyboard.KeyboardButton)ComboWrap.this.dismissalButton, (Modifier[])ComboWrap.this.dismissalModifier);
        }
    }
}

