/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitDiffConsumer
implements StreamConsumer {
    private static final Pattern DIFF_FILES_PATTERN = Pattern.compile("^diff --git\\sa/(.*)\\sb/(.*)");
    private static final String START_REVISION_TOKEN = "---";
    private static final String END_REVISION_TOKEN = "+++";
    private static final String ADDED_LINE_TOKEN = "+";
    private static final String REMOVED_LINE_TOKEN = "-";
    private static final String UNCHANGED_LINE_TOKEN = " ";
    private static final String CHANGE_SEPARATOR_TOKEN = "@@";
    private static final String NO_NEWLINE_TOKEN = "\\ No newline at end of file";
    private static final String INDEX_LINE_TOKEN = "index ";
    private static final String NEW_FILE_MODE_TOKEN = "new file mode ";
    private static final String DELETED_FILE_MODE_TOKEN = "deleted file mode ";
    private ScmLogger logger;
    private String currentFile;
    private StringBuilder currentDifference;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private Map<String, CharSequence> differences = new HashMap<String, CharSequence>();
    private StringBuilder patch = new StringBuilder();

    public GitDiffConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
    }

    public void consumeLine(String line) {
        Matcher matcher = DIFF_FILES_PATTERN.matcher(line);
        if (matcher.matches()) {
            this.currentFile = matcher.group(1);
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.MODIFIED));
            this.currentDifference = new StringBuilder();
            this.differences.put(this.currentFile, this.currentDifference);
            this.patch.append(line).append("\n");
            return;
        }
        if (this.currentFile == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unparseable line: '" + line + "'");
            }
            this.patch.append(line).append("\n");
            return;
        }
        if (line.startsWith(INDEX_LINE_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(NEW_FILE_MODE_TOKEN) || line.startsWith(DELETED_FILE_MODE_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(START_REVISION_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(END_REVISION_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(ADDED_LINE_TOKEN) || line.startsWith(REMOVED_LINE_TOKEN) || line.startsWith(UNCHANGED_LINE_TOKEN) || line.startsWith(CHANGE_SEPARATOR_TOKEN) || line.equals(NO_NEWLINE_TOKEN)) {
            this.currentDifference.append(line).append("\n");
            this.patch.append(line).append("\n");
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unparseable line: '" + line + "'");
            }
            this.patch.append(line).append("\n");
            this.currentFile = null;
            this.currentDifference = null;
        }
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, CharSequence> getDifferences() {
        return this.differences;
    }

    public String getPatch() {
        return this.patch.toString();
    }
}

