# Contributing

Thank you for considering contributing to the
[JDK Mission Control](https://openjdk.java.net/projects/jmc) project! For information 
about contributing to [OpenJDK](https://openjdk.java.net/) projects, which include
JDK Mission Control, please see <https://openjdk.java.net/contribute/>.

## Pull Requests

The JDK Mission Control project (JMC) gladly accepts contributions in the form of pull 
requests on [GitHub](https://github.com/openjdk/jmc/pulls/). Ensure that the commit 
message refers to an existing JMC issue in the [JDK Bug System](https://bugs.openjdk.java.net/).
The format is "&lt;bug id number&gt;: Commit message". For example, for a PR for issue JMC-6789, the commit 
message should be "6789: Commit message".  

## Mailing List

The mailing list for JDK Mission Control is `jmc-dev@openjdk.java.net`. See
<https://mail.openjdk.java.net/mailman/listinfo/jmc-dev> for instructions
on how to subscribe of if you want to read the archives.

## Issues

You can find open issues to work on in the JMC project in the
[JDK Bug System](https://bugs.openjdk.java.net/):
<https://bugs.openjdk.java.net/secure/Dashboard.jspa?selectPageId=13519>.

## Larger Contributions

If you have a larger contribution in mind then we highly encourage you to first
discuss your changes on the JMC mailing list, `jmc-dev@openjdk.java.net`,
_before_ you start to write the code.

## Slack

The slack channel for JMC developers can be found here:
<https://jdkmissioncontrol.slack.com/>

If you're working for a company already contributing, you can sign up here:
<https://jdkmissioncontrol.slack.com/signup>

If not, ask for an invite in the jmc-dev mailing list.

## Questions

If you have a question or need help, please send an email to our mailing list
`jmc-dev@openjdk.java.net` or stop by the JMC slack channel.

