/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class ContainsSelector
extends BaseExtendSelector {
    private String contains = null;
    private boolean casesensitive = true;
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";

    public String toString() {
        StringBuffer buf = new StringBuffer("{containsselector text: ");
        buf.append(this.contains);
        buf.append(" casesensitive: ");
        if (this.casesensitive) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append("}");
        return buf.toString();
    }

    public void setText(String contains) {
        this.contains = contains;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                String paramname = parameters[i].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(paramname)) {
                    this.setText(parameters[i].getValue());
                } else if (CASE_KEY.equalsIgnoreCase(paramname)) {
                    this.setCasesensitive(Project.toBoolean(parameters[i].getValue()));
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++i;
            }
        }
    }

    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(File basedir, String filename, File file) {
        boolean bl;
        BufferedReader in;
        block14: {
            boolean bl2;
            this.validate();
            if (file.isDirectory()) {
                return true;
            }
            String userstr = this.contains;
            if (!this.casesensitive) {
                userstr = this.contains.toLowerCase();
            }
            in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    String teststr = in.readLine();
                    while (true) {
                        if (teststr == null) {
                            bl = false;
                            break block14;
                        }
                        if (!this.casesensitive) {
                            teststr = teststr.toLowerCase();
                        }
                        if (teststr.indexOf(userstr) > -1) {
                            bl2 = true;
                            Object var9_10 = null;
                            break;
                        }
                        teststr = in.readLine();
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException("Could not read file " + filename);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BuildException("Could not close file " + filename);
                }
            }
            try {}
            catch (Exception e) {
                throw new BuildException("Could not close file " + filename);
            }
            in.close();
            return bl2;
        }
        Object var9_11 = null;
        try {}
        catch (Exception e) {
            throw new BuildException("Could not close file " + filename);
        }
        in.close();
        return bl;
    }
}

