/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.ObjectStack;

public class StackGuard {
    public static int m_recursionLimit = -1;
    TransformerImpl m_transformer;

    public int getRecursionLimit() {
        return m_recursionLimit;
    }

    public void setRecursionLimit(int limit) {
        m_recursionLimit = limit;
    }

    public StackGuard(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public int countLikeTemplates(ElemTemplate templ, int pos) {
        ObjectStack elems = this.m_transformer.getCurrentTemplateElements();
        int count = 1;
        int i = pos - 1;
        while (i >= 0) {
            if ((ElemTemplateElement)elems.elementAt(i) == templ) {
                ++count;
            }
            --i;
        }
        return count;
    }

    private ElemTemplate getNextMatchOrNamedTemplate(int pos) {
        ObjectStack elems = this.m_transformer.getCurrentTemplateElements();
        int i = pos;
        while (i >= 0) {
            ElemTemplateElement elem = (ElemTemplateElement)elems.elementAt(i);
            if (null != elem && elem.getXSLToken() == 19) {
                return (ElemTemplate)elem;
            }
            --i;
        }
        return null;
    }

    public void checkForInfinateLoop() throws TransformerException {
        int nTemplates = this.m_transformer.getCurrentTemplateElementsCount();
        if (nTemplates < m_recursionLimit) {
            return;
        }
        if (m_recursionLimit <= 0) {
            return;
        }
        int i = nTemplates - 1;
        while (i >= m_recursionLimit) {
            ElemTemplate template = this.getNextMatchOrNamedTemplate(i);
            if (null == template) break;
            int loopCount = this.countLikeTemplates(template, i);
            if (loopCount >= m_recursionLimit) {
                String idIs = XSLMessages.createMessage(null != template.getName() ? "nameIs" : "matchPatternIs", null);
                Object[] msgArgs = new Object[]{new Integer(loopCount), idIs, null != template.getName() ? template.getName().toString() : template.getMatch().getPatternString()};
                String msg = XSLMessages.createMessage("recursionTooDeep", msgArgs);
                throw new TransformerException(msg);
            }
            --i;
        }
    }
}

