/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.TaskContainer;

public class UnknownElement
extends Task {
    private String elementName;
    private Object realThing;
    private Vector children = new Vector();

    public UnknownElement(String elementName) {
        this.elementName = elementName;
    }

    public String getTag() {
        return this.elementName;
    }

    public void maybeConfigure() throws BuildException {
        this.realThing = this.makeObject(this, this.wrapper);
        this.wrapper.setProxy(this.realThing);
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).setRuntimeConfigurableWrapper(this.wrapper);
        }
        this.handleChildren(this.realThing, this.wrapper);
        this.wrapper.maybeConfigure(this.getProject());
    }

    protected void handleOutput(String line) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleOutput(line);
        } else {
            super.handleOutput(line);
        }
    }

    protected void handleFlush(String line) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleFlush(line);
        } else {
            super.handleFlush(line);
        }
    }

    protected void handleErrorOutput(String line) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(line);
        } else {
            super.handleErrorOutput(line);
        }
    }

    protected void handleErrorFlush(String line) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(line);
        } else {
            super.handleErrorOutput(line);
        }
    }

    public void execute() {
        if (this.realThing == null) {
            throw new BuildException("Could not create task of type: " + this.elementName, this.getLocation());
        }
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).execute();
        }
    }

    public void addChild(UnknownElement child) {
        this.children.addElement(child);
    }

    protected void handleChildren(Object parent, RuntimeConfigurable parentWrapper) throws BuildException {
        if (parent instanceof TaskAdapter) {
            parent = ((TaskAdapter)parent).getProxy();
        }
        Class<?> parentClass = parent.getClass();
        IntrospectionHelper ih = IntrospectionHelper.getHelper(parentClass);
        int i = 0;
        while (i < this.children.size()) {
            RuntimeConfigurable childWrapper = parentWrapper.getChild(i);
            UnknownElement child = (UnknownElement)this.children.elementAt(i);
            Object realChild = null;
            if (parent instanceof TaskContainer) {
                realChild = this.makeTask(child, childWrapper, false);
                ((TaskContainer)parent).addTask((Task)realChild);
            } else {
                realChild = ih.createElement(this.getProject(), parent, child.getTag());
            }
            childWrapper.setProxy(realChild);
            if (parent instanceof TaskContainer) {
                ((Task)realChild).setRuntimeConfigurableWrapper(childWrapper);
            }
            child.handleChildren(realChild, childWrapper);
            ++i;
        }
    }

    protected Object makeObject(UnknownElement ue, RuntimeConfigurable w) {
        Object o = this.makeTask(ue, w, true);
        if (o == null) {
            o = this.getProject().createDataType(ue.getTag());
        }
        if (o == null) {
            throw this.getNotFoundException("task or type", ue.getTag());
        }
        return o;
    }

    protected Task makeTask(UnknownElement ue, RuntimeConfigurable w, boolean onTopLevel) {
        Task task = this.getProject().createTask(ue.getTag());
        if (task == null && !onTopLevel) {
            throw this.getNotFoundException("task", ue.getTag());
        }
        if (task != null) {
            task.setLocation(this.getLocation());
            task.setOwningTarget(this.getOwningTarget());
            task.init();
        }
        return task;
    }

    protected BuildException getNotFoundException(String what, String elementName) {
        String lSep = System.getProperty("line.separator");
        String msg = "Could not create " + what + " of type: " + elementName + "." + lSep + lSep + "Ant could not find the task or a class this " + "task relies upon." + lSep + lSep + "This is common and has a number of causes; the usual " + lSep + "solutions are to read the manual pages then download and" + lSep + "install needed JAR files, or fix the build file: " + lSep + " - You have misspelt '" + elementName + "'." + lSep + "   Fix: check your spelling." + lSep + " - The task needs an external JAR file to execute" + lSep + "   and this is not found at the right place in the classpath." + lSep + "   Fix: check the documentation for dependencies." + lSep + "   Fix: declare the task." + lSep + " - The task is an Ant optional task and optional.jar is absent" + lSep + "   Fix: look for optional.jar in ANT_HOME/lib, download if needed" + lSep + " - The task was not built into optional.jar as dependent" + lSep + "   libraries were not found at build time." + lSep + "   Fix: look in the JAR to verify, then rebuild with the needed" + lSep + "   libraries, or download a release version from apache.org" + lSep + " - The build file was written for a later version of Ant" + lSep + "   Fix: upgrade to at least the latest release version of Ant" + lSep + " - The task is not an Ant core or optional task " + lSep + "   and needs to be declared using <taskdef>." + lSep + lSep + "Remember that for JAR files to be visible to Ant tasks implemented" + lSep + "in ANT_HOME/lib, the files must be in the same directory or on the" + lSep + "classpath" + lSep + lSep + "Please neither file bug reports on this problem, nor email the" + lSep + "Ant mailing lists, until all of these causes have been explored," + lSep + "as this is not an Ant bug.";
        return new BuildException(msg, this.getLocation());
    }

    public String getTaskName() {
        return this.realThing == null || !(this.realThing instanceof Task) ? super.getTaskName() : ((Task)this.realThing).getTaskName();
    }

    public Task getTask() {
        if (this.realThing instanceof Task) {
            return (Task)this.realThing;
        }
        return null;
    }
}

