/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.TransformerException;
import org.apache.xpath.functions.Function;

public class FuncLoader {
    private int m_funcID;
    private String m_funcName;

    public String getName() {
        return this.m_funcName;
    }

    public FuncLoader(String funcName, int funcID) {
        this.m_funcID = funcID;
        this.m_funcName = funcName;
    }

    public Function getFunction() throws TransformerException {
        try {
            Class<?> function;
            if (this.m_funcName.indexOf(".") < 0) {
                String classname = "org.apache.xpath.functions." + this.m_funcName;
                function = Class.forName(classname);
            } else {
                function = Class.forName(this.m_funcName);
            }
            Function func = (Function)function.newInstance();
            return func;
        }
        catch (ClassNotFoundException e) {
            throw new TransformerException(e);
        }
        catch (IllegalAccessException e) {
            throw new TransformerException(e);
        }
        catch (InstantiationException e) {
            throw new TransformerException(e);
        }
    }
}

