/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.borland;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.borland.BorlandCfgParser;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public final class BorlandProcessor {
    public static void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w-");
                break;
            }
            case 5: {
                args.addElement("-w!");
                break;
            }
            default: {
                args.addElement("-w");
            }
        }
    }

    public static void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    public static File[] getEnvironmentPath(String toolName, char switchChar, String[] defaultRelativePath) {
        if (toolName == null) {
            throw new NullPointerException("toolName");
        }
        if (defaultRelativePath == null) {
            throw new NullPointerException("defaultRelativePath");
        }
        String[] path = defaultRelativePath;
        File exeDir = CUtil.getExecutableLocation(String.valueOf(toolName) + ".exe");
        if (exeDir != null) {
            File cfgFile = new File(exeDir, String.valueOf(toolName) + ".cfg");
            if (cfgFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(cfgFile));
                    BorlandCfgParser cfgParser = new BorlandCfgParser(switchChar);
                    path = cfgParser.parsePath(reader);
                    ((Reader)reader).close();
                }
                catch (IOException reader) {}
            }
        } else {
            exeDir = new File(System.getProperty("user.dir"));
        }
        int nonExistant = 0;
        File[] resourcePath = new File[path.length];
        int i = 0;
        while (i < path.length) {
            resourcePath[i] = new File(path[i]);
            if (!resourcePath[i].isAbsolute()) {
                resourcePath[i] = new File(exeDir, path[i]);
            }
            if (!resourcePath[i].exists() || !resourcePath[i].isDirectory()) {
                resourcePath[i] = null;
                ++nonExistant;
            }
            ++i;
        }
        if (nonExistant > 0) {
            File[] culled = new File[resourcePath.length - nonExistant];
            int index = 0;
            int i2 = 0;
            while (i2 < resourcePath.length) {
                if (resourcePath[i2] != null) {
                    culled[index++] = resourcePath[i2];
                }
                ++i2;
            }
            resourcePath = culled;
        }
        return resourcePath;
    }

    public static String getIncludeDirSwitch(String includeOption, String includeDir) {
        StringBuffer buf = new StringBuffer(includeOption);
        BorlandProcessor.quoteFile(buf, includeDir);
        return buf.toString();
    }

    public static String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length];
        int i = 0;
        while (i < libnames.length) {
            buf.setLength(0);
            buf.append(libnames[i]);
            buf.append(".lib");
            patterns[i] = buf.toString();
            ++i;
        }
        return patterns;
    }

    public static String[] getOutputFileSwitch(String outFile) {
        return new String[0];
    }

    public static void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }

    public static boolean isCaseSensitive() {
        return false;
    }

    public static void quoteFile(StringBuffer buf, String outPath) {
        if (outPath.charAt(0) != '\"' && (outPath.indexOf(32) >= 0 || outPath.indexOf(45) >= 0 || outPath.indexOf(47) >= 0)) {
            buf.append('\"');
            buf.append(outPath);
            buf.append('\"');
        } else {
            buf.append(outPath);
        }
    }

    public static String[] prepareResponseFile(File outputFile, String[] args, String continuation) throws IOException {
        String baseName = outputFile.getName();
        File commandFile = new File(outputFile.getParent(), String.valueOf(baseName) + ".rsp");
        FileWriter writer = new FileWriter(commandFile);
        int i = 1;
        while (i < args.length - 1) {
            writer.write(args[i]);
            if (args[i].endsWith(",") || args[i + 1].startsWith(",")) {
                writer.write(32);
            } else {
                writer.write(continuation);
            }
            ++i;
        }
        if (args.length > 1) {
            writer.write(args[args.length - 1]);
        }
        writer.close();
        String[] execArgs = new String[]{args[0], commandFile.toString()};
        return execArgs;
    }

    private BorlandProcessor() {
    }
}

