/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldDeserializer {
    protected final FieldInfo fieldInfo;
    protected final Class<?> clazz;

    public FieldDeserializer(Class<?> clazz, FieldInfo fieldInfo) {
        this.clazz = clazz;
        this.fieldInfo = fieldInfo;
    }

    public Method getMethod() {
        return this.fieldInfo.getMethod();
    }

    public Class<?> getFieldClass() {
        return this.fieldInfo.getFieldClass();
    }

    public Type getFieldType() {
        return this.fieldInfo.getFieldType();
    }

    public abstract void parseField(DefaultExtJSONParser var1, Object var2);

    public abstract int getFastMatchToken();

    public void setValue(Object object, boolean value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, int value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, long value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, String value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, Object value) {
        try {
            this.fieldInfo.getMethod().invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set property error, " + this.fieldInfo.getMethod().toString(), e);
        }
    }
}

