/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import de.undercouch.bson4jackson.io.CountingInputStream;
import de.undercouch.bson4jackson.io.LittleEndianInputStream;
import de.undercouch.bson4jackson.types.JavaScript;
import de.undercouch.bson4jackson.types.ObjectId;
import de.undercouch.bson4jackson.types.Symbol;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonStreamContext;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.JsonParserMinimalBase;
import org.codehaus.jackson.type.TypeReference;

public class BsonParser
extends JsonParserMinimalBase {
    private LittleEndianInputStream _in;
    private CountingInputStream _counter;
    private boolean _closed;
    private ObjectCodec _codec;
    private int _tokenPos;
    private Deque<Context> _contexts = new ArrayDeque<Context>();

    public BsonParser(int n, InputStream inputStream) {
        super(n);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this._counter = new CountingInputStream(inputStream);
        this._in = new LittleEndianInputStream(this._counter);
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._codec = objectCodec;
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
            this._in.close();
        }
        this._closed = true;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        if (this._currToken == null) {
            this._currToken = this.handleNewDocument(false);
        } else {
            boolean bl;
            Context context;
            block31: {
                this._tokenPos = this._counter.getPosition();
                context = this._contexts.peek();
                if (context == null) {
                    throw new JsonParseException("Found element outside the document", this.getTokenLocation());
                }
                if (context.state == State.DONE) {
                    context.reset();
                }
                bl = true;
                if (context.state == State.FIELDNAME) {
                    bl = false;
                    while (true) {
                        context.type = this._in.readByte();
                        if (context.type == 0) {
                            this._currToken = context.array ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                            this._contexts.pop();
                            break block31;
                        }
                        if (context.type != 6) break;
                        this.skipCString();
                    }
                    context.state = State.VALUE;
                    this._currToken = JsonToken.FIELD_NAME;
                    if (context.array) {
                        bl = true;
                        this.skipCString();
                        context.fieldName = null;
                    } else {
                        context.fieldName = this.readCString();
                    }
                }
            }
            if (bl) {
                switch (context.type) {
                    case 1: {
                        context.value = this._in.readDouble();
                        this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                        break;
                    }
                    case 2: {
                        context.value = this.readString();
                        this._currToken = JsonToken.VALUE_STRING;
                        break;
                    }
                    case 3: {
                        this._currToken = this.handleNewDocument(false);
                        break;
                    }
                    case 4: {
                        this._currToken = this.handleNewDocument(true);
                        break;
                    }
                    case 5: {
                        this._currToken = this.handleBinary();
                        break;
                    }
                    case 7: {
                        context.value = this.readObjectId();
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        break;
                    }
                    case 8: {
                        boolean bl2 = this._in.readBoolean();
                        context.value = bl2;
                        this._currToken = bl2 ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                        break;
                    }
                    case 9: {
                        context.value = new Date(this._in.readLong());
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        break;
                    }
                    case 10: {
                        this._currToken = JsonToken.VALUE_NULL;
                        break;
                    }
                    case 11: {
                        this._currToken = this.handleRegEx();
                        break;
                    }
                    case 12: {
                        this._currToken = this.handleDBPointer();
                        break;
                    }
                    case 13: {
                        context.value = new JavaScript(this.readString());
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        break;
                    }
                    case 14: {
                        context.value = this.readSymbol();
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        break;
                    }
                    case 15: {
                        this._currToken = this.handleJavascriptWithScope();
                        break;
                    }
                    case 16: {
                        context.value = this._in.readInt();
                        this._currToken = JsonToken.VALUE_NUMBER_INT;
                        break;
                    }
                    case 17: {
                        context.value = this.readTimestamp();
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        break;
                    }
                    case 18: {
                        context.value = this._in.readLong();
                        this._currToken = JsonToken.VALUE_NUMBER_INT;
                        break;
                    }
                    case -1: {
                        context.value = "MinKey";
                        this._currToken = JsonToken.VALUE_STRING;
                        break;
                    }
                    case 127: {
                        context.value = "MaxKey";
                        this._currToken = JsonToken.VALUE_STRING;
                        break;
                    }
                    default: {
                        throw new JsonParseException("Unknown element type " + context.type, this.getTokenLocation());
                    }
                }
                context.state = State.DONE;
            }
        }
        return this._currToken;
    }

    protected JsonToken handleNewDocument(boolean bl) throws IOException {
        this._in.readInt();
        this._contexts.push(new Context(bl));
        return bl ? JsonToken.START_ARRAY : JsonToken.START_OBJECT;
    }

    protected JsonToken handleBinary() throws IOException {
        int n = this._in.readInt();
        byte by = this._in.readByte();
        Context context = this.getContext();
        switch (by) {
            case 2: {
                int n2 = this._in.readInt();
                byte[] byArray = new byte[n2];
                this._in.readFully(byArray);
                context.value = byArray;
                break;
            }
            case 3: {
                long l = this._in.readLong();
                long l2 = this._in.readLong();
                context.value = new UUID(l, l2);
                break;
            }
            default: {
                byte[] byArray = new byte[n];
                this._in.readFully(byArray);
                context.value = byArray;
            }
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected int regexStrToFlags(String string) throws JsonParseException {
        int n = 0;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'i': {
                    n |= 2;
                    continue block7;
                }
                case 'm': {
                    n |= 8;
                    continue block7;
                }
                case 's': {
                    n |= 0x20;
                    continue block7;
                }
                case 'u': {
                    n |= 0x40;
                    continue block7;
                }
                case 'l': 
                case 'x': {
                    continue block7;
                }
                default: {
                    throw new JsonParseException("Invalid regex", this.getTokenLocation());
                }
            }
        }
        return n;
    }

    protected JsonToken handleRegEx() throws IOException {
        String string = this.readCString();
        String string2 = this.readCString();
        this.getContext().value = Pattern.compile(string, this.regexStrToFlags(string2));
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected JsonToken handleDBPointer() throws IOException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("$ns", this.readString());
        linkedHashMap.put("$id", this.readObjectId());
        this.getContext().value = linkedHashMap;
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected JsonToken handleJavascriptWithScope() throws IOException {
        this._in.readInt();
        String string = this.readString();
        Map<String, Object> map = this.readDocument();
        this.getContext().value = new JavaScript(string, map);
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected String readCString() throws IOException {
        return this._in.readUTF(-1);
    }

    protected void skipCString() throws IOException {
        while (this._in.readByte() != 0) {
        }
    }

    protected String readString() throws IOException {
        int n = this._in.readInt();
        if (n <= 0) {
            throw new IOException("Invalid number of string bytes");
        }
        String string = n > 1 ? this._in.readUTF(n - 1) : "";
        this._in.readByte();
        return string;
    }

    protected Symbol readSymbol() throws IOException {
        return new Symbol(this.readString());
    }

    protected Timestamp readTimestamp() throws IOException {
        int n = this._in.readInt();
        int n2 = this._in.readInt();
        return new Timestamp(n2, n);
    }

    protected ObjectId readObjectId() throws IOException {
        int n = this._in.readInt();
        int n2 = this._in.readInt();
        int n3 = this._in.readInt();
        return new ObjectId(n, n2, n3);
    }

    protected Map<String, Object> readDocument() throws IOException {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("Could not parse embedded document because BSON parser has no codec");
        }
        this._currToken = this.handleNewDocument(false);
        return (Map)objectCodec.readValue((JsonParser)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected Context getContext() throws IOException {
        Context context = this._contexts.peek();
        if (context == null) {
            throw new IOException("Context unknown");
        }
        return context;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public String getCurrentName() throws IOException, JsonParseException {
        Context context = this._contexts.peek();
        if (context == null) {
            return null;
        }
        return context.fieldName;
    }

    public JsonStreamContext getParsingContext() {
        return null;
    }

    public JsonLocation getTokenLocation() {
        return new BsonLocation(this._in, this._tokenPos);
    }

    public JsonLocation getCurrentLocation() {
        return new BsonLocation(this._in, this._counter.getPosition());
    }

    public String getText() throws IOException, JsonParseException {
        Context context = this._contexts.peek();
        if (context == null || context.state == State.FIELDNAME) {
            return null;
        }
        if (context.state == State.VALUE) {
            return context.fieldName;
        }
        return (String)context.value;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return (Number)this.getContext().value;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        Context context = this._contexts.peek();
        if (context == null) {
            return null;
        }
        if (context.value instanceof Integer) {
            return JsonParser.NumberType.INT;
        }
        if (context.value instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        if (context.value instanceof BigInteger) {
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if (context.value instanceof Float) {
            return JsonParser.NumberType.FLOAT;
        }
        if (context.value instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (context.value instanceof BigDecimal) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return null;
    }

    public int getIntValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).intValue();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).longValue();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        Number number = this.getNumberValue();
        if (number == null) {
            return null;
        }
        if (number instanceof Byte || number instanceof Integer || number instanceof Long || number instanceof Short) {
            return BigInteger.valueOf(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue()).toBigInteger();
        }
        return new BigInteger(number.toString());
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).floatValue();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return ((Number)this.getContext().value).doubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        Number number = this.getNumberValue();
        if (number == null) {
            return null;
        }
        if (number instanceof Byte || number instanceof Integer || number instanceof Long || number instanceof Short) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        return new BigDecimal(number.toString());
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        return this.getText().getBytes();
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        Context context = this._contexts.peek();
        return context != null ? context.value : null;
    }

    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF();
    }

    private static class BsonLocation
    extends JsonLocation {
        private static final long serialVersionUID = -5441597278886285168L;

        public BsonLocation(Object object, long l) {
            super(object, l, -1L, -1, -1);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append("[Source: ");
            if (this.getSourceRef() == null) {
                stringBuilder.append("UNKNOWN");
            } else {
                stringBuilder.append(this.getSourceRef().toString());
            }
            stringBuilder.append("; pos: ");
            stringBuilder.append(this.getByteOffset());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static class Context {
        final boolean array;
        byte type;
        String fieldName;
        Object value;
        State state = State.FIELDNAME;

        public Context(boolean bl) {
            this.array = bl;
        }

        public void reset() {
            this.type = 0;
            this.fieldName = null;
            this.value = null;
            this.state = State.FIELDNAME;
        }
    }

    private static enum State {
        FIELDNAME,
        VALUE,
        DONE;

    }
}

