/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.util.NameTable;

public class CharBasedPNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    protected static final float DEFAULT_FILL_FACTOR = 0.75f;
    protected PNameC[] mSymbols;
    protected Bucket[] mBuckets;
    protected int mSize;
    protected int mSizeThreshold;
    protected int mIndexMask;
    protected boolean mDirty;

    public CharBasedPNameTable(int initialSize) {
        int currSize;
        this.mDirty = true;
        if (initialSize < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + initialSize);
        }
        for (currSize = 16; currSize < initialSize; currSize += currSize) {
        }
        initialSize = currSize;
        this.mSymbols = new PNameC[initialSize];
        this.mBuckets = new Bucket[initialSize >> 1];
        this.mIndexMask = initialSize - 1;
        this.mSize = 0;
        this.mSizeThreshold = initialSize * 3 + 3 >> 2;
    }

    CharBasedPNameTable(CharBasedPNameTable parent) {
        this.mSymbols = parent.mSymbols;
        this.mBuckets = parent.mBuckets;
        this.mSize = parent.mSize;
        this.mSizeThreshold = parent.mSizeThreshold;
        this.mIndexMask = parent.mIndexMask;
        this.mDirty = false;
    }

    public synchronized void mergeFromChild(CharBasedPNameTable child) {
        if (child.size() <= this.size()) {
            return;
        }
        this.mSymbols = child.mSymbols;
        this.mBuckets = child.mBuckets;
        this.mSize = child.mSize;
        this.mSizeThreshold = child.mSizeThreshold;
        this.mIndexMask = child.mIndexMask;
        this.mDirty = false;
        child.mDirty = false;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean maybeDirty() {
        return this.mDirty;
    }

    public PNameC findSymbol(char[] buffer, int start, int len, int hash) {
        int index = hash & this.mIndexMask;
        PNameC sym = this.mSymbols[index];
        if (sym != null) {
            if (sym.equalsPName(buffer, start, len, hash)) {
                return sym;
            }
            Bucket b = this.mBuckets[index >> 1];
            if (b != null && (sym = b.find(buffer, start, len, hash)) != null) {
                return sym;
            }
        }
        return null;
    }

    public PNameC addSymbol(char[] buffer, int start, int len, int hash) {
        boolean primary;
        String newStr = new String(buffer, start, len).intern();
        PNameC pname = PNameC.construct(newStr, hash);
        int index = hash & this.mIndexMask;
        if (null == this.mSymbols[index]) {
            primary = true;
        } else if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            index = hash & this.mIndexMask;
            primary = null == this.mSymbols[index];
        } else {
            primary = false;
        }
        if (!this.mDirty) {
            this.copyArrays();
        }
        ++this.mSize;
        if (primary) {
            this.mSymbols[index] = pname;
        } else {
            int bix = index >> 1;
            this.mBuckets[bix] = new Bucket(pname, this.mBuckets[bix]);
        }
        return pname;
    }

    private void copyArrays() {
        PNameC[] oldSyms = this.mSymbols;
        int size = oldSyms.length;
        this.mSymbols = new PNameC[size];
        System.arraycopy(oldSyms, 0, this.mSymbols, 0, size);
        Bucket[] oldBuckets = this.mBuckets;
        size = oldBuckets.length;
        this.mBuckets = new Bucket[size];
        System.arraycopy(oldBuckets, 0, this.mBuckets, 0, size);
        this.mDirty = true;
    }

    private void rehash() {
        int i;
        int size = this.mSymbols.length;
        int newSize = size + size;
        PNameC[] oldSyms = this.mSymbols;
        Bucket[] oldBuckets = this.mBuckets;
        this.mSymbols = new PNameC[newSize];
        this.mBuckets = new Bucket[newSize >> 1];
        this.mIndexMask = newSize - 1;
        this.mSizeThreshold += this.mSizeThreshold;
        int count = 0;
        for (i = 0; i < size; ++i) {
            PNameC symbol = oldSyms[i];
            if (symbol == null) continue;
            ++count;
            int index = symbol.getCustomHash() & this.mIndexMask;
            if (this.mSymbols[index] == null) {
                this.mSymbols[index] = symbol;
                continue;
            }
            int bix = index >> 1;
            this.mBuckets[bix] = new Bucket(symbol, this.mBuckets[bix]);
        }
        size >>= 1;
        for (i = 0; i < size; ++i) {
            for (Bucket b = oldBuckets[i]; b != null; b = b.getNext()) {
                ++count;
                PNameC symbol = b.getSymbol();
                int index = symbol.getCustomHash() & this.mIndexMask;
                if (this.mSymbols[index] == null) {
                    this.mSymbols[index] = symbol;
                    continue;
                }
                int bix = index >> 1;
                this.mBuckets[bix] = new Bucket(symbol, this.mBuckets[bix]);
            }
        }
        if (count != this.mSize) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this.mSize + " entries; now have " + count + ".");
        }
    }

    static final class Bucket {
        private final PNameC mSymbol;
        private final Bucket mNext;

        public Bucket(PNameC symbol, Bucket next) {
            this.mSymbol = symbol;
            this.mNext = next;
        }

        public PNameC getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public PNameC find(char[] buf, int start, int len, int hash) {
            Bucket b = this;
            do {
                PNameC sym;
                if (!(sym = b.mSymbol).equalsPName(buf, start, len, hash)) continue;
                return sym;
            } while ((b = b.getNext()) != null);
            return null;
        }
    }
}

