/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public abstract class CoverageDataContainer
implements CoverageData,
HasBeenInstrumented,
Serializable {
    private static final long serialVersionUID = 2L;
    protected transient Lock lock;
    Map<Object, CoverageData> children = new HashMap<Object, CoverageData>();

    public CoverageDataContainer() {
        this.initLock();
    }

    private void initLock() {
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        CoverageDataContainer coverageDataContainer = (CoverageDataContainer)obj;
        this.lock.lock();
        try {
            boolean bl = ((Object)this.children).equals(coverageDataContainer.children);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBranchCoverageRate() {
        int number = 0;
        int numberCovered = 0;
        this.lock.lock();
        try {
            for (CoverageData coverageContainer : this.children.values()) {
                number += coverageContainer.getNumberOfValidBranches();
                numberCovered += coverageContainer.getNumberOfCoveredBranches();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (number == 0) {
            return 1.0;
        }
        return (double)numberCovered / (double)number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageData getChild(String name) {
        this.lock.lock();
        try {
            CoverageData coverageData = this.children.get(name);
            return coverageData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLineCoverageRate() {
        int number = 0;
        int numberCovered = 0;
        this.lock.lock();
        try {
            for (CoverageData coverageContainer : this.children.values()) {
                number += coverageContainer.getNumberOfValidLines();
                numberCovered += coverageContainer.getNumberOfCoveredLines();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (number == 0) {
            return 1.0;
        }
        return (double)numberCovered / (double)number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfChildren() {
        this.lock.lock();
        try {
            int n = this.children.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCoveredBranches() {
        int number = 0;
        this.lock.lock();
        try {
            for (CoverageData coverageContainer : this.children.values()) {
                number += coverageContainer.getNumberOfCoveredBranches();
            }
        }
        finally {
            this.lock.unlock();
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCoveredLines() {
        int number = 0;
        this.lock.lock();
        try {
            for (CoverageData coverageContainer : this.children.values()) {
                number += coverageContainer.getNumberOfCoveredLines();
            }
        }
        finally {
            this.lock.unlock();
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfValidBranches() {
        int number = 0;
        this.lock.lock();
        try {
            for (CoverageData coverageContainer : this.children.values()) {
                number += coverageContainer.getNumberOfValidBranches();
            }
        }
        finally {
            this.lock.unlock();
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfValidLines() {
        int number = 0;
        this.lock.lock();
        try {
            for (CoverageData coverageContainer : this.children.values()) {
                number += coverageContainer.getNumberOfValidLines();
            }
        }
        finally {
            this.lock.unlock();
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.lock();
        try {
            int n = this.children.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(CoverageData coverageData) {
        CoverageDataContainer container = (CoverageDataContainer)coverageData;
        this.getBothLocks(container);
        try {
            for (Object key : container.children.keySet()) {
                CoverageData newChild = container.children.get(key);
                CoverageData existingChild = this.children.get(key);
                if (existingChild != null) {
                    existingChild.merge(newChild);
                    continue;
                }
                this.children.put(key, newChild);
            }
        }
        finally {
            this.lock.unlock();
            container.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBothLocks(CoverageDataContainer other) {
        boolean myLock = false;
        boolean otherLock = false;
        while (!myLock || !otherLock) {
            try {
                myLock = this.lock.tryLock();
                otherLock = other.lock.tryLock();
            }
            finally {
                if (myLock && otherLock) continue;
                if (myLock) {
                    this.lock.unlock();
                }
                if (otherLock) {
                    other.lock.unlock();
                }
                Thread.yield();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initLock();
    }
}

