/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.transform.hook;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;
import org.hibernate.repackage.cglib.asm.Attribute;
import org.hibernate.repackage.cglib.asm.ClassReader;
import org.hibernate.repackage.cglib.asm.ClassWriter;
import org.hibernate.repackage.cglib.asm.CodeVisitor;
import org.hibernate.repackage.cglib.asm.Type;
import org.hibernate.repackage.cglib.core.RemappingCodeVisitor;

public class AsmClassLoaderPreProcessor
implements ClassLoaderPreProcessor {
    private static final String DESC_CORE = "Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_PREFIX = "(Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_HELPER = "(Ljava/lang/ClassLoader;Ljava/lang/String;[BIILjava/security/ProtectionDomain;)[B";

    public byte[] preProcess(byte[] b) {
        try {
            ClassWriter w = new ClassWriter(true){
                private boolean flag;

                public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
                    super.visit(version, access, name, superName, interfaces, sourceFile);
                    this.flag = name.equals("java/lang/ClassLoader");
                }

                public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
                    CodeVisitor v = super.visitMethod(access, name, desc, exceptions, attrs);
                    if (this.flag) {
                        v = new PreProcessingVisitor(v, access, desc);
                    }
                    return v;
                }
            };
            new ClassReader(b).accept(w, false);
            return w.toByteArray();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return b;
        }
    }

    public static void main(String[] args) throws Exception {
        AsmClassLoaderPreProcessor me = new AsmClassLoaderPreProcessor();
        InputStream is = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
        byte[] out = me.preProcess(ClassLoaderPatcher.inputStreamToByteArray((InputStream)is));
        is.close();
        FileOutputStream os = new FileOutputStream("_boot/java/lang/ClassLoader.class");
        ((OutputStream)os).write(out);
        ((OutputStream)os).close();
    }

    private static class PreProcessingVisitor
    extends RemappingCodeVisitor {
        public PreProcessingVisitor(CodeVisitor v, int access, String desc) {
            super(v, access, Type.getArgumentTypes(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if ("defineClass0".equals(name) && "java/lang/ClassLoader".equals(owner)) {
                int i;
                Type[] args = Type.getArgumentTypes(desc);
                if (args.length < 5 || !desc.startsWith(AsmClassLoaderPreProcessor.DESC_PREFIX)) {
                    throw new Error("non standard JDK, native call not supported: " + desc);
                }
                int[] locals = new int[args.length];
                for (i = args.length - 1; i >= 0; --i) {
                    locals[i] = this.nextLocal(args[i].getSize());
                    this.cv.visitVarInsn(args[i].getOpcode(54), locals[i]);
                }
                for (i = 0; i < 5; ++i) {
                    this.cv.visitVarInsn(args[i].getOpcode(21), locals[i]);
                }
                super.visitMethodInsn(184, "org/codehaus/aspectwerkz/hook/impl/ClassPreProcessorHelper", "defineClass0Pre", AsmClassLoaderPreProcessor.DESC_HELPER);
                this.cv.visitVarInsn(58, locals[1]);
                this.cv.visitVarInsn(25, 0);
                this.cv.visitVarInsn(25, locals[0]);
                this.cv.visitVarInsn(25, locals[1]);
                this.cv.visitInsn(3);
                this.cv.visitVarInsn(25, locals[1]);
                this.cv.visitInsn(190);
                this.cv.visitVarInsn(25, locals[4]);
                for (i = 5; i < args.length; ++i) {
                    this.cv.visitVarInsn(args[i].getOpcode(21), locals[i]);
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

