/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.NsBinding;
import javax.xml.namespace.QName;

public abstract class PName {
    protected final String mPrefixedName;
    protected final String mPrefix;
    protected final String mLocalName;
    protected NsBinding mNsBinding = null;

    protected PName(String pname, String prefix, String ln) {
        this.mPrefixedName = pname;
        this.mPrefix = prefix;
        this.mLocalName = ln;
    }

    public abstract PName createBoundName(NsBinding var1);

    public final String getPrefixedName() {
        return this.mPrefixedName;
    }

    public final String getPrefix() {
        return this.mPrefix;
    }

    public final String getLocalName() {
        return this.mLocalName;
    }

    public boolean hasPrefix() {
        return this.mPrefix != null;
    }

    public final NsBinding getNsBinding() {
        return this.mNsBinding;
    }

    public final String getNsUri() {
        return this.mNsBinding == null ? null : this.mNsBinding.mURI;
    }

    public final QName constructQName() {
        String pr = this.mPrefix;
        String uri = this.mNsBinding == null ? null : this.mNsBinding.mURI;
        return new QName(uri == null ? "" : uri, this.mLocalName, pr == null ? "" : pr);
    }

    public final QName constructQName(NsBinding defaultNs) {
        String uri;
        String pr = this.mPrefix;
        if (pr == null) {
            pr = "";
        }
        if (this.mNsBinding != null && (uri = this.mNsBinding.mURI) != null) {
            return new QName(uri, this.mLocalName, pr);
        }
        uri = defaultNs.mURI;
        return new QName(uri == null ? "" : uri, this.mLocalName, pr);
    }

    public final boolean needsBinding() {
        return this.mPrefix != null && this.mNsBinding == null;
    }

    public final boolean isBound() {
        return this.mNsBinding == null || this.mNsBinding.mURI != null;
    }

    public final boolean boundEquals(PName other) {
        if (other == null || other.mLocalName != this.mLocalName) {
            return false;
        }
        return other.getNsUri() == this.getNsUri();
    }

    public final boolean unboundEquals(PName other) {
        return other.mPrefixedName == this.mPrefixedName;
    }

    public final boolean boundEquals(String nsUri, String ln) {
        if (!this.mLocalName.equals(ln)) {
            return false;
        }
        String thisUri = this.getNsUri();
        if (nsUri == null || nsUri.length() == 0) {
            return thisUri == null;
        }
        return nsUri.equals(thisUri);
    }

    public final int unboundHashCode() {
        return this.mPrefixedName.hashCode();
    }

    public final int boundHashCode() {
        return this.mLocalName.hashCode();
    }

    public static int boundHashCode(String nsURI, String localName) {
        return localName.hashCode();
    }

    public final String toString() {
        return this.mPrefixedName;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PName)) {
            return false;
        }
        PName other = (PName)o;
        return other.mPrefix == this.mPrefix && other.mLocalName == this.mLocalName;
    }

    public abstract int sizeInQuads();

    public abstract int getFirstQuad();

    public abstract int getQuad(int var1);

    public abstract int getLastQuad();
}

