/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateDeserializer
implements ObjectDeserializer {
    public static final DateDeserializer instance = new DateDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        Object val = parser.parse();
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (T)val;
        }
        if (val instanceof Number) {
            return (T)new Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 0) {
                return null;
            }
            JSONScanner dateLexer = new JSONScanner(strVal);
            if (dateLexer.scanISO8601DateIfMatch()) {
                return (T)dateLexer.getCalendar().getTime();
            }
            long longVal = Long.parseLong(strVal);
            return (T)new Date(longVal);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

