/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
implements Comparable<FieldInfo> {
    private final String name;
    private final Method method;
    private final Field field;
    private final Class<?> fieldClass;
    private final Type fieldType;

    public FieldInfo(String name, Method method, Field field) {
        this.name = name;
        this.method = method;
        this.field = field;
        if (method.getParameterTypes().length == 1) {
            this.fieldClass = method.getParameterTypes()[0];
            this.fieldType = method.getGenericParameterTypes()[0];
        } else {
            this.fieldClass = method.getReturnType();
            this.fieldType = method.getGenericReturnType();
        }
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.name.compareTo(o.name);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        annotation = this.method.getAnnotation(annotationClass);
        if (annotation == null && this.field != null) {
            annotation = this.field.getAnnotation(annotationClass);
        }
        return annotation;
    }
}

