/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import net.minidev.json.JSONStyle;

public class JSONStyler
extends JSONStyle {
    int deep = 0;
    String[] indent;

    public JSONStyler(int FLAG) {
        super(FLAG);
        this.setIdentLevel(2);
    }

    public JSONStyler(int FLAG, int nbLevel) {
        super(FLAG);
        this.setIdentLevel(nbLevel);
    }

    public void setIdentLevel(int nbLevel) {
        String[] indent = new String[nbLevel];
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 0; i < nbLevel; ++i) {
            indent[i] = sb.toString();
            sb.append(' ');
        }
        this.indent = indent;
    }

    public JSONStyler() {
    }

    @Override
    public boolean indent() {
        return true;
    }

    public String getNewLine() {
        if (this.deep <= 0) {
            return "";
        }
        if (this.deep < this.indent.length) {
            return this.indent[this.deep];
        }
        return this.indent[this.deep - 1];
    }

    @Override
    public JSONStyler getStyler() {
        return this;
    }

    public void objectIn() {
        ++this.deep;
    }

    public void objectOut() {
        --this.deep;
    }

    public void arrayIn() {
        ++this.deep;
    }

    public void arrayOut() {
        --this.deep;
    }
}

