/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class ReleaseInfo {
    private static final Properties releaseInfo = new Properties();
    private static final String RELEASE_INFO_FILE = "META-INF/groovy-release-info.properties";
    private static final String KEY_IMPLEMENTATION_VERSION = "ImplementationVersion";
    private static final String KEY_BUNDLE_VERSION = "BundleVersion";
    private static final String KEY_BUILD_DATE = "BuildDate";
    private static final String KEY_BUILD_TIME = "BuildTime";

    public static String getVersion() {
        return ReleaseInfo.get(KEY_IMPLEMENTATION_VERSION);
    }

    public static Properties getAllProperties() {
        return releaseInfo;
    }

    private static String get(String propName) {
        String propValue = releaseInfo.getProperty(propName);
        return propValue == null ? "" : propValue;
    }

    static {
        URL url = null;
        ClassLoader cl = ReleaseInfo.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((url = cl instanceof URLClassLoader ? ((URLClassLoader)cl).findResource(RELEASE_INFO_FILE) : cl.getResource(RELEASE_INFO_FILE)) != null) {
            try {
                InputStream is = url.openStream();
                if (is != null) {
                    releaseInfo.load(is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

