/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Wildcard {
    private static Pattern dstar = Pattern.compile("\\*\\*");
    private static Pattern star = Pattern.compile("\\*");
    private static Pattern estar = Pattern.compile("\\+\\??\\)\\Z");
    private final Pattern pattern;
    private final int count;
    private final ArrayList<Object> parts = new ArrayList(16);
    private final String[] strings;
    private final int[] refs;

    public Wildcard(String pattern, String result) {
        if (pattern.equals("**")) {
            throw new IllegalArgumentException("'**' is not a valid pattern");
        }
        if (!Wildcard.checkIdentifierChars(pattern, "/*")) {
            throw new IllegalArgumentException("Not a valid package pattern: " + pattern);
        }
        if (pattern.indexOf("***") >= 0) {
            throw new IllegalArgumentException("The sequence '***' is invalid in a package pattern");
        }
        String regex = pattern;
        regex = Wildcard.replaceAllLiteral(dstar, regex, "(.+?)");
        regex = Wildcard.replaceAllLiteral(star, regex, "([^/]+)");
        regex = Wildcard.replaceAllLiteral(estar, regex, "*)");
        this.pattern = Pattern.compile("\\A" + regex + "\\Z");
        this.count = this.pattern.matcher("foo").groupCount();
        char[] chars = result.toCharArray();
        int max = 0;
        int mark = 0;
        boolean state = false;
        int len = chars.length;
        block3: for (int i = 0; i < len + 1; ++i) {
            int ch;
            int n = ch = i == len ? 64 : chars[i];
            if (!state) {
                if (ch != 64) continue;
                this.parts.add(new String(chars, mark, i - mark));
                mark = i + 1;
                state = true;
                continue;
            }
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
                default: {
                    if (i == mark) {
                        throw new IllegalArgumentException("Backslash not followed by a digit");
                    }
                    int n2 = Integer.parseInt(new String(chars, mark, i - mark));
                    if (n2 > max) {
                        max = n2;
                    }
                    this.parts.add(new Integer(n2));
                    --i;
                    state = false;
                }
            }
        }
        int size = this.parts.size();
        this.strings = new String[size];
        this.refs = new int[size];
        Arrays.fill(this.refs, -1);
        for (int i = 0; i < size; ++i) {
            Object v = this.parts.get(i);
            if (v instanceof String) {
                this.strings[i] = ((String)v).replace('.', '/');
                continue;
            }
            this.refs[i] = (Integer)v;
        }
        if (this.count < max) {
            throw new IllegalArgumentException("Result includes impossible placeholder \"@" + max + "\": " + result);
        }
    }

    public boolean matches(String value) {
        return this.getMatcher(value) != null;
    }

    public String replace(String value) {
        Matcher matcher = this.getMatcher(value);
        if (matcher != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.strings.length; ++i) {
                sb.append(this.refs[i] >= 0 ? matcher.group(this.refs[i]) : this.strings[i]);
            }
            return sb.toString();
        }
        return null;
    }

    private Matcher getMatcher(String value) {
        Matcher matcher = this.pattern.matcher(value);
        if (matcher.matches() && Wildcard.checkIdentifierChars(value, "/")) {
            return matcher;
        }
        return null;
    }

    private static boolean checkIdentifierChars(String expr, String extra) {
        int len = expr.length();
        for (int i = 0; i < len; ++i) {
            char c = expr.charAt(i);
            if (extra.indexOf(c) >= 0 || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private static String replaceAllLiteral(Pattern pattern, String value, String replace) {
        replace = replace.replaceAll("([$\\\\])", "\\\\$0");
        return pattern.matcher(value).replaceAll(replace);
    }

    public String toString() {
        return "Wildcard{pattern=" + this.pattern + ",parts=" + this.parts + "}";
    }
}

