/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressDeserializer
implements ObjectDeserializer {
    public static final InetAddressDeserializer instance = new InetAddressDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        String host = (String)parser.parse();
        if (host == null) {
            return null;
        }
        if (host.length() == 0) {
            return null;
        }
        try {
            return (T)InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new JSONException("deserialize error", e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

