/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONParserStream {
    private boolean acceptSimpleQuote = true;
    private boolean acceptNonQuote = true;
    private boolean acceptNaN = true;
    public static final int MODE_PERMISSIF = -1;
    public static final int MODE_RFC4627 = 0;
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    private int c;
    private ContainerFactory containerFactory;
    private Reader in;
    private int pos;
    private StringBuilder sb = new StringBuilder();

    public JSONParserStream() {
        this(-1);
    }

    public JSONParserStream(int permissifMode) {
        this.acceptNaN = (permissifMode & 4) > 0;
        this.acceptNonQuote = (permissifMode & 2) > 0;
        this.acceptSimpleQuote = (permissifMode & 1) > 0;
    }

    public Object parse(Reader in) throws IOException, ParseException {
        return this.parse(in, ContainerFactory.FACTORY);
    }

    public Object parse(Reader in, ContainerFactory containerFactory) throws IOException, ParseException {
        this.in = in;
        this.containerFactory = containerFactory;
        this.c = in.read();
        this.pos = 0;
        return this.readMain(JSONParser.stopX);
    }

    private final void read() throws IOException {
        this.c = this.in.read();
        ++this.pos;
    }

    private List<Object> readArray() throws IOException, ParseException {
        List<Object> obj = this.containerFactory.creatArrayContainer();
        if (this.c != 91) {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        block7: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block7;
                }
                case 93: {
                    this.read();
                    return obj;
                }
                case 58: 
                case 125: {
                    throw new ParseException(this.pos, 1, Character.valueOf((char)this.c));
                }
                case 44: {
                    this.read();
                    continue block7;
                }
                case -1: {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            obj.add(this.readMain(JSONParser.stopArray));
        }
    }

    private Object readMain(boolean[] stop) throws IOException, ParseException {
        block12: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block12;
                }
                case 58: 
                case 93: 
                case 125: {
                    throw new ParseException(this.pos, 1, null);
                }
                case 123: {
                    return this.readObject();
                }
                case 91: {
                    return this.readArray();
                }
                case 34: 
                case 39: {
                    return this.readString();
                }
                case 110: {
                    String x = this.readNQString(stop);
                    if ("null".equals(x)) {
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 102: {
                    String x = this.readNQString(stop);
                    if ("false".equals(x)) {
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 116: {
                    String x = this.readNQString(stop);
                    if ("true".equals(x)) {
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 78: {
                    String x = this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(1, x);
                    }
                    if ("NaN".equals(x)) {
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber(stop);
                }
            }
            break;
        }
        String text = this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(1, text);
        }
        return text;
    }

    private String readNQString(boolean[] stop) throws IOException {
        this.sb.delete(0, this.sb.length());
        this.skipNQString(stop);
        return this.sb.toString().trim();
    }

    private Object readNumber(boolean[] stop) throws IOException, ParseException {
        this.sb.delete(0, this.sb.length());
        this.sb.append((char)this.c);
        this.read();
        this.skipDigits();
        if (this.c != 46 && this.c != 69 && this.c != 101) {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, text);
                }
                return text;
            }
            String num = this.sb.toString().trim();
            if (num.length() > 20) {
                return new BigInteger(num);
            }
            try {
                long v = Long.parseLong(num);
                if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                    return (int)v;
                }
                return v;
            }
            catch (NumberFormatException e) {
                return new BigInteger(num);
            }
        }
        if (this.c == 46) {
            this.sb.append((char)this.c);
            this.read();
            this.skipDigits();
        }
        if (this.c != 69 && this.c != 101) {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, text);
                }
                return text;
            }
            String num = this.sb.toString().trim();
            return Double.parseDouble(num);
        }
        this.sb.append('E');
        this.read();
        if (this.c == 43 || this.c == 45 || this.c >= 48 && this.c <= 57) {
            this.sb.append((char)this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, text);
                }
                return text;
            }
            return Double.parseDouble(this.sb.toString().trim());
        }
        this.skipNQString(stop);
        String text = this.sb.toString().trim();
        if (!this.acceptNonQuote) {
            throw new ParseException(1, text);
        }
        return text;
    }

    private Map<String, Object> readObject() throws IOException, ParseException {
        Map<String, Object> obj = this.containerFactory.createObjectContainer();
        if (this.c != 123) {
            throw new RuntimeException("Internal Error");
        }
        block6: while (true) {
            String key;
            this.read();
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block6;
                }
                case 58: 
                case 93: {
                    throw new NullPointerException();
                }
                case 125: {
                    this.read();
                    return obj;
                }
                case 44: {
                    continue block6;
                }
            }
            if (this.c == 34 || this.c == 39) {
                key = this.readString();
            } else {
                key = this.readNQString(JSONParser.stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, key);
                }
            }
            while (this.c != 58 && this.c != -1) {
                this.read();
            }
            if (this.c == -1) {
                throw new ParseException(this.pos - 1, 3, null);
            }
            this.read();
            obj.put(key, this.readMain(JSONParser.stopValue));
            if (this.c == 125) break;
        }
        this.read();
        return obj;
    }

    private String readString() throws IOException, ParseException {
        if (!this.acceptSimpleQuote && this.c == 39) {
            throw new ParseException(1, "'");
        }
        this.sb.delete(0, this.sb.length());
        char sep = (char)this.c;
        block18: while (true) {
            this.read();
            switch (this.c) {
                case -1: {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case 34: 
                case 39: {
                    if (sep == this.c) {
                        this.read();
                        return this.sb.toString();
                    }
                    this.sb.append((char)this.c);
                    continue block18;
                }
                case 92: {
                    this.read();
                    switch (this.c) {
                        case 116: {
                            this.sb.append('\t');
                            continue block18;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block18;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block18;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block18;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block18;
                        }
                        case 92: {
                            this.sb.append('\\');
                            continue block18;
                        }
                        case 47: {
                            this.sb.append('/');
                            continue block18;
                        }
                        case 39: {
                            this.sb.append('\'');
                            continue block18;
                        }
                        case 34: {
                            this.sb.append('\"');
                            continue block18;
                        }
                        case 117: {
                            this.sb.append(this.readUnicode());
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case 10: 
                case 13: {
                    continue block18;
                }
            }
            this.sb.append((char)this.c);
        }
    }

    private char readUnicode() throws IOException, ParseException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value *= 16;
            this.read();
            if (this.c >= 48 && this.c <= 57) {
                value += this.c - 48;
                continue;
            }
            if (this.c >= 65 && this.c <= 70) {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 97 && this.c <= 102) {
                value += this.c - 97 + 10;
                continue;
            }
            if (this.c == -1) {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 1, "Invalid Unicode value " + (char)this.c);
        }
        return (char)value;
    }

    private void skipDigits() throws IOException {
        while (this.c != -1) {
            if (this.c < 48 || this.c > 57) {
                return;
            }
            this.sb.append((char)this.c);
            this.read();
        }
        return;
    }

    private void skipNQString(boolean[] stop) throws IOException {
        while (this.c != -1) {
            if (this.c >= 0 && this.c <= 125 && stop[this.c]) {
                return;
            }
            this.sb.append((char)this.c);
            this.read();
        }
        return;
    }

    private void skipSpace() throws IOException {
        while (this.c != -1) {
            if (this.c != 32 && this.c != 13 && this.c != 9 && this.c != 10) {
                return;
            }
            this.sb.append((char)this.c);
            this.read();
        }
        return;
    }
}

