/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.ErrorConsts;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.EntityNames;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class AsyncByteScanner
extends ByteBasedScanner {
    public static final int EVENT_INCOMPLETE = 257;
    static final int STATE_DEFAULT = 0;
    static final int STATE_PROLOG_SEEN_LT = 1;
    static final int STATE_PROLOG_DECL = 2;
    static final int STATE_TREE_SEEN_LT = 1;
    static final int STATE_TREE_SEEN_AMP = 2;
    static final int STATE_TREE_SEEN_EXCL = 3;
    static final int STATE_TREE_SEEN_SLASH = 4;
    static final int STATE_TEXT_ENTITY = 1;
    static final int STATE_TEXT_BRACKET1 = 2;
    static final int STATE_TEXT_BRACKET2 = 3;
    static final int STATE_COMMENT_CONTENT = 1;
    static final int STATE_COMMENT_HYPHEN = 2;
    static final int STATE_COMMENT_HYPHEN2 = 3;
    static final int STATE_PI_AFTER_TARGET = 1;
    static final int STATE_PI_AFTER_TARGET_WS = 2;
    static final int STATE_PI_AFTER_TARGET_QMARK = 3;
    static final int STATE_PI_IN_TARGET = 4;
    static final int STATE_PI_IN_DATA = 5;
    static final int STATE_SE_ELEM_NAME = 1;
    static final int STATE_SE_SPACE_OR_END = 2;
    static final int STATE_SE_SPACE_OR_ATTRNAME = 3;
    static final int STATE_SE_ATTR_NAME = 4;
    static final int STATE_SE_SPACE_OR_EQ = 5;
    static final int STATE_SE_SPACE_OR_ATTRVALUE = 6;
    static final int STATE_SE_ATTR_VALUE_NORMAL = 7;
    static final int STATE_SE_ATTR_VALUE_NSDECL = 8;
    static final int STATE_SE_SEEN_SLASH = 9;
    static final int STATE_SE_ENTITY = 10;
    static final int STATE_EE_NEED_GT = 1;
    static final int STATE_ENT_SEEN_HASH = 1;
    static final int STATE_ENT_SEEN_HASHX = 2;
    static final int STATE_ENT_IN_DEC_DIGIT = 3;
    static final int STATE_ENT_IN_HEX_DIGIT = 4;
    static final int STATE_ENT_IN_NAME = 5;
    protected byte[] _inputBuffer;
    protected int mOrigBufferLen;
    protected int mNextEvent = 257;
    protected int mState = 0;
    protected int mSurroundingEvent = 257;
    protected int mPendingInput = 0;
    protected int mQuadCount;
    protected int _currQuad;
    protected int _currQuadBytes = 0;
    protected boolean mElemAllNsBound;
    protected boolean mElemAttrCount;
    protected byte mElemAttrQuote;
    protected PName mElemAttrName;
    protected int mElemAttrPtr;

    public AsyncByteScanner(ReaderConfig cfg) {
        super(cfg);
    }

    public String toString() {
        return "[curr=" + this._currToken + " next=" + this.mNextEvent + ", state = " + this.mState + "]";
    }

    public final boolean hasInput() {
        return this._inputPtr < this._inputEnd;
    }

    public void addInput(byte[] buf, int start, int len) throws XMLStreamException {
        if (this.hasInput()) {
            throw new XMLStreamException("Still have " + (this._inputEnd - this._inputPtr) + " unread bytes");
        }
        this.mPastBytes += this.mOrigBufferLen;
        this.mRowStartOffset -= this.mOrigBufferLen;
        this._inputBuffer = buf;
        this._inputPtr = start;
        this._inputEnd = start + len;
        this.mOrigBufferLen = len;
    }

    @Override
    protected void _closeSource() throws IOException {
    }

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        if (this._currToken != 257) {
            assert (!this._tokenIncomplete);
            this.mNextEvent = 257;
            this._currToken = 257;
            this.mState = 0;
        }
        if (this.mNextEvent == 257) {
            byte b;
            if (this.mPendingInput != 0 && !this.handlePartialCR()) {
                return this._currToken;
            }
            while (this.mState == 0) {
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == 60) {
                    this.mState = 1;
                    break;
                }
                if (b == 32 || b == 13 || b == 10 || b == 9) {
                    if (this.asyncSkipSpace()) continue;
                    return this._currToken;
                }
                this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), null);
            }
            if (this.mState == 1) {
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == 33) {
                    this.mState = 2;
                    return this.handlePrologDeclStart(isProlog);
                }
                if (b == 63) {
                    this.mNextEvent = 3;
                    this.mState = 0;
                    return this.handlePI();
                }
                if (b == 47 || !isProlog) {
                    this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (unbalanced start/end tags?)");
                }
                return this.handleStartElementStart(b);
            }
            if (this.mState == 2) {
                return this.handlePrologDeclStart(isProlog);
            }
            return this.throwInternal();
        }
        switch (this.mNextEvent) {
            case 1: {
                return this.handleStartElement();
            }
            case 3: {
                return this.handlePI();
            }
            case 5: {
                return this.handleComment();
            }
            case 11: {
                return this.handleDTD();
            }
        }
        return this.throwInternal();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int nextFromTree() throws XMLStreamException {
        block35: {
            block36: {
                byte b;
                block34: {
                    if (this._currToken != 257) {
                        if (this._currToken == 1) {
                            if (this._isEmptyTag) {
                                --this._depth;
                                this._currToken = 2;
                                return 2;
                            }
                        } else if (this._currToken == 2) {
                            this._currElem = this._currElem.getParent();
                            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                                this._lastNsDecl = this._lastNsDecl.unbind();
                            }
                        }
                        if (this._tokenIncomplete) {
                            this.skipCharacters();
                            this._tokenIncomplete = false;
                        }
                        this.mNextEvent = 257;
                        this._currToken = 257;
                        this.mState = 0;
                    }
                    if (this.mNextEvent != 257) break block35;
                    if (this.mState == 0) {
                        if (this.mPendingInput != 0) {
                            this.mNextEvent = 4;
                            return this.startCharactersPending();
                        }
                        if (this._inputPtr >= this._inputEnd) {
                            return this._currToken;
                        }
                        if ((b = this._inputBuffer[this._inputPtr++]) == 60) {
                            this.mState = 1;
                        } else {
                            if (b != 38) {
                                this.mNextEvent = 4;
                                return this.startCharacters(b);
                            }
                            this.mState = 2;
                        }
                    }
                    if (this._inputPtr >= this._inputEnd) {
                        return this._currToken;
                    }
                    if (this.mState == 1) {
                        if ((b = this._inputBuffer[this._inputPtr++]) == 33) {
                            this.mState = 3;
                            break block34;
                        } else {
                            if (b == 63) {
                                this.mNextEvent = 3;
                                this.mState = 0;
                                return this.handlePI();
                            }
                            if (b != 47) return this.handleStartElementStart(b);
                            return this.handleEndElementStart();
                        }
                    }
                    if (this.mState == 2) {
                        return this.handleEntityStart(257, this._inputBuffer[this._inputPtr++]);
                    }
                }
                if (this.mState != 3) break block36;
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
                    this.mNextEvent = 5;
                    this.mState = 0;
                    break block35;
                } else if (b == 91) {
                    this.mNextEvent = 12;
                    this.mState = 0;
                    break block35;
                } else {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
                }
                break block35;
            }
            this.throwInternal();
        }
        switch (this.mNextEvent) {
            case 1: {
                return this.handleStartElement();
            }
            case 2: {
                return this.handleEndElement();
            }
            case 3: {
                return this.handlePI();
            }
            case 5: {
                return this.handleComment();
            }
            case 12: {
                return this.handleCData();
            }
            case 4: {
                if (!this._cfgLazyParsing && this._cfgCoalescing) {
                    return this.finishCharactersCoalescing();
                }
                this.throwInternal();
                return this.throwInternal();
            }
        }
        return this.throwInternal();
    }

    private boolean asyncSkipSpace() throws XMLStreamException {
        while (this._inputPtr < this._inputEnd) {
            byte b = this._inputBuffer[this._inputPtr];
            if ((b & 0xFF) > 32) {
                return true;
            }
            ++this._inputPtr;
            if (b == 10) {
                this.markLF();
                continue;
            }
            if (b == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.mPendingInput = 13;
                    break;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (b == 32 || b == 9) continue;
            this.throwInvalidSpace(b);
        }
        return false;
    }

    private final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
            this.mNextEvent = 5;
            this.mState = 0;
            return this.handleComment();
        }
        if (b == 68) {
            this.mNextEvent = 11;
            this.mState = 0;
            return this.handleDTD();
        }
        this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (expected '-' for COMMENT)");
        return 257;
    }

    private int handlePI() throws XMLStreamException {
        if (this.mState == 5) {
            return this.parsePIData();
        }
        block7: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            switch (this.mState) {
                case 0: {
                    this._textBuilder.resetWithEmpty();
                    this._tokenName = this.parseNewName(this._inputBuffer[this._inputPtr++]);
                    if (this._tokenName == null) {
                        this.mState = 4;
                        return 257;
                    }
                    this.checkPITargetName(this._tokenName);
                    this.mState = 1;
                }
                case 1: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 63) {
                        if (this._inputPtr < this._inputEnd && this._inputBuffer[this._inputPtr] == 62) {
                            ++this._inputPtr;
                            break block7;
                        }
                        this.mState = 3;
                        continue block7;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        if (!this.asyncSkipSpace()) {
                            this.mState = 2;
                            return 257;
                        }
                        if (this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr] == 63 && this._inputBuffer[this._inputPtr + 1] == 62) {
                            this._inputPtr += 2;
                            break block7;
                        }
                        this.mState = 5;
                        return this.parsePIData();
                    }
                    this.reportMissingPISpace(this.decodeCharForError(b));
                }
                case 2: {
                    if (!this.asyncSkipSpace()) {
                        return 257;
                    }
                    this.mState = 5;
                    return this.parsePIData();
                }
                case 3: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 62) break block7;
                    this.reportMissingPISpace(this.decodeCharForError(b));
                    break block7;
                }
                case 4: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) {
                        return 257;
                    }
                    this.checkPITargetName(this._tokenName);
                    this.mState = 1;
                    continue block7;
                }
                default: {
                    return this.throwInternal();
                }
            }
            break;
        }
        this.mState = 0;
        this.mNextEvent = 257;
        return 3;
    }

    private int handleComment() throws XMLStreamException {
        if (this.mState == 1) {
            return this.parseCommentContents();
        }
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        byte b = this._inputBuffer[this._inputPtr++];
        if (this.mState == 0) {
            if (b != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '-' for COMMENT)");
            }
            this.mState = 1;
            this._textBuilder.resetWithEmpty();
            return this.parseCommentContents();
        }
        if (this.mState == 3) {
            if (b != 62) {
                this.reportDoubleHyphenInComments();
            }
            this.mState = 0;
            this.mNextEvent = 257;
            return 5;
        }
        return this.throwInternal();
    }

    protected abstract int parseCommentContents() throws XMLStreamException;

    protected abstract int parsePIData() throws XMLStreamException;

    protected abstract int startCharacters(byte var1) throws XMLStreamException;

    protected abstract int startCharactersPending() throws XMLStreamException;

    protected abstract int finishCharactersCoalescing() throws XMLStreamException;

    private int handleCData() throws XMLStreamException {
        return 0;
    }

    private int handleDTD() throws XMLStreamException {
        return 0;
    }

    protected int handleEntityStart(int surroundingEvent, byte b) throws XMLStreamException {
        this.mNextEvent = 9;
        this.mSurroundingEvent = surroundingEvent;
        if (b == 35) {
            this.mState = 1;
            return this.handleEntity();
        }
        PName n = this.parseNewName(b);
        if (n != null) {
            return this.handleGeneralEntity(n);
        }
        this.mState = 5;
        return 257;
    }

    protected int handleEntity() throws XMLStreamException {
        return 0;
    }

    protected final int handleGeneralEntity(PName entityName) {
        String name = entityName.getPrefixedName();
        if (name == "amp" || name == "lt" || name == "apos" || name == "quot" || name == "gt") {
            // empty if block
        }
        return 257;
    }

    protected int handleStartElementStart(byte b) throws XMLStreamException {
        PName elemName = this.parseNewName(b);
        this.mNextEvent = 1;
        if (elemName == null) {
            this.mState = 1;
            return 257;
        }
        this.initStartElement(elemName);
        return this.handleStartElement();
    }

    protected int handleStartElement() throws XMLStreamException {
        block14: while (this._inputPtr < this._inputEnd) {
            switch (this.mState) {
                case 1: {
                    PName elemName = this.parsePName();
                    if (elemName == null) {
                        return 257;
                    }
                    this.initStartElement(elemName);
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                }
                case 2: {
                    byte b;
                    int c;
                    if (this.mPendingInput != 0) {
                        if (!this.handlePartialCR()) {
                            return 257;
                        }
                    } else if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32) {
                        if (c == 10) {
                            this.markLF();
                        } else if (c == 13) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.mPendingInput = c;
                                return 257;
                            }
                            if (this._inputBuffer[this._inputPtr] == 10) {
                                ++this._inputPtr;
                            }
                            this.markLF();
                        } else if (c != 32 && c != 9) {
                            this.throwInvalidSpace(c);
                        }
                    } else {
                        if (c == 62) {
                            return this.finishStartElement(false);
                        }
                        if (c == 47) {
                            this.mState = 9;
                        } else {
                            this.throwUnexpectedChar(this.decodeCharForError(b), " expected space, or '>' or \"/>\"");
                        }
                    }
                    this.mState = 3;
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                }
                case 3: 
                case 5: 
                case 6: {
                    PName n;
                    if (this.mPendingInput != 0) {
                        if (!this.handlePartialCR()) {
                            return 257;
                        }
                        if (this._inputPtr >= this._inputEnd) {
                            return 257;
                        }
                    }
                    byte b = this._inputBuffer[this._inputPtr++];
                    int c = b & 0xFF;
                    while (c <= 32) {
                        if (c == 10) {
                            this.markLF();
                        } else if (c == 13) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.mPendingInput = c;
                                return 257;
                            }
                            if (this._inputBuffer[this._inputPtr] == 10) {
                                ++this._inputPtr;
                            }
                            this.markLF();
                        } else if (c != 32 && c != 9) {
                            this.throwInvalidSpace(c);
                        }
                        if (this._inputPtr >= this._inputEnd) {
                            return 257;
                        }
                        b = this._inputBuffer[this._inputPtr];
                        c = b & 0xFF;
                    }
                    switch (this.mState) {
                        case 3: {
                            n = this.parseNewName(b);
                            if (n == null) {
                                this.mState = 4;
                                return 257;
                            }
                            this.mState = 5;
                            this.mElemAttrName = n;
                            continue block14;
                        }
                        case 5: {
                            if (b != 61) {
                                this.throwUnexpectedChar(this.decodeCharForError(b), " expected '='");
                            }
                            this.mState = 6;
                            continue block14;
                        }
                        case 6: {
                            if (b != 34 && b != 39) {
                                this.throwUnexpectedChar(this.decodeCharForError(b), " Expected a quote");
                            }
                            this.initAttribute(b);
                            continue block14;
                        }
                    }
                    this.throwInternal();
                }
                case 4: {
                    PName n = this.parsePName();
                    if (n == null) {
                        return 257;
                    }
                    this.mElemAttrName = n;
                    this.mState = 5;
                    continue block14;
                }
                case 7: {
                    if (!this.handleAttrValue()) {
                        return 257;
                    }
                    this.mState = 2;
                    continue block14;
                }
                case 8: {
                    if (!this.handleNsDecl()) {
                        return 257;
                    }
                    this.mState = 2;
                    continue block14;
                }
                case 9: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b != 62) {
                        this.throwUnexpectedChar(this.decodeCharForError(b), " expected '>'");
                    }
                    return this.finishStartElement(true);
                }
            }
            this.throwInternal();
        }
        return 257;
    }

    private void initStartElement(PName elemName) {
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            this.mElemAllNsBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            this.mElemAllNsBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        this._attrCount = 0;
        this.mElemAttrPtr = 0;
        this.mState = 2;
    }

    private void initAttribute(byte quoteChar) {
        boolean nsDecl;
        this.mElemAttrQuote = quoteChar;
        PName attrName = this.mElemAttrName;
        String prefix = attrName.getPrefix();
        if (prefix == null) {
            nsDecl = attrName.getLocalName() == "xmlns";
        } else if (prefix == "xmlns") {
            nsDecl = true;
        } else {
            attrName = this.bindName(attrName, prefix);
            if (this.mElemAllNsBound) {
                this.mElemAllNsBound = attrName.isBound();
            }
            nsDecl = false;
        }
        if (nsDecl) {
            this.mState = 8;
            this.mElemAttrPtr = 0;
        } else {
            this.mState = 7;
            this._attrCollector.startNewValue(attrName, this.mElemAttrPtr);
        }
    }

    protected abstract boolean handleAttrValue() throws XMLStreamException;

    protected abstract boolean handleNsDecl() throws XMLStreamException;

    private int finishStartElement(boolean emptyTag) throws XMLStreamException {
        this._isEmptyTag = emptyTag;
        int act = this._attrCollector.finishLastValue(this.mElemAttrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!this.mElemAllNsBound) {
            if (!this._tokenName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PName attrName = this._attrCollector.getName(i);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        this._currToken = 1;
        return 1;
    }

    private int handleEndElementStart() throws XMLStreamException {
        int q;
        --this._depth;
        this._tokenName = this._currElem.getName();
        int size = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (size << 2) + 1) {
            this.mNextEvent = 2;
            this.mState = 0;
            this._currQuadBytes = 0;
            this._currQuad = 0;
            this.mQuadCount = 0;
            return this.handleEndElement();
        }
        byte[] buf = this._inputBuffer;
        --size;
        for (int qix = 0; qix < size; ++qix) {
            int ptr = this._inputPtr;
            int q2 = buf[ptr] << 24 | (buf[ptr + 1] & 0xFF) << 16 | (buf[ptr + 2] & 0xFF) << 8 | buf[ptr + 3] & 0xFF;
            this._inputPtr += 4;
            if (q2 == this._tokenName.getQuad(qix)) continue;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int lastQ = this._tokenName.getQuad(size);
        if ((q = buf[this._inputPtr++] & 0xFF) != lastQ && (q = q << 8 | buf[this._inputPtr++] & 0xFF) != lastQ && (q = q << 8 | buf[this._inputPtr++] & 0xFF) != lastQ && (q = q << 8 | buf[this._inputPtr++] & 0xFF) != lastQ) {
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int i2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.mPendingInput = i2;
                    this.mNextEvent = 2;
                    this.mState = 1;
                    return 257;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.mNextEvent = 2;
                this.mState = 1;
                return 257;
            }
            i2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        this._currToken = 2;
        return 2;
    }

    private int handleEndElement() throws XMLStreamException {
        int i2;
        if (this.mState == 0) {
            block17: {
                PName elemName = this._tokenName;
                int quadSize = elemName.sizeInQuads() - 1;
                while (this.mQuadCount < quadSize) {
                    while (this._currQuadBytes < 4) {
                        if (this._inputPtr >= this._inputEnd) {
                            return 257;
                        }
                        this._currQuad = this._currQuad << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                        ++this._currQuadBytes;
                    }
                    if (this._currQuad != elemName.getQuad(this.mQuadCount)) {
                        this.reportUnexpectedEndTag(elemName.getPrefixedName());
                    }
                    this._currQuadBytes = 0;
                    this._currQuad = 0;
                    ++this.mQuadCount;
                }
                int lastQ = elemName.getLastQuad();
                do {
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                    int q = this._currQuad << 8;
                    this._currQuad = q |= this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (q == lastQ) break block17;
                } while (++this._currQuadBytes <= 3);
                this.reportUnexpectedEndTag(elemName.getPrefixedName());
            }
            this.mState = 1;
        } else if (this.mState != 1) {
            this.throwInternal();
        }
        if (this.mPendingInput != 0 && !this.handlePartialCR()) {
            return 257;
        }
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) break;
            if (i2 == 10) {
                this.markLF();
                continue;
            }
            if (i2 == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.mPendingInput = i2;
                    return 257;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (i2 == 32 || i2 == 9) continue;
            this.throwInvalidSpace(i2);
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        this._currToken = 2;
        return 2;
    }

    @Override
    protected abstract void finishCharacters() throws XMLStreamException;

    @Override
    protected void finishCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishDTD(boolean copyContents) throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected abstract boolean skipCharacters() throws XMLStreamException;

    @Override
    protected void skipCData() throws XMLStreamException {
    }

    @Override
    protected void skipComment() throws XMLStreamException {
    }

    @Override
    protected void skipPI() throws XMLStreamException {
    }

    @Override
    protected void skipSpace() throws XMLStreamException {
    }

    @Override
    protected boolean loadMore() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    protected PName parseNewName(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        this.mQuadCount = 0;
        this._currQuad = q;
        this._currQuadBytes = 1;
        return this.parsePName();
    }

    protected PName parseNewEntityName(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        this.mQuadCount = 0;
        this._currQuad = q;
        this._currQuadBytes = 1;
        return this.parseEntityName();
    }

    protected PName parsePName() throws XMLStreamException {
        int q = this._currQuad;
        while (true) {
            switch (this._currQuadBytes) {
                case 0: {
                    if (this._inputPtr >= this._inputEnd) {
                        return null;
                    }
                    if ((q = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (q < 45 || q > 58 || q == 47)) {
                        return this.findPName(q, 0);
                    }
                }
                case 1: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 1;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 1);
                    }
                    q = q << 8 | i;
                }
                case 2: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 2;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 2);
                    }
                    q = q << 8 | i;
                }
                case 3: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 3;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 3);
                    }
                    q = q << 8 | i;
                }
            }
            if (this.mQuadCount == 0) {
                this.mQuadBuffer[0] = q;
                this.mQuadCount = 1;
            } else {
                if (this.mQuadCount >= this.mQuadBuffer.length) {
                    this.mQuadBuffer = DataUtil.growArrayBy(this.mQuadBuffer, this.mQuadBuffer.length);
                }
                this.mQuadBuffer[this.mQuadCount++] = q;
            }
            this._currQuadBytes = 0;
        }
    }

    protected PName parseEntityName() throws XMLStreamException {
        int q = this._currQuad;
        while (true) {
            switch (this._currQuadBytes) {
                case 0: {
                    if (this._inputPtr >= this._inputEnd) {
                        return null;
                    }
                    if ((q = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (q < 45 || q > 58 || q == 47)) {
                        if (this.mQuadCount == 1) {
                            q = this.mQuadBuffer[0];
                            if (q == EntityNames.ENTITY_APOS_QUAD) {
                                return EntityNames.ENTITY_APOS;
                            }
                            if (q == EntityNames.ENTITY_QUOT_QUAD) {
                                return EntityNames.ENTITY_QUOT;
                            }
                        }
                        return this.findPName(q, 0);
                    }
                }
                case 1: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 1;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 1);
                    }
                    q = q << 8 | i;
                }
                case 2: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 2;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        if (this.mQuadCount == 0) {
                            if (q == EntityNames.ENTITY_GT_QUAD) {
                                return EntityNames.ENTITY_GT;
                            }
                            if (q == EntityNames.ENTITY_LT_QUAD) {
                                return EntityNames.ENTITY_LT;
                            }
                        }
                        return this.findPName(q, 2);
                    }
                    q = q << 8 | i;
                }
                case 3: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 3;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        if (this.mQuadCount == 0 && q == EntityNames.ENTITY_AMP_QUAD) {
                            return EntityNames.ENTITY_AMP;
                        }
                        return this.findPName(q, 3);
                    }
                    q = q << 8 | i;
                }
            }
            if (this.mQuadCount == 0) {
                this.mQuadBuffer[0] = q;
                this.mQuadCount = 1;
            } else {
                if (this.mQuadCount >= this.mQuadBuffer.length) {
                    this.mQuadBuffer = DataUtil.growArrayBy(this.mQuadBuffer, this.mQuadBuffer.length);
                }
                this.mQuadBuffer[this.mQuadCount++] = q;
            }
            this._currQuadBytes = 0;
        }
    }

    private final PName findPName(int lastQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int qlen = this.mQuadCount;
        if (lastByteCount == 0) {
            lastQuad = this.mQuadBuffer[--qlen];
            lastByteCount = 4;
        }
        if (qlen <= 1) {
            if (qlen == 0) {
                int hash = ByteBasedPNameTable.calcHash(lastQuad);
                PName name = this.mSymbols.findSymbol(hash, lastQuad, 0);
                if (name == null) {
                    this.mQuadBuffer[0] = lastQuad;
                    name = this.addPName(hash, this.mQuadBuffer, 1, lastByteCount);
                }
                return name;
            }
            int firstQuad = this.mQuadBuffer[0];
            int hash = ByteBasedPNameTable.calcHash(firstQuad, lastQuad);
            PName name = this.mSymbols.findSymbol(hash, firstQuad, lastQuad);
            if (name == null) {
                this.mQuadBuffer[1] = lastQuad;
                name = this.addPName(hash, this.mQuadBuffer, 2, lastByteCount);
            }
            return name;
        }
        if (qlen >= this.mQuadBuffer.length) {
            this.mQuadBuffer = DataUtil.growArrayBy(this.mQuadBuffer, this.mQuadBuffer.length);
        }
        this.mQuadBuffer[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(this.mQuadBuffer, qlen);
        PName name = this.mSymbols.findSymbol(hash, this.mQuadBuffer, qlen);
        if (name == null) {
            name = this.addPName(hash, this.mQuadBuffer, qlen, lastByteCount);
        }
        return name;
    }

    @Override
    protected abstract PName addPName(int var1, int[] var2, int var3, int var4) throws XMLStreamException;

    @Override
    protected int decodeCharForError(byte b) throws XMLStreamException {
        return b;
    }

    private void checkPITargetName(PName targetName) throws XMLStreamException {
        String ln = targetName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && !targetName.hasPrefix()) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
    }

    protected int handleCharacterEntity() throws XMLStreamException {
        return 0;
    }

    protected final boolean handlePartialCR() {
        if (this.mPendingInput != 13) {
            this.throwInternal();
        }
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        this.mPendingInput = 0;
        if (this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currRow;
        this.mRowStartOffset = this._inputPtr;
        return true;
    }

    protected int throwInternal() {
        throw new IllegalStateException("Internal error: should never execute this code path");
    }
}

