/*
 * Copyright (c) 2015 2016, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name of Intel Corporation nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * This file contains the definition of the configuration database interface. 
 *
 * It is auto-generated by the db_schema_gen. To make changes to this file 
 * modify the schema.h.template.
 */
#ifndef _SCHEMA_H_
#define	_SCHEMA_H_
#ifdef __cplusplus
extern "C" {
#endif
/*!
 * @defgroup db_schema The Database Model
 */
/*!
 * all db functions should return one of these return codes.
 * @ingroup db_schema
 */
enum db_return_codes
{
	DB_SUCCESS = 0, //!< Just in case it's not clear ... this is good
	DB_ERR_FAILURE = -1 //!< Well ... pretty sure this is bad
};
/*!
 * Opaque structure to hide storage details (sqlite)
 * @ingroup db_schema
 */
typedef struct persistentStore PersistentStore;
/*!
 * Creates the memory for and creates a new file for, and instantiates a new PersistentStore.
 * @param path 
 *		Path where the PersistentStore will be stored
 * @param force 
 *		If the file already exists and force is true, then the file will be deleted first
 * @return A pointer to the PersistentStore created.  @ref free_PersistentStore should be called on this pointer
 * to close the file and free memory
 * @ingroup db_schema
 */
PersistentStore *create_PersistentStore(const char *path, int force);
/*!
 * Creates the memory for and instantiates a new PersistentStore object.  It assumes the store already exists.
 * @param path 
 *		Path to the existing PersistentStore file
 * @return A pointer to the PersistentStore created.  @ref free_PersistentStore should be called on this pointer
 * to close the file and free memory
 * @ingroup db_schema
 */
PersistentStore *open_PersistentStore(const char *path);
/*!
 * Close and free the PersistentStore
 * @param Pointer to the PersistentStore created by create_PersistentStore or open_PersistentStore
 * @ingroup db_schema
 */
int free_PersistentStore(PersistentStore **);
/*!
 * Add a new history instance
 * @param[in] p_ps Pointer to the PersistentStore to act upon
 * @param[in] history_name User friendly name to associate to this history instance
 * @param[out] p_history_id User friendly name to associate to this history instance
 * @return enum db_return_codes
 * @ingroup db_schema
 */
enum db_return_codes db_add_history(PersistentStore *p_ps, const char *history_name, int *p_history_id);
/*!
 * Start a new Transaction.
 * @param p_ps Pointer to the PersistentStore to act upon
 * @return enum db_return_codes
 * @details
 * See http://www.sqlite.org/lang_transaction.html for details on using transactions, but basically no change
 * can be made to the database except within a transaction. Any command that changes the database will automatically
 * start a transaction if one is not already in effect. Automatically started transactions are committed when the query finishes.
 * By Beginning a transaction independent of a changing SQL statement then several statements can be committed at once, potentially
 * improving performance.
 * @ingroup db_schema
 */
enum db_return_codes db_begin_transaction(PersistentStore *p_ps);
/*!
 * End a Transaction began with db_begin_transaction
 * @ingroup db_schema
 */
enum db_return_codes db_end_transaction(PersistentStore *p_ps);
/*!
 * undo any changes made within a transaction
 * @ingroup db_schema
 */
enum db_return_codes db_rollback_transaction(PersistentStore *p_ps);
/*!
 * Run a custom SQL Query
 */
 enum db_return_codes db_run_custom_sql(PersistentStore *p_ps, const char *sql);
 /*!
 * Returns the number of rows in the table name provided.  If there is an issue with the
 * query (or the table doesn't exist) will return 0.
 */
 enum db_return_codes table_row_count(const PersistentStore *p_ps, const char *table_name, int *p_count);
 /*!
 * Execute some SQL on a sqlite db and expect a single int value as result
 */
enum db_return_codes run_scalar_sql(const PersistentStore *p_ps, const char *sql, int *p_scalar);
/*!
 * Execute some SQL on a sqlite db and expect a single char* value as result
 */
enum db_return_codes run_text_scalar_sql(const PersistentStore *p_ps, const char *sql, char *p_value, int len);
/*
 * An array containing all history table names automatically generated
 * from the Entity declarations in schema_generator/main.cpp
 */
 extern char* history_table_names[];
/*!
 * @defgroup config config 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	CONFIG_KEY_LEN 256 //!< Max length for key
#define	CONFIG_VALUE_LEN 1024 //!< Max length for value
/*!
 * struct representing the config table
 * @ingroup config
 */
struct db_config
{
	char   key[CONFIG_KEY_LEN];
	char   value[CONFIG_VALUE_LEN];
};
/*!
 * Helper function to print a db_config to the screen.
 * @ingroup config
 * @param p_config
 * 		value to print
 * @return
 *		void
 */
void db_print_config(struct db_config *p_value);
/*!
 * Create a new row in the config table
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_config
 *		Pointer to the object to be saved to the config table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_config(const PersistentStore *p_ps, struct db_config *p_config);
/*!
 * Get the total number of configs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of configs
 * @return whether successful or not
 */
enum db_return_codes db_get_config_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all configs
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_config
 *		Pointer to an array of config objects that will contain all the configs
 * @param[in] config_count
 *		Size of p_config
 * @return The number of row (to max of config_count) on success.  DB_FAILURE on failure.
 */
int db_get_configs(const PersistentStore *p_ps,
	struct db_config
	*p_config,
	int config_count);
/*!
 * Truncate all the data in the config table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_configs(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from config history
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_config_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save config state
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the config to
 * @param[in] p_config
 *		config to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_config_state(const PersistentStore *p_ps,
	int history_id,
	struct db_config *p_config);
/*!
 * Return a specific config for a given key
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] key
 *		key to identify the correct config
 * @param[out] p_config
 *		struct to put the config retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_config_by_key(const PersistentStore *p_ps,
	const char * key,
	struct db_config *p_config);
/*!
 * Update a specific config given the original key
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] key
 * 		key points to the config to update
 * @param[in] *p_updated_config
 *		structure with new values for the config
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_config_by_key(const PersistentStore *p_ps,
	const char * key,
	struct db_config *p_updated_config);
/*!
 * Delete a specific config given the key
 * @ingroup config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] key
 *		key points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_config_by_key(const PersistentStore *p_ps,
	const char * key);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of config_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_config_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of config_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_config_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_config
 *		Structure type for row results
 * @param[in] p_config
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of config_count) on success.  DB_FAILURE on failure.
 */
 int db_get_config_history_by_history_id(const PersistentStore *p_ps,
	struct db_config *p_config,
	int history_id,
	int config_count);
/*!
 * @defgroup log log 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	LOG_FILE_NAME_LEN 1024 //!< Max length for file_name
#define	LOG_MESSAGE_LEN 2048 //!< Max length for message
/*!
 * struct representing the log table
 * @ingroup log
 */
struct db_log
{
	int id;
	unsigned long long thread_id;
	unsigned long long time;
	int level;
	char   file_name[LOG_FILE_NAME_LEN];
	unsigned int line_number;
	char   message[LOG_MESSAGE_LEN];
};
/*!
 * Helper function to print a db_log to the screen.
 * @ingroup log
 * @param p_log
 * 		value to print
 * @return
 *		void
 */
void db_print_log(struct db_log *p_value);
/*!
 * Create a new row in the log table
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_log
 *		Pointer to the object to be saved to the log table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_log(const PersistentStore *p_ps, struct db_log *p_log);
/*!
 * Get the total number of logs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of logs
 * @return whether successful or not
 */
enum db_return_codes db_get_log_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all logs
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_log
 *		Pointer to an array of log objects that will contain all the logs
 * @param[in] log_count
 *		Size of p_log
 * @return The number of row (to max of log_count) on success.  DB_FAILURE on failure.
 */
int db_get_logs(const PersistentStore *p_ps,
	struct db_log
	*p_log,
	int log_count);
/*!
 * Truncate all the data in the log table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_logs(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from log history
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_log_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save log state
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the log to
 * @param[in] p_log
 *		log to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_log_state(const PersistentStore *p_ps,
	int history_id,
	struct db_log *p_log);
/*!
 * Return a specific log for a given id
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct log
 * @param[out] p_log
 *		struct to put the log retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_log_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_log *p_log);
/*!
 * Update a specific log given the original id
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the log to update
 * @param[in] *p_updated_log
 *		structure with new values for the log
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_log_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_log *p_updated_log);
/*!
 * Delete a specific log given the id
 * @ingroup log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_log_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of log_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_log_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of log_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_log_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_log
 *		Structure type for row results
 * @param[in] p_log
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of log_count) on success.  DB_FAILURE on failure.
 */
 int db_get_log_history_by_history_id(const PersistentStore *p_ps,
	struct db_log *p_log,
	int history_id,
	int log_count);
/*!
 * @defgroup event event 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	EVENT_UID_LEN 37 //!< Max length for uid
#define	EVENT_ARG1_LEN 1024 //!< Max length for arg1
#define	EVENT_ARG2_LEN 1024 //!< Max length for arg2
#define	EVENT_ARG3_LEN 1024 //!< Max length for arg3
/*!
 * struct representing the event table
 * @ingroup event
 */
struct db_event
{
	int id;
	unsigned int type;
	unsigned int severity;
	unsigned int code;
	unsigned int action_required;
	char   uid[EVENT_UID_LEN];
	unsigned long long time;
	char   arg1[EVENT_ARG1_LEN];
	char   arg2[EVENT_ARG2_LEN];
	char   arg3[EVENT_ARG3_LEN];
	unsigned int diag_result;
};
/*!
 * Helper function to print a db_event to the screen.
 * @ingroup event
 * @param p_event
 * 		value to print
 * @return
 *		void
 */
void db_print_event(struct db_event *p_value);
/*!
 * Create a new row in the event table
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_event
 *		Pointer to the object to be saved to the event table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_event(const PersistentStore *p_ps, struct db_event *p_event);
/*!
 * Get the total number of events
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of events
 * @return whether successful or not
 */
enum db_return_codes db_get_event_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all events
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_event
 *		Pointer to an array of event objects that will contain all the events
 * @param[in] event_count
 *		Size of p_event
 * @return The number of row (to max of event_count) on success.  DB_FAILURE on failure.
 */
int db_get_events(const PersistentStore *p_ps,
	struct db_event
	*p_event,
	int event_count);
/*!
 * Truncate all the data in the event table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_events(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from event history
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_event_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save event state
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the event to
 * @param[in] p_event
 *		event to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_event_state(const PersistentStore *p_ps,
	int history_id,
	struct db_event *p_event);
/*!
 * Return a specific event for a given id
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct event
 * @param[out] p_event
 *		struct to put the event retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_event_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_event *p_event);
/*!
 * Update a specific event given the original id
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the event to update
 * @param[in] *p_updated_event
 *		structure with new values for the event
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_event_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_event *p_updated_event);
/*!
 * Delete a specific event given the id
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_event_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of event_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_event_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of event_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_event_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_event
 *		Structure type for row results
 * @param[in] p_event
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of event_count) on success.  DB_FAILURE on failure.
 */
 int db_get_event_history_by_history_id(const PersistentStore *p_ps,
	struct db_event *p_event,
	int history_id,
	int event_count);
/*!
 * Return the number of events for a given event_type.type
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  type
 *		Search event and get count for all with passed in type
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_event_count_by_event_type_type (const PersistentStore *p_ps,
	const unsigned int type, int *p_count);
/*!
 * Return a list of events for a given event_type.type
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  type
 *		Search event and get all with passed in type
 * @param[out] p_event
 *		memory to hold the found events
 * @param[in]   event_count
 *		Size of event array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_events_by_event_type_type(const PersistentStore *p_ps,
	unsigned int type,
	struct db_event *p_event,
	int event_count);
/*!
 * Delete a list of specific events for a given event_type.type
 * @ingroup event
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  type
 *		Search event and get all with passed in type
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_event_by_event_type_type(const PersistentStore *p_ps,
	unsigned int type);
/*!
 * @defgroup topology_state topology_state 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	TOPOLOGY_STATE_UID_LEN 37 //!< Max length for uid
#define	TOPOLOGY_STATE_MODEL_NUM_LEN 21 //!< Max length for model_num
/*!
 * struct representing the topology_state table
 * @ingroup topology_state
 */
struct db_topology_state
{
	unsigned int device_handle;
	char   uid[TOPOLOGY_STATE_UID_LEN];
	unsigned int manufacturer;
	unsigned int serial_num;
	char   model_num[TOPOLOGY_STATE_MODEL_NUM_LEN];
	int current_config_status;
	int config_goal_status;
};
/*!
 * Helper function to print a db_topology_state to the screen.
 * @ingroup topology_state
 * @param p_topology_state
 * 		value to print
 * @return
 *		void
 */
void db_print_topology_state(struct db_topology_state *p_value);
/*!
 * Create a new row in the topology_state table
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_topology_state
 *		Pointer to the object to be saved to the topology_state table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_topology_state(const PersistentStore *p_ps, struct db_topology_state *p_topology_state);
/*!
 * Get the total number of topology_states
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of topology_states
 * @return whether successful or not
 */
enum db_return_codes db_get_topology_state_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all topology_states
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_topology_state
 *		Pointer to an array of topology_state objects that will contain all the topology_states
 * @param[in] topology_state_count
 *		Size of p_topology_state
 * @return The number of row (to max of topology_state_count) on success.  DB_FAILURE on failure.
 */
int db_get_topology_states(const PersistentStore *p_ps,
	struct db_topology_state
	*p_topology_state,
	int topology_state_count);
/*!
 * Truncate all the data in the topology_state table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_topology_states(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from topology_state history
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_topology_state_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save topology_state state
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the topology_state to
 * @param[in] p_topology_state
 *		topology_state to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_topology_state_state(const PersistentStore *p_ps,
	int history_id,
	struct db_topology_state *p_topology_state);
/*!
 * Return a specific topology_state for a given device_handle
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct topology_state
 * @param[out] p_topology_state
 *		struct to put the topology_state retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_topology_state_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_topology_state *p_topology_state);
/*!
 * Update a specific topology_state given the original device_handle
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the topology_state to update
 * @param[in] *p_updated_topology_state
 *		structure with new values for the topology_state
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_topology_state_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_topology_state *p_updated_topology_state);
/*!
 * Delete a specific topology_state given the device_handle
 * @ingroup topology_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_topology_state_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of topology_state_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_topology_state_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of topology_state_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_topology_state_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_topology_state
 *		Structure type for row results
 * @param[in] p_topology_state
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of topology_state_count) on success.  DB_FAILURE on failure.
 */
 int db_get_topology_state_history_by_history_id(const PersistentStore *p_ps,
	struct db_topology_state *p_topology_state,
	int history_id,
	int topology_state_count);
/*!
 * @defgroup host host 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	HOST_NAME_LEN 256 //!< Max length for name
#define	HOST_OS_NAME_LEN 256 //!< Max length for os_name
#define	HOST_OS_VERSION_LEN 256 //!< Max length for os_version
/*!
 * struct representing the host table
 * @ingroup host
 */
struct db_host
{
	char   name[HOST_NAME_LEN];
	int os_type;
	char   os_name[HOST_OS_NAME_LEN];
	char   os_version[HOST_OS_VERSION_LEN];
};
/*!
 * Helper function to print a db_host to the screen.
 * @ingroup host
 * @param p_host
 * 		value to print
 * @return
 *		void
 */
void db_print_host(struct db_host *p_value);
/*!
 * Create a new row in the host table
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_host
 *		Pointer to the object to be saved to the host table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_host(const PersistentStore *p_ps, struct db_host *p_host);
/*!
 * Get the total number of hosts
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of hosts
 * @return whether successful or not
 */
enum db_return_codes db_get_host_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all hosts
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_host
 *		Pointer to an array of host objects that will contain all the hosts
 * @param[in] host_count
 *		Size of p_host
 * @return The number of row (to max of host_count) on success.  DB_FAILURE on failure.
 */
int db_get_hosts(const PersistentStore *p_ps,
	struct db_host
	*p_host,
	int host_count);
/*!
 * Truncate all the data in the host table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_hosts(const PersistentStore *p_ps);

/*!
 * delete all entries from host history
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_host_history(const PersistentStore *p_ps);
 
/*!
 * save host state
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the host to
 * @param[in] p_host
 *		host to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_host_state(const PersistentStore *p_ps,
	int history_id,
	struct db_host *p_host);
/*!
 * Return a specific host for a given name
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] name
 *		name to identify the correct host
 * @param[out] p_host
 *		struct to put the host retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_host_by_name(const PersistentStore *p_ps,
	const char * name,
	struct db_host *p_host);
/*!
 * Update a specific host given the original name
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] name
 * 		name points to the host to update
 * @param[in] *p_updated_host
 *		structure with new values for the host
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_host_by_name(const PersistentStore *p_ps,
	const char * name,
	struct db_host *p_updated_host);
/*!
 * Delete a specific host given the name
 * @ingroup host
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] name
 *		name points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_host_by_name(const PersistentStore *p_ps,
	const char * name);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of host_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_host_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of host_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_host_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_host
 *		Structure type for row results
 * @param[in] p_host
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of host_count) on success.  DB_FAILURE on failure.
 */
 int db_get_host_history_by_history_id(const PersistentStore *p_ps,
	struct db_host *p_host,
	int history_id,
	int host_count);
/*!
 * @defgroup sw_inventory sw_inventory 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	SW_INVENTORY_NAME_LEN 256 //!< Max length for name
#define	SW_INVENTORY_MGMT_SW_REV_LEN 25 //!< Max length for mgmt_sw_rev
#define	SW_INVENTORY_VENDOR_DRIVER_REV_LEN 25 //!< Max length for vendor_driver_rev
/*!
 * struct representing the sw_inventory table
 * @ingroup sw_inventory
 */
struct db_sw_inventory
{
	char   name[SW_INVENTORY_NAME_LEN];
	char   mgmt_sw_rev[SW_INVENTORY_MGMT_SW_REV_LEN];
	char   vendor_driver_rev[SW_INVENTORY_VENDOR_DRIVER_REV_LEN];
	unsigned int supported_driver_available;
};
/*!
 * Helper function to print a db_sw_inventory to the screen.
 * @ingroup sw_inventory
 * @param p_sw_inventory
 * 		value to print
 * @return
 *		void
 */
void db_print_sw_inventory(struct db_sw_inventory *p_value);
/*!
 * Create a new row in the sw_inventory table
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_sw_inventory
 *		Pointer to the object to be saved to the sw_inventory table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_sw_inventory(const PersistentStore *p_ps, struct db_sw_inventory *p_sw_inventory);
/*!
 * Get the total number of sw_inventorys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of sw_inventorys
 * @return whether successful or not
 */
enum db_return_codes db_get_sw_inventory_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all sw_inventorys
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_sw_inventory
 *		Pointer to an array of sw_inventory objects that will contain all the sw_inventorys
 * @param[in] sw_inventory_count
 *		Size of p_sw_inventory
 * @return The number of row (to max of sw_inventory_count) on success.  DB_FAILURE on failure.
 */
int db_get_sw_inventorys(const PersistentStore *p_ps,
	struct db_sw_inventory
	*p_sw_inventory,
	int sw_inventory_count);
/*!
 * Truncate all the data in the sw_inventory table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_sw_inventorys(const PersistentStore *p_ps);

/*!
 * delete all entries from sw_inventory history
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_sw_inventory_history(const PersistentStore *p_ps);
 
/*!
 * save sw_inventory state
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the sw_inventory to
 * @param[in] p_sw_inventory
 *		sw_inventory to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_sw_inventory_state(const PersistentStore *p_ps,
	int history_id,
	struct db_sw_inventory *p_sw_inventory);
/*!
 * Return a specific sw_inventory for a given name
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] name
 *		name to identify the correct sw_inventory
 * @param[out] p_sw_inventory
 *		struct to put the sw_inventory retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_sw_inventory_by_name(const PersistentStore *p_ps,
	const char * name,
	struct db_sw_inventory *p_sw_inventory);
/*!
 * Update a specific sw_inventory given the original name
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] name
 * 		name points to the sw_inventory to update
 * @param[in] *p_updated_sw_inventory
 *		structure with new values for the sw_inventory
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_sw_inventory_by_name(const PersistentStore *p_ps,
	const char * name,
	struct db_sw_inventory *p_updated_sw_inventory);
/*!
 * Delete a specific sw_inventory given the name
 * @ingroup sw_inventory
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] name
 *		name points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_sw_inventory_by_name(const PersistentStore *p_ps,
	const char * name);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of sw_inventory_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_sw_inventory_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of sw_inventory_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_sw_inventory_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_sw_inventory
 *		Structure type for row results
 * @param[in] p_sw_inventory
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of sw_inventory_count) on success.  DB_FAILURE on failure.
 */
 int db_get_sw_inventory_history_by_history_id(const PersistentStore *p_ps,
	struct db_sw_inventory *p_sw_inventory,
	int history_id,
	int sw_inventory_count);
/*!
 * @defgroup socket socket 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	SOCKET_MANUFACTURER_LEN 32 //!< Max length for manufacturer
/*!
 * struct representing the socket table
 * @ingroup socket
 */
struct db_socket
{
	unsigned int socket_id;
	unsigned int type;
	unsigned int model;
	unsigned int brand;
	unsigned int family;
	unsigned int stepping;
	char   manufacturer[SOCKET_MANUFACTURER_LEN];
	unsigned int logical_processor_count;
	unsigned int rapl_limited;
};
/*!
 * Helper function to print a db_socket to the screen.
 * @ingroup socket
 * @param p_socket
 * 		value to print
 * @return
 *		void
 */
void db_print_socket(struct db_socket *p_value);
/*!
 * Create a new row in the socket table
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_socket
 *		Pointer to the object to be saved to the socket table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_socket(const PersistentStore *p_ps, struct db_socket *p_socket);
/*!
 * Get the total number of sockets
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of sockets
 * @return whether successful or not
 */
enum db_return_codes db_get_socket_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all sockets
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_socket
 *		Pointer to an array of socket objects that will contain all the sockets
 * @param[in] socket_count
 *		Size of p_socket
 * @return The number of row (to max of socket_count) on success.  DB_FAILURE on failure.
 */
int db_get_sockets(const PersistentStore *p_ps,
	struct db_socket
	*p_socket,
	int socket_count);
/*!
 * Truncate all the data in the socket table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_sockets(const PersistentStore *p_ps);

/*!
 * delete all entries from socket history
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_socket_history(const PersistentStore *p_ps);
 
/*!
 * save socket state
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the socket to
 * @param[in] p_socket
 *		socket to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_socket_state(const PersistentStore *p_ps,
	int history_id,
	struct db_socket *p_socket);
/*!
 * Return a specific socket for a given socket_id
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] socket_id
 *		socket_id to identify the correct socket
 * @param[out] p_socket
 *		struct to put the socket retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_socket_by_socket_id(const PersistentStore *p_ps,
	const unsigned int socket_id,
	struct db_socket *p_socket);
/*!
 * Update a specific socket given the original socket_id
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] socket_id
 * 		socket_id points to the socket to update
 * @param[in] *p_updated_socket
 *		structure with new values for the socket
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_socket_by_socket_id(const PersistentStore *p_ps,
	const unsigned int socket_id,
	struct db_socket *p_updated_socket);
/*!
 * Delete a specific socket given the socket_id
 * @ingroup socket
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] socket_id
 *		socket_id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_socket_by_socket_id(const PersistentStore *p_ps,
	const unsigned int socket_id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of socket_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_socket_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of socket_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_socket_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_socket
 *		Structure type for row results
 * @param[in] p_socket
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of socket_count) on success.  DB_FAILURE on failure.
 */
 int db_get_socket_history_by_history_id(const PersistentStore *p_ps,
	struct db_socket *p_socket,
	int history_id,
	int socket_count);
/*!
 * @defgroup runtime_config_validation runtime_config_validation 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	RUNTIME_CONFIG_VALIDATION_GAS_STRUCTURE_COUNT 12 //!< Max length for gas_structure
/*!
 * struct representing the runtime_config_validation table
 * @ingroup runtime_config_validation
 */
struct db_runtime_config_validation
{
	int id;
	unsigned int type;
	unsigned int length;
	unsigned int address_space_id;
	unsigned int bit_width;
	unsigned int bit_offset;
	unsigned int access_size;
	unsigned long long address;
	unsigned int operation_type_1;
	unsigned long long value;
	unsigned long long mask_1;
	unsigned int gas_structure[RUNTIME_CONFIG_VALIDATION_GAS_STRUCTURE_COUNT];
	unsigned int operation_type_2;
	unsigned long long mask_2;
};
/*!
 * Helper function to print a db_runtime_config_validation to the screen.
 * @ingroup runtime_config_validation
 * @param p_runtime_config_validation
 * 		value to print
 * @return
 *		void
 */
void db_print_runtime_config_validation(struct db_runtime_config_validation *p_value);
/*!
 * Create a new row in the runtime_config_validation table
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_runtime_config_validation
 *		Pointer to the object to be saved to the runtime_config_validation table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_runtime_config_validation(const PersistentStore *p_ps, struct db_runtime_config_validation *p_runtime_config_validation);
/*!
 * Get the total number of runtime_config_validations
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of runtime_config_validations
 * @return whether successful or not
 */
enum db_return_codes db_get_runtime_config_validation_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all runtime_config_validations
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_runtime_config_validation
 *		Pointer to an array of runtime_config_validation objects that will contain all the runtime_config_validations
 * @param[in] runtime_config_validation_count
 *		Size of p_runtime_config_validation
 * @return The number of row (to max of runtime_config_validation_count) on success.  DB_FAILURE on failure.
 */
int db_get_runtime_config_validations(const PersistentStore *p_ps,
	struct db_runtime_config_validation
	*p_runtime_config_validation,
	int runtime_config_validation_count);
/*!
 * Truncate all the data in the runtime_config_validation table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_runtime_config_validations(const PersistentStore *p_ps);

/*!
 * delete all entries from runtime_config_validation history
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_runtime_config_validation_history(const PersistentStore *p_ps);
 
/*!
 * save runtime_config_validation state
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the runtime_config_validation to
 * @param[in] p_runtime_config_validation
 *		runtime_config_validation to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_runtime_config_validation_state(const PersistentStore *p_ps,
	int history_id,
	struct db_runtime_config_validation *p_runtime_config_validation);
/*!
 * Return a specific runtime_config_validation for a given id
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct runtime_config_validation
 * @param[out] p_runtime_config_validation
 *		struct to put the runtime_config_validation retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_runtime_config_validation_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_runtime_config_validation *p_runtime_config_validation);
/*!
 * Update a specific runtime_config_validation given the original id
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the runtime_config_validation to update
 * @param[in] *p_updated_runtime_config_validation
 *		structure with new values for the runtime_config_validation
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_runtime_config_validation_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_runtime_config_validation *p_updated_runtime_config_validation);
/*!
 * Delete a specific runtime_config_validation given the id
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_runtime_config_validation_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of runtime_config_validation_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_runtime_config_validation_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of runtime_config_validation_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_runtime_config_validation_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_runtime_config_validation
 *		Structure type for row results
 * @param[in] p_runtime_config_validation
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of runtime_config_validation_count) on success.  DB_FAILURE on failure.
 */
 int db_get_runtime_config_validation_history_by_history_id(const PersistentStore *p_ps,
	struct db_runtime_config_validation *p_runtime_config_validation,
	int history_id,
	int runtime_config_validation_count);
/*!
 * Roll runtime_config_validations by id to specified max.
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  max_rows
 *		The max table size
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_roll_runtime_config_validations_by_id(const PersistentStore *p_ps, int max_rows);
/*!
 * Get the max id in the runtime_config_validation table.
 * @ingroup runtime_config_validation
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in,out]  p_max
 *		The max id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_next_runtime_config_validation_id(const PersistentStore *p_ps, int *p_max);
/*!
 * @defgroup interleave_capability interleave_capability 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	INTERLEAVE_CAPABILITY_INTERLEAVE_FORMAT_LIST_COUNT 32 //!< Max length for interleave_format_list
/*!
 * struct representing the interleave_capability table
 * @ingroup interleave_capability
 */
struct db_interleave_capability
{
	int id;
	unsigned int type;
	unsigned int length;
	unsigned int memory_mode;
	unsigned int interleave_alignment_size;
	unsigned int supported_interleave_count;
	unsigned int interleave_format_list[INTERLEAVE_CAPABILITY_INTERLEAVE_FORMAT_LIST_COUNT];
};
/*!
 * Helper function to print a db_interleave_capability to the screen.
 * @ingroup interleave_capability
 * @param p_interleave_capability
 * 		value to print
 * @return
 *		void
 */
void db_print_interleave_capability(struct db_interleave_capability *p_value);
/*!
 * Create a new row in the interleave_capability table
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_interleave_capability
 *		Pointer to the object to be saved to the interleave_capability table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_interleave_capability(const PersistentStore *p_ps, struct db_interleave_capability *p_interleave_capability);
/*!
 * Get the total number of interleave_capabilitys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of interleave_capabilitys
 * @return whether successful or not
 */
enum db_return_codes db_get_interleave_capability_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all interleave_capabilitys
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_interleave_capability
 *		Pointer to an array of interleave_capability objects that will contain all the interleave_capabilitys
 * @param[in] interleave_capability_count
 *		Size of p_interleave_capability
 * @return The number of row (to max of interleave_capability_count) on success.  DB_FAILURE on failure.
 */
int db_get_interleave_capabilitys(const PersistentStore *p_ps,
	struct db_interleave_capability
	*p_interleave_capability,
	int interleave_capability_count);
/*!
 * Truncate all the data in the interleave_capability table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_interleave_capabilitys(const PersistentStore *p_ps);

/*!
 * delete all entries from interleave_capability history
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_interleave_capability_history(const PersistentStore *p_ps);
 
/*!
 * save interleave_capability state
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the interleave_capability to
 * @param[in] p_interleave_capability
 *		interleave_capability to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_interleave_capability_state(const PersistentStore *p_ps,
	int history_id,
	struct db_interleave_capability *p_interleave_capability);
/*!
 * Return a specific interleave_capability for a given id
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct interleave_capability
 * @param[out] p_interleave_capability
 *		struct to put the interleave_capability retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_interleave_capability_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_interleave_capability *p_interleave_capability);
/*!
 * Update a specific interleave_capability given the original id
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the interleave_capability to update
 * @param[in] *p_updated_interleave_capability
 *		structure with new values for the interleave_capability
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_interleave_capability_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_interleave_capability *p_updated_interleave_capability);
/*!
 * Delete a specific interleave_capability given the id
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_interleave_capability_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of interleave_capability_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_interleave_capability_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of interleave_capability_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_interleave_capability_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_interleave_capability
 *		Structure type for row results
 * @param[in] p_interleave_capability
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of interleave_capability_count) on success.  DB_FAILURE on failure.
 */
 int db_get_interleave_capability_history_by_history_id(const PersistentStore *p_ps,
	struct db_interleave_capability *p_interleave_capability,
	int history_id,
	int interleave_capability_count);
/*!
 * Roll interleave_capabilitys by id to specified max.
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  max_rows
 *		The max table size
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_roll_interleave_capabilitys_by_id(const PersistentStore *p_ps, int max_rows);
/*!
 * Get the max id in the interleave_capability table.
 * @ingroup interleave_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in,out]  p_max
 *		The max id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_next_interleave_capability_id(const PersistentStore *p_ps, int *p_max);
/*!
 * @defgroup platform_info_capability platform_info_capability 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the platform_info_capability table
 * @ingroup platform_info_capability
 */
struct db_platform_info_capability
{
	int id;
	unsigned int type;
	unsigned int length;
	unsigned int mgmt_sw_config_support;
	unsigned int mem_mode_capabilities;
	unsigned int current_mem_mode;
	unsigned int pmem_ras_capabilities;
};
/*!
 * Helper function to print a db_platform_info_capability to the screen.
 * @ingroup platform_info_capability
 * @param p_platform_info_capability
 * 		value to print
 * @return
 *		void
 */
void db_print_platform_info_capability(struct db_platform_info_capability *p_value);
/*!
 * Create a new row in the platform_info_capability table
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_platform_info_capability
 *		Pointer to the object to be saved to the platform_info_capability table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_platform_info_capability(const PersistentStore *p_ps, struct db_platform_info_capability *p_platform_info_capability);
/*!
 * Get the total number of platform_info_capabilitys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of platform_info_capabilitys
 * @return whether successful or not
 */
enum db_return_codes db_get_platform_info_capability_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all platform_info_capabilitys
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_platform_info_capability
 *		Pointer to an array of platform_info_capability objects that will contain all the platform_info_capabilitys
 * @param[in] platform_info_capability_count
 *		Size of p_platform_info_capability
 * @return The number of row (to max of platform_info_capability_count) on success.  DB_FAILURE on failure.
 */
int db_get_platform_info_capabilitys(const PersistentStore *p_ps,
	struct db_platform_info_capability
	*p_platform_info_capability,
	int platform_info_capability_count);
/*!
 * Truncate all the data in the platform_info_capability table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_platform_info_capabilitys(const PersistentStore *p_ps);

/*!
 * delete all entries from platform_info_capability history
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_platform_info_capability_history(const PersistentStore *p_ps);
 
/*!
 * save platform_info_capability state
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the platform_info_capability to
 * @param[in] p_platform_info_capability
 *		platform_info_capability to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_platform_info_capability_state(const PersistentStore *p_ps,
	int history_id,
	struct db_platform_info_capability *p_platform_info_capability);
/*!
 * Return a specific platform_info_capability for a given id
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct platform_info_capability
 * @param[out] p_platform_info_capability
 *		struct to put the platform_info_capability retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_platform_info_capability_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_platform_info_capability *p_platform_info_capability);
/*!
 * Update a specific platform_info_capability given the original id
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the platform_info_capability to update
 * @param[in] *p_updated_platform_info_capability
 *		structure with new values for the platform_info_capability
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_platform_info_capability_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_platform_info_capability *p_updated_platform_info_capability);
/*!
 * Delete a specific platform_info_capability given the id
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_platform_info_capability_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of platform_info_capability_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_platform_info_capability_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of platform_info_capability_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_platform_info_capability_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_platform_info_capability
 *		Structure type for row results
 * @param[in] p_platform_info_capability
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of platform_info_capability_count) on success.  DB_FAILURE on failure.
 */
 int db_get_platform_info_capability_history_by_history_id(const PersistentStore *p_ps,
	struct db_platform_info_capability *p_platform_info_capability,
	int history_id,
	int platform_info_capability_count);
/*!
 * Roll platform_info_capabilitys by id to specified max.
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  max_rows
 *		The max table size
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_roll_platform_info_capabilitys_by_id(const PersistentStore *p_ps, int max_rows);
/*!
 * Get the max id in the platform_info_capability table.
 * @ingroup platform_info_capability
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in,out]  p_max
 *		The max id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_next_platform_info_capability_id(const PersistentStore *p_ps, int *p_max);
/*!
 * @defgroup platform_capabilities platform_capabilities 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	PLATFORM_CAPABILITIES_SIGNATURE_LEN 4 //!< Max length for signature
#define	PLATFORM_CAPABILITIES_OEM_ID_LEN 6 //!< Max length for oem_id
#define	PLATFORM_CAPABILITIES_OEM_TABLE_ID_LEN 8 //!< Max length for oem_table_id
#define	PLATFORM_CAPABILITIES_CREATOR_ID_COUNT 4 //!< Max length for creator_id
/*!
 * struct representing the platform_capabilities table
 * @ingroup platform_capabilities
 */
struct db_platform_capabilities
{
	char   signature[PLATFORM_CAPABILITIES_SIGNATURE_LEN];
	unsigned int length;
	unsigned int revision;
	unsigned int checksum;
	char   oem_id[PLATFORM_CAPABILITIES_OEM_ID_LEN];
	char   oem_table_id[PLATFORM_CAPABILITIES_OEM_TABLE_ID_LEN];
	unsigned int oem_revision;
	unsigned int creator_id[PLATFORM_CAPABILITIES_CREATOR_ID_COUNT];
	unsigned int creator_revision;
};
/*!
 * Helper function to print a db_platform_capabilities to the screen.
 * @ingroup platform_capabilities
 * @param p_platform_capabilities
 * 		value to print
 * @return
 *		void
 */
void db_print_platform_capabilities(struct db_platform_capabilities *p_value);
/*!
 * Create a new row in the platform_capabilities table
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_platform_capabilities
 *		Pointer to the object to be saved to the platform_capabilities table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_platform_capabilities(const PersistentStore *p_ps, struct db_platform_capabilities *p_platform_capabilities);
/*!
 * Get the total number of platform_capabilitiess
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of platform_capabilitiess
 * @return whether successful or not
 */
enum db_return_codes db_get_platform_capabilities_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all platform_capabilitiess
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_platform_capabilities
 *		Pointer to an array of platform_capabilities objects that will contain all the platform_capabilitiess
 * @param[in] platform_capabilities_count
 *		Size of p_platform_capabilities
 * @return The number of row (to max of platform_capabilities_count) on success.  DB_FAILURE on failure.
 */
int db_get_platform_capabilitiess(const PersistentStore *p_ps,
	struct db_platform_capabilities
	*p_platform_capabilities,
	int platform_capabilities_count);
/*!
 * Truncate all the data in the platform_capabilities table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_platform_capabilitiess(const PersistentStore *p_ps);

/*!
 * delete all entries from platform_capabilities history
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_platform_capabilities_history(const PersistentStore *p_ps);
 
/*!
 * save platform_capabilities state
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the platform_capabilities to
 * @param[in] p_platform_capabilities
 *		platform_capabilities to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_platform_capabilities_state(const PersistentStore *p_ps,
	int history_id,
	struct db_platform_capabilities *p_platform_capabilities);
/*!
 * Return a specific platform_capabilities for a given signature
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] signature
 *		signature to identify the correct platform_capabilities
 * @param[out] p_platform_capabilities
 *		struct to put the platform_capabilities retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_platform_capabilities_by_signature(const PersistentStore *p_ps,
	const char * signature,
	struct db_platform_capabilities *p_platform_capabilities);
/*!
 * Update a specific platform_capabilities given the original signature
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] signature
 * 		signature points to the platform_capabilities to update
 * @param[in] *p_updated_platform_capabilities
 *		structure with new values for the platform_capabilities
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_platform_capabilities_by_signature(const PersistentStore *p_ps,
	const char * signature,
	struct db_platform_capabilities *p_updated_platform_capabilities);
/*!
 * Delete a specific platform_capabilities given the signature
 * @ingroup platform_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] signature
 *		signature points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_platform_capabilities_by_signature(const PersistentStore *p_ps,
	const char * signature);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of platform_capabilities_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_platform_capabilities_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of platform_capabilities_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_platform_capabilities_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_platform_capabilities
 *		Structure type for row results
 * @param[in] p_platform_capabilities
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of platform_capabilities_count) on success.  DB_FAILURE on failure.
 */
 int db_get_platform_capabilities_history_by_history_id(const PersistentStore *p_ps,
	struct db_platform_capabilities *p_platform_capabilities,
	int history_id,
	int platform_capabilities_count);
/*!
 * @defgroup driver_capabilities driver_capabilities 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DRIVER_CAPABILITIES_BLOCK_SIZES_COUNT 16 //!< Max length for block_sizes
/*!
 * struct representing the driver_capabilities table
 * @ingroup driver_capabilities
 */
struct db_driver_capabilities
{
	int id;
	unsigned long long min_namespace_size;
	unsigned long long max_non_continguous_namespaces;
	unsigned int block_sizes[DRIVER_CAPABILITIES_BLOCK_SIZES_COUNT];
	unsigned int num_block_sizes;
	unsigned int namespace_memory_page_allocation_capable;
};
/*!
 * Helper function to print a db_driver_capabilities to the screen.
 * @ingroup driver_capabilities
 * @param p_driver_capabilities
 * 		value to print
 * @return
 *		void
 */
void db_print_driver_capabilities(struct db_driver_capabilities *p_value);
/*!
 * Create a new row in the driver_capabilities table
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_driver_capabilities
 *		Pointer to the object to be saved to the driver_capabilities table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_driver_capabilities(const PersistentStore *p_ps, struct db_driver_capabilities *p_driver_capabilities);
/*!
 * Get the total number of driver_capabilitiess
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of driver_capabilitiess
 * @return whether successful or not
 */
enum db_return_codes db_get_driver_capabilities_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all driver_capabilitiess
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_driver_capabilities
 *		Pointer to an array of driver_capabilities objects that will contain all the driver_capabilitiess
 * @param[in] driver_capabilities_count
 *		Size of p_driver_capabilities
 * @return The number of row (to max of driver_capabilities_count) on success.  DB_FAILURE on failure.
 */
int db_get_driver_capabilitiess(const PersistentStore *p_ps,
	struct db_driver_capabilities
	*p_driver_capabilities,
	int driver_capabilities_count);
/*!
 * Truncate all the data in the driver_capabilities table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_driver_capabilitiess(const PersistentStore *p_ps);

/*!
 * delete all entries from driver_capabilities history
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_driver_capabilities_history(const PersistentStore *p_ps);
 
/*!
 * save driver_capabilities state
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the driver_capabilities to
 * @param[in] p_driver_capabilities
 *		driver_capabilities to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_driver_capabilities_state(const PersistentStore *p_ps,
	int history_id,
	struct db_driver_capabilities *p_driver_capabilities);
/*!
 * Return a specific driver_capabilities for a given id
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct driver_capabilities
 * @param[out] p_driver_capabilities
 *		struct to put the driver_capabilities retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_driver_capabilities_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_driver_capabilities *p_driver_capabilities);
/*!
 * Update a specific driver_capabilities given the original id
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the driver_capabilities to update
 * @param[in] *p_updated_driver_capabilities
 *		structure with new values for the driver_capabilities
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_driver_capabilities_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_driver_capabilities *p_updated_driver_capabilities);
/*!
 * Delete a specific driver_capabilities given the id
 * @ingroup driver_capabilities
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_driver_capabilities_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of driver_capabilities_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_driver_capabilities_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of driver_capabilities_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_driver_capabilities_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_driver_capabilities
 *		Structure type for row results
 * @param[in] p_driver_capabilities
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of driver_capabilities_count) on success.  DB_FAILURE on failure.
 */
 int db_get_driver_capabilities_history_by_history_id(const PersistentStore *p_ps,
	struct db_driver_capabilities *p_driver_capabilities,
	int history_id,
	int driver_capabilities_count);
/*!
 * @defgroup driver_features driver_features 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the driver_features table
 * @ingroup driver_features
 */
struct db_driver_features
{
	int id;
	unsigned int get_platform_capabilities;
	unsigned int get_topology;
	unsigned int get_interleave;
	unsigned int get_dimm_detail;
	unsigned int get_namespaces;
	unsigned int get_namespace_detail;
	unsigned int get_address_scrub_data;
	unsigned int get_platform_config_data;
	unsigned int get_boot_status;
	unsigned int get_power_data;
	unsigned int get_security_state;
	unsigned int get_log_page;
	unsigned int get_features;
	unsigned int set_features;
	unsigned int create_namespace;
	unsigned int rename_namespace;
	unsigned int grow_namespace;
	unsigned int shrink_namespace;
	unsigned int delete_namespace;
	unsigned int enable_namespace;
	unsigned int disable_namespace;
	unsigned int set_security_state;
	unsigned int enable_logging;
	unsigned int run_diagnostic;
	unsigned int set_platform_config;
	unsigned int passthrough;
	unsigned int start_address_scrub;
	unsigned int app_direct_mode;
	unsigned int storage_mode;
};
/*!
 * Helper function to print a db_driver_features to the screen.
 * @ingroup driver_features
 * @param p_driver_features
 * 		value to print
 * @return
 *		void
 */
void db_print_driver_features(struct db_driver_features *p_value);
/*!
 * Create a new row in the driver_features table
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_driver_features
 *		Pointer to the object to be saved to the driver_features table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_driver_features(const PersistentStore *p_ps, struct db_driver_features *p_driver_features);
/*!
 * Get the total number of driver_featuress
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of driver_featuress
 * @return whether successful or not
 */
enum db_return_codes db_get_driver_features_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all driver_featuress
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_driver_features
 *		Pointer to an array of driver_features objects that will contain all the driver_featuress
 * @param[in] driver_features_count
 *		Size of p_driver_features
 * @return The number of row (to max of driver_features_count) on success.  DB_FAILURE on failure.
 */
int db_get_driver_featuress(const PersistentStore *p_ps,
	struct db_driver_features
	*p_driver_features,
	int driver_features_count);
/*!
 * Truncate all the data in the driver_features table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_driver_featuress(const PersistentStore *p_ps);

/*!
 * delete all entries from driver_features history
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_driver_features_history(const PersistentStore *p_ps);
 
/*!
 * save driver_features state
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the driver_features to
 * @param[in] p_driver_features
 *		driver_features to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_driver_features_state(const PersistentStore *p_ps,
	int history_id,
	struct db_driver_features *p_driver_features);
/*!
 * Return a specific driver_features for a given id
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct driver_features
 * @param[out] p_driver_features
 *		struct to put the driver_features retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_driver_features_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_driver_features *p_driver_features);
/*!
 * Update a specific driver_features given the original id
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the driver_features to update
 * @param[in] *p_updated_driver_features
 *		structure with new values for the driver_features
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_driver_features_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_driver_features *p_updated_driver_features);
/*!
 * Delete a specific driver_features given the id
 * @ingroup driver_features
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_driver_features_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of driver_features_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_driver_features_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of driver_features_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_driver_features_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_driver_features
 *		Structure type for row results
 * @param[in] p_driver_features
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of driver_features_count) on success.  DB_FAILURE on failure.
 */
 int db_get_driver_features_history_by_history_id(const PersistentStore *p_ps,
	struct db_driver_features *p_driver_features,
	int history_id,
	int driver_features_count);
/*!
 * @defgroup dimm_topology dimm_topology 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_TOPOLOGY_INTERFACE_FORMAT_CODES_COUNT 9 //!< Max length for interface_format_codes
/*!
 * struct representing the dimm_topology table
 * @ingroup dimm_topology
 */
struct db_dimm_topology
{
	unsigned int device_handle;
	unsigned int id;
	unsigned int vendor_id;
	unsigned int device_id;
	unsigned int revision_id;
	unsigned int subsystem_vendor_id;
	unsigned int subsystem_device_id;
	unsigned int subsystem_revision_id;
	unsigned int manufacturing_info_valid;
	unsigned int manufacturing_location;
	unsigned int manufacturing_date;
	unsigned int type;
	unsigned int interface_format_codes[DIMM_TOPOLOGY_INTERFACE_FORMAT_CODES_COUNT];
};
/*!
 * Helper function to print a db_dimm_topology to the screen.
 * @ingroup dimm_topology
 * @param p_dimm_topology
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_topology(struct db_dimm_topology *p_value);
/*!
 * Create a new row in the dimm_topology table
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_topology
 *		Pointer to the object to be saved to the dimm_topology table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_topology(const PersistentStore *p_ps, struct db_dimm_topology *p_dimm_topology);
/*!
 * Get the total number of dimm_topologys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_topologys
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_topology_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_topologys
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_topology
 *		Pointer to an array of dimm_topology objects that will contain all the dimm_topologys
 * @param[in] dimm_topology_count
 *		Size of p_dimm_topology
 * @return The number of row (to max of dimm_topology_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_topologys(const PersistentStore *p_ps,
	struct db_dimm_topology
	*p_dimm_topology,
	int dimm_topology_count);
/*!
 * Truncate all the data in the dimm_topology table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_topologys(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_topology history
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_topology_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_topology state
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_topology to
 * @param[in] p_dimm_topology
 *		dimm_topology to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_topology_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_topology *p_dimm_topology);
/*!
 * Return a specific dimm_topology for a given device_handle
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_topology
 * @param[out] p_dimm_topology
 *		struct to put the dimm_topology retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_topology_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_topology *p_dimm_topology);
/*!
 * Update a specific dimm_topology given the original device_handle
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_topology to update
 * @param[in] *p_updated_dimm_topology
 *		structure with new values for the dimm_topology
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_topology_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_topology *p_updated_dimm_topology);
/*!
 * Delete a specific dimm_topology given the device_handle
 * @ingroup dimm_topology
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_topology_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_topology_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_topology_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_topology_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_topology_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_topology
 *		Structure type for row results
 * @param[in] p_dimm_topology
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_topology_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_topology_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_topology *p_dimm_topology,
	int history_id,
	int dimm_topology_count);
/*!
 * @defgroup namespace namespace 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	NAMESPACE_NAMESPACE_UID_LEN 37 //!< Max length for namespace_uid
#define	NAMESPACE_FRIENDLY_NAME_LEN 64 //!< Max length for friendly_name
/*!
 * struct representing the namespace table
 * @ingroup namespace
 */
struct db_namespace
{
	char   namespace_uid[NAMESPACE_NAMESPACE_UID_LEN];
	char   friendly_name[NAMESPACE_FRIENDLY_NAME_LEN];
	unsigned int block_size;
	unsigned long long block_count;
	unsigned int type;
	unsigned int health;
	unsigned int enabled;
	unsigned int btt;
	unsigned int device_handle;
	unsigned int interleave_set_index;
	unsigned int memory_page_allocation;
};
/*!
 * Helper function to print a db_namespace to the screen.
 * @ingroup namespace
 * @param p_namespace
 * 		value to print
 * @return
 *		void
 */
void db_print_namespace(struct db_namespace *p_value);
/*!
 * Create a new row in the namespace table
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_namespace
 *		Pointer to the object to be saved to the namespace table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_namespace(const PersistentStore *p_ps, struct db_namespace *p_namespace);
/*!
 * Get the total number of namespaces
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of namespaces
 * @return whether successful or not
 */
enum db_return_codes db_get_namespace_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all namespaces
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_namespace
 *		Pointer to an array of namespace objects that will contain all the namespaces
 * @param[in] namespace_count
 *		Size of p_namespace
 * @return The number of row (to max of namespace_count) on success.  DB_FAILURE on failure.
 */
int db_get_namespaces(const PersistentStore *p_ps,
	struct db_namespace
	*p_namespace,
	int namespace_count);
/*!
 * Truncate all the data in the namespace table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_namespaces(const PersistentStore *p_ps);

/*!
 * delete all entries from namespace history
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_namespace_history(const PersistentStore *p_ps);
 
/*!
 * save namespace state
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the namespace to
 * @param[in] p_namespace
 *		namespace to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_namespace_state(const PersistentStore *p_ps,
	int history_id,
	struct db_namespace *p_namespace);
/*!
 * Return a specific namespace for a given namespace_uid
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] namespace_uid
 *		namespace_uid to identify the correct namespace
 * @param[out] p_namespace
 *		struct to put the namespace retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_namespace_by_namespace_uid(const PersistentStore *p_ps,
	const char * namespace_uid,
	struct db_namespace *p_namespace);
/*!
 * Update a specific namespace given the original namespace_uid
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] namespace_uid
 * 		namespace_uid points to the namespace to update
 * @param[in] *p_updated_namespace
 *		structure with new values for the namespace
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_namespace_by_namespace_uid(const PersistentStore *p_ps,
	const char * namespace_uid,
	struct db_namespace *p_updated_namespace);
/*!
 * Delete a specific namespace given the namespace_uid
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] namespace_uid
 *		namespace_uid points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_namespace_by_namespace_uid(const PersistentStore *p_ps,
	const char * namespace_uid);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of namespace_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_namespace_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of namespace_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_namespace_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_namespace
 *		Structure type for row results
 * @param[in] p_namespace
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of namespace_count) on success.  DB_FAILURE on failure.
 */
 int db_get_namespace_history_by_history_id(const PersistentStore *p_ps,
	struct db_namespace *p_namespace,
	int history_id,
	int namespace_count);
/*!
 * Return the number of namespaces for a given dimm_topology.device_handle
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search namespace and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_namespace_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of namespaces for a given dimm_topology.device_handle
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search namespace and get all with passed in device_handle
 * @param[out] p_namespace
 *		memory to hold the found namespaces
 * @param[in]   namespace_count
 *		Size of namespace array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_namespaces_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_namespace *p_namespace,
	int namespace_count);
/*!
 * Delete a list of specific namespaces for a given dimm_topology.device_handle
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search namespace and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_namespace_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * Return the number of namespaces for a given interleave_set_dimm_info.index_id
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  interleave_set_index
 *		Search namespace and get count for all with passed in interleave_set_index
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_namespace_count_by_interleave_set_dimm_info_index_id (const PersistentStore *p_ps,
	const unsigned int interleave_set_index, int *p_count);
/*!
 * Return a list of namespaces for a given interleave_set_dimm_info.index_id
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  interleave_set_index
 *		Search namespace and get all with passed in interleave_set_index
 * @param[out] p_namespace
 *		memory to hold the found namespaces
 * @param[in]   namespace_count
 *		Size of namespace array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_namespaces_by_interleave_set_dimm_info_index_id(const PersistentStore *p_ps,
	unsigned int interleave_set_index,
	struct db_namespace *p_namespace,
	int namespace_count);
/*!
 * Delete a list of specific namespaces for a given interleave_set_dimm_info.index_id
 * @ingroup namespace
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  interleave_set_index
 *		Search namespace and get all with passed in interleave_set_index
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_namespace_by_interleave_set_dimm_info_index_id(const PersistentStore *p_ps,
	unsigned int interleave_set_index);
/*!
 * @defgroup identify_dimm identify_dimm 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	IDENTIFY_DIMM_FW_REVISION_LEN 14 //!< Max length for fw_revision
#define	IDENTIFY_DIMM_MODEL_NUM_LEN 21 //!< Max length for model_num
/*!
 * struct representing the identify_dimm table
 * @ingroup identify_dimm
 */
struct db_identify_dimm
{
	unsigned int device_handle;
	unsigned int vendor_id;
	unsigned int device_id;
	unsigned int revision_id;
	unsigned int interface_format_code;
	char   fw_revision[IDENTIFY_DIMM_FW_REVISION_LEN];
	unsigned int fw_api_version;
	unsigned int fw_sw_mask;
	unsigned int dimm_sku;
	unsigned int block_windows;
	unsigned int write_flush_addresses;
	unsigned long long write_flush_address_start;
	unsigned int block_control_region_offset;
	unsigned long long raw_cap;
	unsigned int manufacturer;
	unsigned int serial_num;
	char   model_num[IDENTIFY_DIMM_MODEL_NUM_LEN];
};
/*!
 * Helper function to print a db_identify_dimm to the screen.
 * @ingroup identify_dimm
 * @param p_identify_dimm
 * 		value to print
 * @return
 *		void
 */
void db_print_identify_dimm(struct db_identify_dimm *p_value);
/*!
 * Create a new row in the identify_dimm table
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_identify_dimm
 *		Pointer to the object to be saved to the identify_dimm table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_identify_dimm(const PersistentStore *p_ps, struct db_identify_dimm *p_identify_dimm);
/*!
 * Get the total number of identify_dimms
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of identify_dimms
 * @return whether successful or not
 */
enum db_return_codes db_get_identify_dimm_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all identify_dimms
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_identify_dimm
 *		Pointer to an array of identify_dimm objects that will contain all the identify_dimms
 * @param[in] identify_dimm_count
 *		Size of p_identify_dimm
 * @return The number of row (to max of identify_dimm_count) on success.  DB_FAILURE on failure.
 */
int db_get_identify_dimms(const PersistentStore *p_ps,
	struct db_identify_dimm
	*p_identify_dimm,
	int identify_dimm_count);
/*!
 * Truncate all the data in the identify_dimm table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_identify_dimms(const PersistentStore *p_ps);

/*!
 * delete all entries from identify_dimm history
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_identify_dimm_history(const PersistentStore *p_ps);
 
/*!
 * save identify_dimm state
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the identify_dimm to
 * @param[in] p_identify_dimm
 *		identify_dimm to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_identify_dimm_state(const PersistentStore *p_ps,
	int history_id,
	struct db_identify_dimm *p_identify_dimm);
/*!
 * Return a specific identify_dimm for a given device_handle
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct identify_dimm
 * @param[out] p_identify_dimm
 *		struct to put the identify_dimm retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_identify_dimm_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_identify_dimm *p_identify_dimm);
/*!
 * Update a specific identify_dimm given the original device_handle
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the identify_dimm to update
 * @param[in] *p_updated_identify_dimm
 *		structure with new values for the identify_dimm
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_identify_dimm_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_identify_dimm *p_updated_identify_dimm);
/*!
 * Delete a specific identify_dimm given the device_handle
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_identify_dimm_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of identify_dimm_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_identify_dimm_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of identify_dimm_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_identify_dimm_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_identify_dimm
 *		Structure type for row results
 * @param[in] p_identify_dimm
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of identify_dimm_count) on success.  DB_FAILURE on failure.
 */
 int db_get_identify_dimm_history_by_history_id(const PersistentStore *p_ps,
	struct db_identify_dimm *p_identify_dimm,
	int history_id,
	int identify_dimm_count);
/*!
 * Clear identify_dimm.serial_num for all rows
 * @ingroup identify_dimm
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_clear_identify_dimm_serial_num(PersistentStore *p_ps);
/*!
 * @defgroup device_characteristics device_characteristics 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the device_characteristics table
 * @ingroup device_characteristics
 */
struct db_device_characteristics
{
	unsigned int device_handle;
	unsigned int controller_temp_shutdown_threshold;
	unsigned int media_temp_shutdown_threshold;
	unsigned int throttling_start_threshold;
	unsigned int throttling_stop_threshold;
};
/*!
 * Helper function to print a db_device_characteristics to the screen.
 * @ingroup device_characteristics
 * @param p_device_characteristics
 * 		value to print
 * @return
 *		void
 */
void db_print_device_characteristics(struct db_device_characteristics *p_value);
/*!
 * Create a new row in the device_characteristics table
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_device_characteristics
 *		Pointer to the object to be saved to the device_characteristics table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_device_characteristics(const PersistentStore *p_ps, struct db_device_characteristics *p_device_characteristics);
/*!
 * Get the total number of device_characteristicss
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of device_characteristicss
 * @return whether successful or not
 */
enum db_return_codes db_get_device_characteristics_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all device_characteristicss
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_device_characteristics
 *		Pointer to an array of device_characteristics objects that will contain all the device_characteristicss
 * @param[in] device_characteristics_count
 *		Size of p_device_characteristics
 * @return The number of row (to max of device_characteristics_count) on success.  DB_FAILURE on failure.
 */
int db_get_device_characteristicss(const PersistentStore *p_ps,
	struct db_device_characteristics
	*p_device_characteristics,
	int device_characteristics_count);
/*!
 * Truncate all the data in the device_characteristics table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_device_characteristicss(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from device_characteristics history
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_device_characteristics_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save device_characteristics state
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the device_characteristics to
 * @param[in] p_device_characteristics
 *		device_characteristics to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_device_characteristics_state(const PersistentStore *p_ps,
	int history_id,
	struct db_device_characteristics *p_device_characteristics);
/*!
 * Return a specific device_characteristics for a given device_handle
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct device_characteristics
 * @param[out] p_device_characteristics
 *		struct to put the device_characteristics retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_device_characteristics_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_device_characteristics *p_device_characteristics);
/*!
 * Update a specific device_characteristics given the original device_handle
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the device_characteristics to update
 * @param[in] *p_updated_device_characteristics
 *		structure with new values for the device_characteristics
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_device_characteristics_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_device_characteristics *p_updated_device_characteristics);
/*!
 * Delete a specific device_characteristics given the device_handle
 * @ingroup device_characteristics
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_device_characteristics_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of device_characteristics_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_device_characteristics_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of device_characteristics_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_device_characteristics_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_device_characteristics
 *		Structure type for row results
 * @param[in] p_device_characteristics
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of device_characteristics_count) on success.  DB_FAILURE on failure.
 */
 int db_get_device_characteristics_history_by_history_id(const PersistentStore *p_ps,
	struct db_device_characteristics *p_device_characteristics,
	int history_id,
	int device_characteristics_count);
/*!
 * @defgroup dimm_partition dimm_partition 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_partition table
 * @ingroup dimm_partition
 */
struct db_dimm_partition
{
	unsigned int device_handle;
	int volatile_capacity;
	long long volatile_start;
	int pmem_capacity;
	long long pm_start;
	int raw_capacity;
};
/*!
 * Helper function to print a db_dimm_partition to the screen.
 * @ingroup dimm_partition
 * @param p_dimm_partition
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_partition(struct db_dimm_partition *p_value);
/*!
 * Create a new row in the dimm_partition table
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_partition
 *		Pointer to the object to be saved to the dimm_partition table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_partition(const PersistentStore *p_ps, struct db_dimm_partition *p_dimm_partition);
/*!
 * Get the total number of dimm_partitions
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_partitions
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_partition_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_partitions
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_partition
 *		Pointer to an array of dimm_partition objects that will contain all the dimm_partitions
 * @param[in] dimm_partition_count
 *		Size of p_dimm_partition
 * @return The number of row (to max of dimm_partition_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_partitions(const PersistentStore *p_ps,
	struct db_dimm_partition
	*p_dimm_partition,
	int dimm_partition_count);
/*!
 * Truncate all the data in the dimm_partition table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_partitions(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_partition history
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_partition_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_partition state
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_partition to
 * @param[in] p_dimm_partition
 *		dimm_partition to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_partition_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_partition *p_dimm_partition);
/*!
 * Return a specific dimm_partition for a given device_handle
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_partition
 * @param[out] p_dimm_partition
 *		struct to put the dimm_partition retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_partition_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_partition *p_dimm_partition);
/*!
 * Update a specific dimm_partition given the original device_handle
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_partition to update
 * @param[in] *p_updated_dimm_partition
 *		structure with new values for the dimm_partition
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_partition_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_partition *p_updated_dimm_partition);
/*!
 * Delete a specific dimm_partition given the device_handle
 * @ingroup dimm_partition
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_partition_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_partition_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_partition_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_partition_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_partition_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_partition
 *		Structure type for row results
 * @param[in] p_dimm_partition
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_partition_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_partition_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_partition *p_dimm_partition,
	int history_id,
	int dimm_partition_count);
/*!
 * @defgroup dimm_smart dimm_smart 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_smart table
 * @ingroup dimm_smart
 */
struct db_dimm_smart
{
	unsigned int device_handle;
	unsigned int validation_flags;
	unsigned int health_status;
	unsigned int media_temperature;
	unsigned int spare;
	unsigned int alarm_trips;
	unsigned int percentage_used;
	unsigned int lss;
	unsigned int vendor_specific_data_size;
	unsigned long long power_cycles;
	unsigned long long power_on_seconds;
	unsigned long long uptime;
	unsigned int unsafe_shutdowns;
	unsigned int lss_details;
	unsigned long long last_shutdown_time;
	unsigned int controller_temperature;
};
/*!
 * Helper function to print a db_dimm_smart to the screen.
 * @ingroup dimm_smart
 * @param p_dimm_smart
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_smart(struct db_dimm_smart *p_value);
/*!
 * Create a new row in the dimm_smart table
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_smart
 *		Pointer to the object to be saved to the dimm_smart table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_smart(const PersistentStore *p_ps, struct db_dimm_smart *p_dimm_smart);
/*!
 * Get the total number of dimm_smarts
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_smarts
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_smart_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_smarts
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_smart
 *		Pointer to an array of dimm_smart objects that will contain all the dimm_smarts
 * @param[in] dimm_smart_count
 *		Size of p_dimm_smart
 * @return The number of row (to max of dimm_smart_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_smarts(const PersistentStore *p_ps,
	struct db_dimm_smart
	*p_dimm_smart,
	int dimm_smart_count);
/*!
 * Truncate all the data in the dimm_smart table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_smarts(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_smart history
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_smart_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_smart state
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_smart to
 * @param[in] p_dimm_smart
 *		dimm_smart to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_smart_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_smart *p_dimm_smart);
/*!
 * Return a specific dimm_smart for a given device_handle
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_smart
 * @param[out] p_dimm_smart
 *		struct to put the dimm_smart retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_smart_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_smart *p_dimm_smart);
/*!
 * Update a specific dimm_smart given the original device_handle
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_smart to update
 * @param[in] *p_updated_dimm_smart
 *		structure with new values for the dimm_smart
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_smart_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_smart *p_updated_dimm_smart);
/*!
 * Delete a specific dimm_smart given the device_handle
 * @ingroup dimm_smart
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_smart_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_smart_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_smart_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_smart_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_smart_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_smart
 *		Structure type for row results
 * @param[in] p_dimm_smart
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_smart_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_smart_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_smart *p_dimm_smart,
	int history_id,
	int dimm_smart_count);
/*!
 * @defgroup dimm_state dimm_state 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_state table
 * @ingroup dimm_state
 */
struct db_dimm_state
{
	unsigned int device_handle;
	int spare_capacity_state;
	int wearlevel_state;
	unsigned long long mediaerrors_corrected;
	unsigned long long mediaerrors_uncorrectable;
	unsigned long long mediaerrors_erasurecoded;
	int health_state;
	unsigned int die_spares_used;
	int mediatemperature_state;
	int controllertemperature_state;
	int viral_state;
	unsigned long long newest_error_log_timestamp;
};
/*!
 * Helper function to print a db_dimm_state to the screen.
 * @ingroup dimm_state
 * @param p_dimm_state
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_state(struct db_dimm_state *p_value);
/*!
 * Create a new row in the dimm_state table
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_state
 *		Pointer to the object to be saved to the dimm_state table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_state(const PersistentStore *p_ps, struct db_dimm_state *p_dimm_state);
/*!
 * Get the total number of dimm_states
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_states
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_state_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_states
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_state
 *		Pointer to an array of dimm_state objects that will contain all the dimm_states
 * @param[in] dimm_state_count
 *		Size of p_dimm_state
 * @return The number of row (to max of dimm_state_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_states(const PersistentStore *p_ps,
	struct db_dimm_state
	*p_dimm_state,
	int dimm_state_count);
/*!
 * Truncate all the data in the dimm_state table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_states(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from dimm_state history
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_state_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save dimm_state state
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_state to
 * @param[in] p_dimm_state
 *		dimm_state to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_state_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_state *p_dimm_state);
/*!
 * Return a specific dimm_state for a given device_handle
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_state
 * @param[out] p_dimm_state
 *		struct to put the dimm_state retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_state_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_state *p_dimm_state);
/*!
 * Update a specific dimm_state given the original device_handle
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_state to update
 * @param[in] *p_updated_dimm_state
 *		structure with new values for the dimm_state
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_state_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_state *p_updated_dimm_state);
/*!
 * Delete a specific dimm_state given the device_handle
 * @ingroup dimm_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_state_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_state_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_state_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_state_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_state_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_state
 *		Structure type for row results
 * @param[in] p_dimm_state
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_state_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_state_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_state *p_dimm_state,
	int history_id,
	int dimm_state_count);
/*!
 * @defgroup namespace_state namespace_state 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	NAMESPACE_STATE_NAMESPACE_UID_LEN 37 //!< Max length for namespace_uid
/*!
 * struct representing the namespace_state table
 * @ingroup namespace_state
 */
struct db_namespace_state
{
	char   namespace_uid[NAMESPACE_STATE_NAMESPACE_UID_LEN];
	int health_state;
};
/*!
 * Helper function to print a db_namespace_state to the screen.
 * @ingroup namespace_state
 * @param p_namespace_state
 * 		value to print
 * @return
 *		void
 */
void db_print_namespace_state(struct db_namespace_state *p_value);
/*!
 * Create a new row in the namespace_state table
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_namespace_state
 *		Pointer to the object to be saved to the namespace_state table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_namespace_state(const PersistentStore *p_ps, struct db_namespace_state *p_namespace_state);
/*!
 * Get the total number of namespace_states
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of namespace_states
 * @return whether successful or not
 */
enum db_return_codes db_get_namespace_state_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all namespace_states
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_namespace_state
 *		Pointer to an array of namespace_state objects that will contain all the namespace_states
 * @param[in] namespace_state_count
 *		Size of p_namespace_state
 * @return The number of row (to max of namespace_state_count) on success.  DB_FAILURE on failure.
 */
int db_get_namespace_states(const PersistentStore *p_ps,
	struct db_namespace_state
	*p_namespace_state,
	int namespace_state_count);
/*!
 * Truncate all the data in the namespace_state table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_namespace_states(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from namespace_state history
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_namespace_state_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save namespace_state state
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the namespace_state to
 * @param[in] p_namespace_state
 *		namespace_state to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_namespace_state_state(const PersistentStore *p_ps,
	int history_id,
	struct db_namespace_state *p_namespace_state);
/*!
 * Return a specific namespace_state for a given namespace_uid
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] namespace_uid
 *		namespace_uid to identify the correct namespace_state
 * @param[out] p_namespace_state
 *		struct to put the namespace_state retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_namespace_state_by_namespace_uid(const PersistentStore *p_ps,
	const char * namespace_uid,
	struct db_namespace_state *p_namespace_state);
/*!
 * Update a specific namespace_state given the original namespace_uid
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] namespace_uid
 * 		namespace_uid points to the namespace_state to update
 * @param[in] *p_updated_namespace_state
 *		structure with new values for the namespace_state
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_namespace_state_by_namespace_uid(const PersistentStore *p_ps,
	const char * namespace_uid,
	struct db_namespace_state *p_updated_namespace_state);
/*!
 * Delete a specific namespace_state given the namespace_uid
 * @ingroup namespace_state
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] namespace_uid
 *		namespace_uid points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_namespace_state_by_namespace_uid(const PersistentStore *p_ps,
	const char * namespace_uid);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of namespace_state_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_namespace_state_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of namespace_state_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_namespace_state_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_namespace_state
 *		Structure type for row results
 * @param[in] p_namespace_state
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of namespace_state_count) on success.  DB_FAILURE on failure.
 */
 int db_get_namespace_state_history_by_history_id(const PersistentStore *p_ps,
	struct db_namespace_state *p_namespace_state,
	int history_id,
	int namespace_state_count);
/*!
 * @defgroup dimm_alarm_thresholds dimm_alarm_thresholds 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_alarm_thresholds table
 * @ingroup dimm_alarm_thresholds
 */
struct db_dimm_alarm_thresholds
{
	unsigned int device_handle;
	unsigned int enable;
	unsigned int media_temperature;
	unsigned int controller_temperature;
	unsigned int spare;
};
/*!
 * Helper function to print a db_dimm_alarm_thresholds to the screen.
 * @ingroup dimm_alarm_thresholds
 * @param p_dimm_alarm_thresholds
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_alarm_thresholds(struct db_dimm_alarm_thresholds *p_value);
/*!
 * Create a new row in the dimm_alarm_thresholds table
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_alarm_thresholds
 *		Pointer to the object to be saved to the dimm_alarm_thresholds table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_alarm_thresholds(const PersistentStore *p_ps, struct db_dimm_alarm_thresholds *p_dimm_alarm_thresholds);
/*!
 * Get the total number of dimm_alarm_thresholdss
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_alarm_thresholdss
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_alarm_thresholds_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_alarm_thresholdss
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_alarm_thresholds
 *		Pointer to an array of dimm_alarm_thresholds objects that will contain all the dimm_alarm_thresholdss
 * @param[in] dimm_alarm_thresholds_count
 *		Size of p_dimm_alarm_thresholds
 * @return The number of row (to max of dimm_alarm_thresholds_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_alarm_thresholdss(const PersistentStore *p_ps,
	struct db_dimm_alarm_thresholds
	*p_dimm_alarm_thresholds,
	int dimm_alarm_thresholds_count);
/*!
 * Truncate all the data in the dimm_alarm_thresholds table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_alarm_thresholdss(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_alarm_thresholds history
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_alarm_thresholds_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_alarm_thresholds state
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_alarm_thresholds to
 * @param[in] p_dimm_alarm_thresholds
 *		dimm_alarm_thresholds to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_alarm_thresholds_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_alarm_thresholds *p_dimm_alarm_thresholds);
/*!
 * Return a specific dimm_alarm_thresholds for a given device_handle
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_alarm_thresholds
 * @param[out] p_dimm_alarm_thresholds
 *		struct to put the dimm_alarm_thresholds retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_alarm_thresholds_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_alarm_thresholds *p_dimm_alarm_thresholds);
/*!
 * Update a specific dimm_alarm_thresholds given the original device_handle
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_alarm_thresholds to update
 * @param[in] *p_updated_dimm_alarm_thresholds
 *		structure with new values for the dimm_alarm_thresholds
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_alarm_thresholds_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_alarm_thresholds *p_updated_dimm_alarm_thresholds);
/*!
 * Delete a specific dimm_alarm_thresholds given the device_handle
 * @ingroup dimm_alarm_thresholds
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_alarm_thresholds_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_alarm_thresholds_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_alarm_thresholds_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_alarm_thresholds_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_alarm_thresholds_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_alarm_thresholds
 *		Structure type for row results
 * @param[in] p_dimm_alarm_thresholds
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_alarm_thresholds_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_alarm_thresholds_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_alarm_thresholds *p_dimm_alarm_thresholds,
	int history_id,
	int dimm_alarm_thresholds_count);
/*!
 * @defgroup dimm_power_management dimm_power_management 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_power_management table
 * @ingroup dimm_power_management
 */
struct db_dimm_power_management
{
	unsigned int device_handle;
	unsigned int enable;
	unsigned int tdp_power_limit;
	unsigned int peak_power_budget;
	unsigned int avg_power_budget;
};
/*!
 * Helper function to print a db_dimm_power_management to the screen.
 * @ingroup dimm_power_management
 * @param p_dimm_power_management
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_power_management(struct db_dimm_power_management *p_value);
/*!
 * Create a new row in the dimm_power_management table
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_power_management
 *		Pointer to the object to be saved to the dimm_power_management table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_power_management(const PersistentStore *p_ps, struct db_dimm_power_management *p_dimm_power_management);
/*!
 * Get the total number of dimm_power_managements
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_power_managements
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_power_management_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_power_managements
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_power_management
 *		Pointer to an array of dimm_power_management objects that will contain all the dimm_power_managements
 * @param[in] dimm_power_management_count
 *		Size of p_dimm_power_management
 * @return The number of row (to max of dimm_power_management_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_power_managements(const PersistentStore *p_ps,
	struct db_dimm_power_management
	*p_dimm_power_management,
	int dimm_power_management_count);
/*!
 * Truncate all the data in the dimm_power_management table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_power_managements(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_power_management history
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_power_management_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_power_management state
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_power_management to
 * @param[in] p_dimm_power_management
 *		dimm_power_management to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_power_management_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_power_management *p_dimm_power_management);
/*!
 * Return a specific dimm_power_management for a given device_handle
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_power_management
 * @param[out] p_dimm_power_management
 *		struct to put the dimm_power_management retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_power_management_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_power_management *p_dimm_power_management);
/*!
 * Update a specific dimm_power_management given the original device_handle
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_power_management to update
 * @param[in] *p_updated_dimm_power_management
 *		structure with new values for the dimm_power_management
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_power_management_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_power_management *p_updated_dimm_power_management);
/*!
 * Delete a specific dimm_power_management given the device_handle
 * @ingroup dimm_power_management
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_power_management_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_power_management_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_power_management_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_power_management_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_power_management_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_power_management
 *		Structure type for row results
 * @param[in] p_dimm_power_management
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_power_management_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_power_management_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_power_management *p_dimm_power_management,
	int history_id,
	int dimm_power_management_count);
/*!
 * @defgroup dimm_die_sparing dimm_die_sparing 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_DIE_SPARING_SUPPORTED_BY_RANK_COUNT 4 //!< Max length for supported_by_rank
/*!
 * struct representing the dimm_die_sparing table
 * @ingroup dimm_die_sparing
 */
struct db_dimm_die_sparing
{
	unsigned int device_handle;
	unsigned int enable;
	unsigned int aggressiveness;
	unsigned int supported_by_rank[DIMM_DIE_SPARING_SUPPORTED_BY_RANK_COUNT];
};
/*!
 * Helper function to print a db_dimm_die_sparing to the screen.
 * @ingroup dimm_die_sparing
 * @param p_dimm_die_sparing
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_die_sparing(struct db_dimm_die_sparing *p_value);
/*!
 * Create a new row in the dimm_die_sparing table
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_die_sparing
 *		Pointer to the object to be saved to the dimm_die_sparing table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_die_sparing(const PersistentStore *p_ps, struct db_dimm_die_sparing *p_dimm_die_sparing);
/*!
 * Get the total number of dimm_die_sparings
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_die_sparings
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_die_sparing_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_die_sparings
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_die_sparing
 *		Pointer to an array of dimm_die_sparing objects that will contain all the dimm_die_sparings
 * @param[in] dimm_die_sparing_count
 *		Size of p_dimm_die_sparing
 * @return The number of row (to max of dimm_die_sparing_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_die_sparings(const PersistentStore *p_ps,
	struct db_dimm_die_sparing
	*p_dimm_die_sparing,
	int dimm_die_sparing_count);
/*!
 * Truncate all the data in the dimm_die_sparing table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_die_sparings(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_die_sparing history
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_die_sparing_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_die_sparing state
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_die_sparing to
 * @param[in] p_dimm_die_sparing
 *		dimm_die_sparing to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_die_sparing_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_die_sparing *p_dimm_die_sparing);
/*!
 * Return a specific dimm_die_sparing for a given device_handle
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_die_sparing
 * @param[out] p_dimm_die_sparing
 *		struct to put the dimm_die_sparing retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_die_sparing_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_die_sparing *p_dimm_die_sparing);
/*!
 * Update a specific dimm_die_sparing given the original device_handle
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_die_sparing to update
 * @param[in] *p_updated_dimm_die_sparing
 *		structure with new values for the dimm_die_sparing
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_die_sparing_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_die_sparing *p_updated_dimm_die_sparing);
/*!
 * Delete a specific dimm_die_sparing given the device_handle
 * @ingroup dimm_die_sparing
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_die_sparing_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_die_sparing_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_die_sparing_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_die_sparing_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_die_sparing_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_die_sparing
 *		Structure type for row results
 * @param[in] p_dimm_die_sparing
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_die_sparing_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_die_sparing_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_die_sparing *p_dimm_die_sparing,
	int history_id,
	int dimm_die_sparing_count);
/*!
 * @defgroup dimm_optional_config_data dimm_optional_config_data 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_optional_config_data table
 * @ingroup dimm_optional_config_data
 */
struct db_dimm_optional_config_data
{
	unsigned int device_handle;
	unsigned int first_fast_refresh_enable;
	unsigned int viral_policy_enable;
	unsigned int viral_status;
};
/*!
 * Helper function to print a db_dimm_optional_config_data to the screen.
 * @ingroup dimm_optional_config_data
 * @param p_dimm_optional_config_data
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_optional_config_data(struct db_dimm_optional_config_data *p_value);
/*!
 * Create a new row in the dimm_optional_config_data table
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_optional_config_data
 *		Pointer to the object to be saved to the dimm_optional_config_data table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_optional_config_data(const PersistentStore *p_ps, struct db_dimm_optional_config_data *p_dimm_optional_config_data);
/*!
 * Get the total number of dimm_optional_config_datas
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_optional_config_datas
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_optional_config_data_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_optional_config_datas
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_optional_config_data
 *		Pointer to an array of dimm_optional_config_data objects that will contain all the dimm_optional_config_datas
 * @param[in] dimm_optional_config_data_count
 *		Size of p_dimm_optional_config_data
 * @return The number of row (to max of dimm_optional_config_data_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_optional_config_datas(const PersistentStore *p_ps,
	struct db_dimm_optional_config_data
	*p_dimm_optional_config_data,
	int dimm_optional_config_data_count);
/*!
 * Truncate all the data in the dimm_optional_config_data table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_optional_config_datas(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_optional_config_data history
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_optional_config_data_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_optional_config_data state
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_optional_config_data to
 * @param[in] p_dimm_optional_config_data
 *		dimm_optional_config_data to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_optional_config_data_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_optional_config_data *p_dimm_optional_config_data);
/*!
 * Return a specific dimm_optional_config_data for a given device_handle
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_optional_config_data
 * @param[out] p_dimm_optional_config_data
 *		struct to put the dimm_optional_config_data retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_optional_config_data_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_optional_config_data *p_dimm_optional_config_data);
/*!
 * Update a specific dimm_optional_config_data given the original device_handle
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_optional_config_data to update
 * @param[in] *p_updated_dimm_optional_config_data
 *		structure with new values for the dimm_optional_config_data
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_optional_config_data_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_optional_config_data *p_updated_dimm_optional_config_data);
/*!
 * Delete a specific dimm_optional_config_data given the device_handle
 * @ingroup dimm_optional_config_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_optional_config_data_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_optional_config_data_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_optional_config_data_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_optional_config_data_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_optional_config_data_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_optional_config_data
 *		Structure type for row results
 * @param[in] p_dimm_optional_config_data
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_optional_config_data_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_optional_config_data_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_optional_config_data *p_dimm_optional_config_data,
	int history_id,
	int dimm_optional_config_data_count);
/*!
 * @defgroup dimm_err_correction dimm_err_correction 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_err_correction table
 * @ingroup dimm_err_correction
 */
struct db_dimm_err_correction
{
	unsigned int device_handle;
	unsigned int unrefreshed_enable;
	unsigned int refreshed_enable;
	unsigned int unrefreshed_force_write;
	unsigned int refreshed_force_write;
};
/*!
 * Helper function to print a db_dimm_err_correction to the screen.
 * @ingroup dimm_err_correction
 * @param p_dimm_err_correction
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_err_correction(struct db_dimm_err_correction *p_value);
/*!
 * Create a new row in the dimm_err_correction table
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_err_correction
 *		Pointer to the object to be saved to the dimm_err_correction table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_err_correction(const PersistentStore *p_ps, struct db_dimm_err_correction *p_dimm_err_correction);
/*!
 * Get the total number of dimm_err_corrections
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_err_corrections
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_err_correction_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_err_corrections
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_err_correction
 *		Pointer to an array of dimm_err_correction objects that will contain all the dimm_err_corrections
 * @param[in] dimm_err_correction_count
 *		Size of p_dimm_err_correction
 * @return The number of row (to max of dimm_err_correction_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_err_corrections(const PersistentStore *p_ps,
	struct db_dimm_err_correction
	*p_dimm_err_correction,
	int dimm_err_correction_count);
/*!
 * Truncate all the data in the dimm_err_correction table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_err_corrections(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_err_correction history
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_err_correction_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_err_correction state
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_err_correction to
 * @param[in] p_dimm_err_correction
 *		dimm_err_correction to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_err_correction_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_err_correction *p_dimm_err_correction);
/*!
 * Return a specific dimm_err_correction for a given device_handle
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_err_correction
 * @param[out] p_dimm_err_correction
 *		struct to put the dimm_err_correction retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_err_correction_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_err_correction *p_dimm_err_correction);
/*!
 * Update a specific dimm_err_correction given the original device_handle
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_err_correction to update
 * @param[in] *p_updated_dimm_err_correction
 *		structure with new values for the dimm_err_correction
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_err_correction_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_err_correction *p_updated_dimm_err_correction);
/*!
 * Delete a specific dimm_err_correction given the device_handle
 * @ingroup dimm_err_correction
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_err_correction_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_err_correction_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_err_correction_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_err_correction_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_err_correction_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_err_correction
 *		Structure type for row results
 * @param[in] p_dimm_err_correction
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_err_correction_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_err_correction_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_err_correction *p_dimm_err_correction,
	int history_id,
	int dimm_err_correction_count);
/*!
 * @defgroup dimm_erasure_coding dimm_erasure_coding 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_erasure_coding table
 * @ingroup dimm_erasure_coding
 */
struct db_dimm_erasure_coding
{
	unsigned int device_handle;
	unsigned int verify_erc;
	unsigned int unrefreshed_enable;
	unsigned int refreshed_enable;
	unsigned int unrefreshed_force_write;
	unsigned int refreshed_force_write;
};
/*!
 * Helper function to print a db_dimm_erasure_coding to the screen.
 * @ingroup dimm_erasure_coding
 * @param p_dimm_erasure_coding
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_erasure_coding(struct db_dimm_erasure_coding *p_value);
/*!
 * Create a new row in the dimm_erasure_coding table
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_erasure_coding
 *		Pointer to the object to be saved to the dimm_erasure_coding table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_erasure_coding(const PersistentStore *p_ps, struct db_dimm_erasure_coding *p_dimm_erasure_coding);
/*!
 * Get the total number of dimm_erasure_codings
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_erasure_codings
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_erasure_coding_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_erasure_codings
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_erasure_coding
 *		Pointer to an array of dimm_erasure_coding objects that will contain all the dimm_erasure_codings
 * @param[in] dimm_erasure_coding_count
 *		Size of p_dimm_erasure_coding
 * @return The number of row (to max of dimm_erasure_coding_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_erasure_codings(const PersistentStore *p_ps,
	struct db_dimm_erasure_coding
	*p_dimm_erasure_coding,
	int dimm_erasure_coding_count);
/*!
 * Truncate all the data in the dimm_erasure_coding table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_erasure_codings(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_erasure_coding history
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_erasure_coding_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_erasure_coding state
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_erasure_coding to
 * @param[in] p_dimm_erasure_coding
 *		dimm_erasure_coding to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_erasure_coding_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_erasure_coding *p_dimm_erasure_coding);
/*!
 * Return a specific dimm_erasure_coding for a given device_handle
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_erasure_coding
 * @param[out] p_dimm_erasure_coding
 *		struct to put the dimm_erasure_coding retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_erasure_coding_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_erasure_coding *p_dimm_erasure_coding);
/*!
 * Update a specific dimm_erasure_coding given the original device_handle
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_erasure_coding to update
 * @param[in] *p_updated_dimm_erasure_coding
 *		structure with new values for the dimm_erasure_coding
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_erasure_coding_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_erasure_coding *p_updated_dimm_erasure_coding);
/*!
 * Delete a specific dimm_erasure_coding given the device_handle
 * @ingroup dimm_erasure_coding
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_erasure_coding_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_erasure_coding_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_erasure_coding_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_erasure_coding_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_erasure_coding_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_erasure_coding
 *		Structure type for row results
 * @param[in] p_dimm_erasure_coding
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_erasure_coding_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_erasure_coding_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_erasure_coding *p_dimm_erasure_coding,
	int history_id,
	int dimm_erasure_coding_count);
/*!
 * @defgroup dimm_thermal dimm_thermal 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_thermal table
 * @ingroup dimm_thermal
 */
struct db_dimm_thermal
{
	unsigned int device_handle;
	unsigned int throttling_enable;
	unsigned int alerting_enable;
	unsigned int critical_shutdown_enable;
};
/*!
 * Helper function to print a db_dimm_thermal to the screen.
 * @ingroup dimm_thermal
 * @param p_dimm_thermal
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_thermal(struct db_dimm_thermal *p_value);
/*!
 * Create a new row in the dimm_thermal table
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_thermal
 *		Pointer to the object to be saved to the dimm_thermal table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_thermal(const PersistentStore *p_ps, struct db_dimm_thermal *p_dimm_thermal);
/*!
 * Get the total number of dimm_thermals
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_thermals
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_thermal_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_thermals
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_thermal
 *		Pointer to an array of dimm_thermal objects that will contain all the dimm_thermals
 * @param[in] dimm_thermal_count
 *		Size of p_dimm_thermal
 * @return The number of row (to max of dimm_thermal_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_thermals(const PersistentStore *p_ps,
	struct db_dimm_thermal
	*p_dimm_thermal,
	int dimm_thermal_count);
/*!
 * Truncate all the data in the dimm_thermal table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_thermals(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_thermal history
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_thermal_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_thermal state
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_thermal to
 * @param[in] p_dimm_thermal
 *		dimm_thermal to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_thermal_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_thermal *p_dimm_thermal);
/*!
 * Return a specific dimm_thermal for a given device_handle
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_thermal
 * @param[out] p_dimm_thermal
 *		struct to put the dimm_thermal retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_thermal_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_thermal *p_dimm_thermal);
/*!
 * Update a specific dimm_thermal given the original device_handle
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_thermal to update
 * @param[in] *p_updated_dimm_thermal
 *		structure with new values for the dimm_thermal
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_thermal_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_thermal *p_updated_dimm_thermal);
/*!
 * Delete a specific dimm_thermal given the device_handle
 * @ingroup dimm_thermal
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_thermal_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_thermal_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_thermal_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_thermal_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_thermal_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_thermal
 *		Structure type for row results
 * @param[in] p_dimm_thermal
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_thermal_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_thermal_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_thermal *p_dimm_thermal,
	int history_id,
	int dimm_thermal_count);
/*!
 * @defgroup dimm_fw_image dimm_fw_image 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_FW_IMAGE_FW_REV_LEN 14 //!< Max length for fw_rev
#define	DIMM_FW_IMAGE_STAGED_FW_REV_LEN 14 //!< Max length for staged_fw_rev
#define	DIMM_FW_IMAGE_COMMIT_ID_LEN 41 //!< Max length for commit_id
#define	DIMM_FW_IMAGE_BUILD_CONFIGURATION_LEN 17 //!< Max length for build_configuration
/*!
 * struct representing the dimm_fw_image table
 * @ingroup dimm_fw_image
 */
struct db_dimm_fw_image
{
	unsigned int device_handle;
	char   fw_rev[DIMM_FW_IMAGE_FW_REV_LEN];
	unsigned int fw_type;
	unsigned int staged_fw_status;
	char   staged_fw_rev[DIMM_FW_IMAGE_STAGED_FW_REV_LEN];
	unsigned int staged_fw_type;
	char   commit_id[DIMM_FW_IMAGE_COMMIT_ID_LEN];
	char   build_configuration[DIMM_FW_IMAGE_BUILD_CONFIGURATION_LEN];
};
/*!
 * Helper function to print a db_dimm_fw_image to the screen.
 * @ingroup dimm_fw_image
 * @param p_dimm_fw_image
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_fw_image(struct db_dimm_fw_image *p_value);
/*!
 * Create a new row in the dimm_fw_image table
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_fw_image
 *		Pointer to the object to be saved to the dimm_fw_image table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_fw_image(const PersistentStore *p_ps, struct db_dimm_fw_image *p_dimm_fw_image);
/*!
 * Get the total number of dimm_fw_images
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_fw_images
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_fw_image_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_fw_images
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_fw_image
 *		Pointer to an array of dimm_fw_image objects that will contain all the dimm_fw_images
 * @param[in] dimm_fw_image_count
 *		Size of p_dimm_fw_image
 * @return The number of row (to max of dimm_fw_image_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_fw_images(const PersistentStore *p_ps,
	struct db_dimm_fw_image
	*p_dimm_fw_image,
	int dimm_fw_image_count);
/*!
 * Truncate all the data in the dimm_fw_image table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_fw_images(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_fw_image history
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_fw_image_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_fw_image state
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_fw_image to
 * @param[in] p_dimm_fw_image
 *		dimm_fw_image to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_fw_image_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_fw_image *p_dimm_fw_image);
/*!
 * Return a specific dimm_fw_image for a given device_handle
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_fw_image
 * @param[out] p_dimm_fw_image
 *		struct to put the dimm_fw_image retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_fw_image_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_fw_image *p_dimm_fw_image);
/*!
 * Update a specific dimm_fw_image given the original device_handle
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_fw_image to update
 * @param[in] *p_updated_dimm_fw_image
 *		structure with new values for the dimm_fw_image
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_fw_image_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_fw_image *p_updated_dimm_fw_image);
/*!
 * Delete a specific dimm_fw_image given the device_handle
 * @ingroup dimm_fw_image
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_fw_image_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_image_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_image_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_image_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_image_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_fw_image
 *		Structure type for row results
 * @param[in] p_dimm_fw_image
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_fw_image_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_fw_image_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_fw_image *p_dimm_fw_image,
	int history_id,
	int dimm_fw_image_count);
/*!
 * @defgroup dimm_fw_debug_log dimm_fw_debug_log 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_FW_DEBUG_LOG_FW_LOG_LEN 1024 //!< Max length for fw_log
/*!
 * struct representing the dimm_fw_debug_log table
 * @ingroup dimm_fw_debug_log
 */
struct db_dimm_fw_debug_log
{
	unsigned int device_handle;
	unsigned char   fw_log[DIMM_FW_DEBUG_LOG_FW_LOG_LEN];
};
/*!
 * Helper function to print a db_dimm_fw_debug_log to the screen.
 * @ingroup dimm_fw_debug_log
 * @param p_dimm_fw_debug_log
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_fw_debug_log(struct db_dimm_fw_debug_log *p_value);
/*!
 * Create a new row in the dimm_fw_debug_log table
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_fw_debug_log
 *		Pointer to the object to be saved to the dimm_fw_debug_log table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_fw_debug_log(const PersistentStore *p_ps, struct db_dimm_fw_debug_log *p_dimm_fw_debug_log);
/*!
 * Get the total number of dimm_fw_debug_logs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_fw_debug_logs
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_fw_debug_log_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_fw_debug_logs
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_fw_debug_log
 *		Pointer to an array of dimm_fw_debug_log objects that will contain all the dimm_fw_debug_logs
 * @param[in] dimm_fw_debug_log_count
 *		Size of p_dimm_fw_debug_log
 * @return The number of row (to max of dimm_fw_debug_log_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_fw_debug_logs(const PersistentStore *p_ps,
	struct db_dimm_fw_debug_log
	*p_dimm_fw_debug_log,
	int dimm_fw_debug_log_count);
/*!
 * Truncate all the data in the dimm_fw_debug_log table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_fw_debug_logs(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_fw_debug_log history
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_fw_debug_log_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_fw_debug_log state
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_fw_debug_log to
 * @param[in] p_dimm_fw_debug_log
 *		dimm_fw_debug_log to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_fw_debug_log_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_fw_debug_log *p_dimm_fw_debug_log);
/*!
 * Return a specific dimm_fw_debug_log for a given fw_log
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] fw_log
 *		fw_log to identify the correct dimm_fw_debug_log
 * @param[out] p_dimm_fw_debug_log
 *		struct to put the dimm_fw_debug_log retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_fw_debug_log_by_fw_log(const PersistentStore *p_ps,
	const unsigned char * fw_log,
	struct db_dimm_fw_debug_log *p_dimm_fw_debug_log);
/*!
 * Update a specific dimm_fw_debug_log given the original fw_log
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] fw_log
 * 		fw_log points to the dimm_fw_debug_log to update
 * @param[in] *p_updated_dimm_fw_debug_log
 *		structure with new values for the dimm_fw_debug_log
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_fw_debug_log_by_fw_log(const PersistentStore *p_ps,
	const unsigned char * fw_log,
	struct db_dimm_fw_debug_log *p_updated_dimm_fw_debug_log);
/*!
 * Delete a specific dimm_fw_debug_log given the fw_log
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] fw_log
 *		fw_log points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_fw_debug_log_by_fw_log(const PersistentStore *p_ps,
	const unsigned char * fw_log);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_debug_log_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_debug_log_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_debug_log_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_debug_log_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_fw_debug_log
 *		Structure type for row results
 * @param[in] p_dimm_fw_debug_log
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_fw_debug_log_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_fw_debug_log_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_fw_debug_log *p_dimm_fw_debug_log,
	int history_id,
	int dimm_fw_debug_log_count);
/*!
 * Return the number of dimm_fw_debug_logs for a given dimm_topology.device_handle
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_fw_debug_log and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_fw_debug_log_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of dimm_fw_debug_logs for a given dimm_topology.device_handle
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_fw_debug_log and get all with passed in device_handle
 * @param[out] p_dimm_fw_debug_log
 *		memory to hold the found dimm_fw_debug_logs
 * @param[in]   dimm_fw_debug_log_count
 *		Size of dimm_fw_debug_log array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_fw_debug_logs_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_dimm_fw_debug_log *p_dimm_fw_debug_log,
	int dimm_fw_debug_log_count);
/*!
 * Delete a list of specific dimm_fw_debug_logs for a given dimm_topology.device_handle
 * @ingroup dimm_fw_debug_log
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_fw_debug_log and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_fw_debug_log_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup dimm_memory_info_page0 dimm_memory_info_page0 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_memory_info_page0 table
 * @ingroup dimm_memory_info_page0
 */
struct db_dimm_memory_info_page0
{
	unsigned int device_handle;
	unsigned long long bytes_read;
	unsigned long long bytes_written;
	unsigned long long read_reqs;
	unsigned long long write_reqs;
	unsigned long long block_read_reqs;
	unsigned long long block_write_reqs;
};
/*!
 * Helper function to print a db_dimm_memory_info_page0 to the screen.
 * @ingroup dimm_memory_info_page0
 * @param p_dimm_memory_info_page0
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_memory_info_page0(struct db_dimm_memory_info_page0 *p_value);
/*!
 * Create a new row in the dimm_memory_info_page0 table
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_memory_info_page0
 *		Pointer to the object to be saved to the dimm_memory_info_page0 table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_memory_info_page0(const PersistentStore *p_ps, struct db_dimm_memory_info_page0 *p_dimm_memory_info_page0);
/*!
 * Get the total number of dimm_memory_info_page0s
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_memory_info_page0s
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_memory_info_page0_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_memory_info_page0s
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_memory_info_page0
 *		Pointer to an array of dimm_memory_info_page0 objects that will contain all the dimm_memory_info_page0s
 * @param[in] dimm_memory_info_page0_count
 *		Size of p_dimm_memory_info_page0
 * @return The number of row (to max of dimm_memory_info_page0_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_memory_info_page0s(const PersistentStore *p_ps,
	struct db_dimm_memory_info_page0
	*p_dimm_memory_info_page0,
	int dimm_memory_info_page0_count);
/*!
 * Truncate all the data in the dimm_memory_info_page0 table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_memory_info_page0s(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_memory_info_page0 history
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_memory_info_page0_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_memory_info_page0 state
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_memory_info_page0 to
 * @param[in] p_dimm_memory_info_page0
 *		dimm_memory_info_page0 to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_memory_info_page0_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_memory_info_page0 *p_dimm_memory_info_page0);
/*!
 * Return a specific dimm_memory_info_page0 for a given device_handle
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_memory_info_page0
 * @param[out] p_dimm_memory_info_page0
 *		struct to put the dimm_memory_info_page0 retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_memory_info_page0_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_memory_info_page0 *p_dimm_memory_info_page0);
/*!
 * Update a specific dimm_memory_info_page0 given the original device_handle
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_memory_info_page0 to update
 * @param[in] *p_updated_dimm_memory_info_page0
 *		structure with new values for the dimm_memory_info_page0
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_memory_info_page0_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_memory_info_page0 *p_updated_dimm_memory_info_page0);
/*!
 * Delete a specific dimm_memory_info_page0 given the device_handle
 * @ingroup dimm_memory_info_page0
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_memory_info_page0_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_memory_info_page0_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_memory_info_page0_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_memory_info_page0_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_memory_info_page0_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_memory_info_page0
 *		Structure type for row results
 * @param[in] p_dimm_memory_info_page0
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_memory_info_page0_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_memory_info_page0_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_memory_info_page0 *p_dimm_memory_info_page0,
	int history_id,
	int dimm_memory_info_page0_count);
/*!
 * @defgroup dimm_memory_info_page1 dimm_memory_info_page1 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_memory_info_page1 table
 * @ingroup dimm_memory_info_page1
 */
struct db_dimm_memory_info_page1
{
	unsigned int device_handle;
	unsigned long long total_bytes_read;
	unsigned long long total_bytes_written;
	unsigned long long total_read_reqs;
	unsigned long long total_write_reqs;
	unsigned long long total_block_read_reqs;
	unsigned long long total_block_write_reqs;
};
/*!
 * Helper function to print a db_dimm_memory_info_page1 to the screen.
 * @ingroup dimm_memory_info_page1
 * @param p_dimm_memory_info_page1
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_memory_info_page1(struct db_dimm_memory_info_page1 *p_value);
/*!
 * Create a new row in the dimm_memory_info_page1 table
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_memory_info_page1
 *		Pointer to the object to be saved to the dimm_memory_info_page1 table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_memory_info_page1(const PersistentStore *p_ps, struct db_dimm_memory_info_page1 *p_dimm_memory_info_page1);
/*!
 * Get the total number of dimm_memory_info_page1s
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_memory_info_page1s
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_memory_info_page1_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_memory_info_page1s
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_memory_info_page1
 *		Pointer to an array of dimm_memory_info_page1 objects that will contain all the dimm_memory_info_page1s
 * @param[in] dimm_memory_info_page1_count
 *		Size of p_dimm_memory_info_page1
 * @return The number of row (to max of dimm_memory_info_page1_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_memory_info_page1s(const PersistentStore *p_ps,
	struct db_dimm_memory_info_page1
	*p_dimm_memory_info_page1,
	int dimm_memory_info_page1_count);
/*!
 * Truncate all the data in the dimm_memory_info_page1 table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_memory_info_page1s(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_memory_info_page1 history
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_memory_info_page1_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_memory_info_page1 state
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_memory_info_page1 to
 * @param[in] p_dimm_memory_info_page1
 *		dimm_memory_info_page1 to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_memory_info_page1_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_memory_info_page1 *p_dimm_memory_info_page1);
/*!
 * Return a specific dimm_memory_info_page1 for a given device_handle
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_memory_info_page1
 * @param[out] p_dimm_memory_info_page1
 *		struct to put the dimm_memory_info_page1 retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_memory_info_page1_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_memory_info_page1 *p_dimm_memory_info_page1);
/*!
 * Update a specific dimm_memory_info_page1 given the original device_handle
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_memory_info_page1 to update
 * @param[in] *p_updated_dimm_memory_info_page1
 *		structure with new values for the dimm_memory_info_page1
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_memory_info_page1_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_memory_info_page1 *p_updated_dimm_memory_info_page1);
/*!
 * Delete a specific dimm_memory_info_page1 given the device_handle
 * @ingroup dimm_memory_info_page1
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_memory_info_page1_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_memory_info_page1_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_memory_info_page1_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_memory_info_page1_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_memory_info_page1_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_memory_info_page1
 *		Structure type for row results
 * @param[in] p_dimm_memory_info_page1
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_memory_info_page1_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_memory_info_page1_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_memory_info_page1 *p_dimm_memory_info_page1,
	int history_id,
	int dimm_memory_info_page1_count);
/*!
 * @defgroup dimm_memory_info_page2 dimm_memory_info_page2 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_memory_info_page2 table
 * @ingroup dimm_memory_info_page2
 */
struct db_dimm_memory_info_page2
{
	unsigned int device_handle;
	unsigned long long write_count_max;
	unsigned long long write_count_average;
	unsigned int uncorrectable_host;
	unsigned int uncorrectable_non_host;
	unsigned int media_errors_uc;
	unsigned long long media_errors_ce;
	unsigned long long media_errors_ecc;
};
/*!
 * Helper function to print a db_dimm_memory_info_page2 to the screen.
 * @ingroup dimm_memory_info_page2
 * @param p_dimm_memory_info_page2
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_memory_info_page2(struct db_dimm_memory_info_page2 *p_value);
/*!
 * Create a new row in the dimm_memory_info_page2 table
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_memory_info_page2
 *		Pointer to the object to be saved to the dimm_memory_info_page2 table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_memory_info_page2(const PersistentStore *p_ps, struct db_dimm_memory_info_page2 *p_dimm_memory_info_page2);
/*!
 * Get the total number of dimm_memory_info_page2s
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_memory_info_page2s
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_memory_info_page2_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_memory_info_page2s
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_memory_info_page2
 *		Pointer to an array of dimm_memory_info_page2 objects that will contain all the dimm_memory_info_page2s
 * @param[in] dimm_memory_info_page2_count
 *		Size of p_dimm_memory_info_page2
 * @return The number of row (to max of dimm_memory_info_page2_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_memory_info_page2s(const PersistentStore *p_ps,
	struct db_dimm_memory_info_page2
	*p_dimm_memory_info_page2,
	int dimm_memory_info_page2_count);
/*!
 * Truncate all the data in the dimm_memory_info_page2 table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_memory_info_page2s(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_memory_info_page2 history
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_memory_info_page2_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_memory_info_page2 state
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_memory_info_page2 to
 * @param[in] p_dimm_memory_info_page2
 *		dimm_memory_info_page2 to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_memory_info_page2_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_memory_info_page2 *p_dimm_memory_info_page2);
/*!
 * Return a specific dimm_memory_info_page2 for a given device_handle
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_memory_info_page2
 * @param[out] p_dimm_memory_info_page2
 *		struct to put the dimm_memory_info_page2 retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_memory_info_page2_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_memory_info_page2 *p_dimm_memory_info_page2);
/*!
 * Update a specific dimm_memory_info_page2 given the original device_handle
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_memory_info_page2 to update
 * @param[in] *p_updated_dimm_memory_info_page2
 *		structure with new values for the dimm_memory_info_page2
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_memory_info_page2_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_memory_info_page2 *p_updated_dimm_memory_info_page2);
/*!
 * Delete a specific dimm_memory_info_page2 given the device_handle
 * @ingroup dimm_memory_info_page2
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_memory_info_page2_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_memory_info_page2_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_memory_info_page2_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_memory_info_page2_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_memory_info_page2_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_memory_info_page2
 *		Structure type for row results
 * @param[in] p_dimm_memory_info_page2
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_memory_info_page2_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_memory_info_page2_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_memory_info_page2 *p_dimm_memory_info_page2,
	int history_id,
	int dimm_memory_info_page2_count);
/*!
 * @defgroup dimm_ars_command_specific_data dimm_ars_command_specific_data 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_ARS_COMMAND_SPECIFIC_DATA_DPA_ERROR_ADDRESS_COUNT 14 //!< Max length for dpa_error_address
/*!
 * struct representing the dimm_ars_command_specific_data table
 * @ingroup dimm_ars_command_specific_data
 */
struct db_dimm_ars_command_specific_data
{
	unsigned int device_handle;
	long long num_errors;
	long long ars_state;
	unsigned long long dpa_error_address[DIMM_ARS_COMMAND_SPECIFIC_DATA_DPA_ERROR_ADDRESS_COUNT];
};
/*!
 * Helper function to print a db_dimm_ars_command_specific_data to the screen.
 * @ingroup dimm_ars_command_specific_data
 * @param p_dimm_ars_command_specific_data
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_ars_command_specific_data(struct db_dimm_ars_command_specific_data *p_value);
/*!
 * Create a new row in the dimm_ars_command_specific_data table
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_ars_command_specific_data
 *		Pointer to the object to be saved to the dimm_ars_command_specific_data table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_ars_command_specific_data(const PersistentStore *p_ps, struct db_dimm_ars_command_specific_data *p_dimm_ars_command_specific_data);
/*!
 * Get the total number of dimm_ars_command_specific_datas
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_ars_command_specific_datas
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_ars_command_specific_data_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_ars_command_specific_datas
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_ars_command_specific_data
 *		Pointer to an array of dimm_ars_command_specific_data objects that will contain all the dimm_ars_command_specific_datas
 * @param[in] dimm_ars_command_specific_data_count
 *		Size of p_dimm_ars_command_specific_data
 * @return The number of row (to max of dimm_ars_command_specific_data_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_ars_command_specific_datas(const PersistentStore *p_ps,
	struct db_dimm_ars_command_specific_data
	*p_dimm_ars_command_specific_data,
	int dimm_ars_command_specific_data_count);
/*!
 * Truncate all the data in the dimm_ars_command_specific_data table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_ars_command_specific_datas(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_ars_command_specific_data history
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_ars_command_specific_data_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_ars_command_specific_data state
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_ars_command_specific_data to
 * @param[in] p_dimm_ars_command_specific_data
 *		dimm_ars_command_specific_data to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_ars_command_specific_data_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_ars_command_specific_data *p_dimm_ars_command_specific_data);
/*!
 * Return a specific dimm_ars_command_specific_data for a given device_handle
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_ars_command_specific_data
 * @param[out] p_dimm_ars_command_specific_data
 *		struct to put the dimm_ars_command_specific_data retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_ars_command_specific_data_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_ars_command_specific_data *p_dimm_ars_command_specific_data);
/*!
 * Update a specific dimm_ars_command_specific_data given the original device_handle
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_ars_command_specific_data to update
 * @param[in] *p_updated_dimm_ars_command_specific_data
 *		structure with new values for the dimm_ars_command_specific_data
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_ars_command_specific_data_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_ars_command_specific_data *p_updated_dimm_ars_command_specific_data);
/*!
 * Delete a specific dimm_ars_command_specific_data given the device_handle
 * @ingroup dimm_ars_command_specific_data
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_ars_command_specific_data_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_ars_command_specific_data_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_ars_command_specific_data_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_ars_command_specific_data_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_ars_command_specific_data_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_ars_command_specific_data
 *		Structure type for row results
 * @param[in] p_dimm_ars_command_specific_data
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_ars_command_specific_data_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_ars_command_specific_data_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_ars_command_specific_data *p_dimm_ars_command_specific_data,
	int history_id,
	int dimm_ars_command_specific_data_count);
/*!
 * @defgroup dimm_long_op_status dimm_long_op_status 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_long_op_status table
 * @ingroup dimm_long_op_status
 */
struct db_dimm_long_op_status
{
	unsigned int device_handle;
	long long opcode;
	long long subopcode;
	long long percent_complete;
	long long etc;
	long long status_code;
};
/*!
 * Helper function to print a db_dimm_long_op_status to the screen.
 * @ingroup dimm_long_op_status
 * @param p_dimm_long_op_status
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_long_op_status(struct db_dimm_long_op_status *p_value);
/*!
 * Create a new row in the dimm_long_op_status table
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_long_op_status
 *		Pointer to the object to be saved to the dimm_long_op_status table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_long_op_status(const PersistentStore *p_ps, struct db_dimm_long_op_status *p_dimm_long_op_status);
/*!
 * Get the total number of dimm_long_op_statuss
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_long_op_statuss
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_long_op_status_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_long_op_statuss
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_long_op_status
 *		Pointer to an array of dimm_long_op_status objects that will contain all the dimm_long_op_statuss
 * @param[in] dimm_long_op_status_count
 *		Size of p_dimm_long_op_status
 * @return The number of row (to max of dimm_long_op_status_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_long_op_statuss(const PersistentStore *p_ps,
	struct db_dimm_long_op_status
	*p_dimm_long_op_status,
	int dimm_long_op_status_count);
/*!
 * Truncate all the data in the dimm_long_op_status table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_long_op_statuss(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_long_op_status history
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_long_op_status_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_long_op_status state
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_long_op_status to
 * @param[in] p_dimm_long_op_status
 *		dimm_long_op_status to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_long_op_status_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_long_op_status *p_dimm_long_op_status);
/*!
 * Return a specific dimm_long_op_status for a given device_handle
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_long_op_status
 * @param[out] p_dimm_long_op_status
 *		struct to put the dimm_long_op_status retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_long_op_status_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_long_op_status *p_dimm_long_op_status);
/*!
 * Update a specific dimm_long_op_status given the original device_handle
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_long_op_status to update
 * @param[in] *p_updated_dimm_long_op_status
 *		structure with new values for the dimm_long_op_status
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_long_op_status_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_long_op_status *p_updated_dimm_long_op_status);
/*!
 * Delete a specific dimm_long_op_status given the device_handle
 * @ingroup dimm_long_op_status
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_long_op_status_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_long_op_status_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_long_op_status_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_long_op_status_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_long_op_status_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_long_op_status
 *		Structure type for row results
 * @param[in] p_dimm_long_op_status
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_long_op_status_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_long_op_status_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_long_op_status *p_dimm_long_op_status,
	int history_id,
	int dimm_long_op_status_count);
/*!
 * @defgroup dimm_details dimm_details 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_DETAILS_PART_NUMBER_LEN 32 //!< Max length for part_number
#define	DIMM_DETAILS_DEVICE_LOCATOR_LEN 128 //!< Max length for device_locator
#define	DIMM_DETAILS_BANK_LABEL_LEN 128 //!< Max length for bank_label
#define	DIMM_DETAILS_MANUFACTURER_LEN 256 //!< Max length for manufacturer
/*!
 * struct representing the dimm_details table
 * @ingroup dimm_details
 */
struct db_dimm_details
{
	unsigned int device_handle;
	unsigned int form_factor;
	unsigned long long data_width;
	unsigned long long total_width;
	unsigned long long size;
	unsigned long long speed;
	char   part_number[DIMM_DETAILS_PART_NUMBER_LEN];
	char   device_locator[DIMM_DETAILS_DEVICE_LOCATOR_LEN];
	char   bank_label[DIMM_DETAILS_BANK_LABEL_LEN];
	char   manufacturer[DIMM_DETAILS_MANUFACTURER_LEN];
	unsigned int type;
	unsigned int type_detail;
	unsigned int id;
};
/*!
 * Helper function to print a db_dimm_details to the screen.
 * @ingroup dimm_details
 * @param p_dimm_details
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_details(struct db_dimm_details *p_value);
/*!
 * Create a new row in the dimm_details table
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_details
 *		Pointer to the object to be saved to the dimm_details table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_details(const PersistentStore *p_ps, struct db_dimm_details *p_dimm_details);
/*!
 * Get the total number of dimm_detailss
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_detailss
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_details_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_detailss
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_details
 *		Pointer to an array of dimm_details objects that will contain all the dimm_detailss
 * @param[in] dimm_details_count
 *		Size of p_dimm_details
 * @return The number of row (to max of dimm_details_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_detailss(const PersistentStore *p_ps,
	struct db_dimm_details
	*p_dimm_details,
	int dimm_details_count);
/*!
 * Truncate all the data in the dimm_details table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_detailss(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_details history
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_details_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_details state
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_details to
 * @param[in] p_dimm_details
 *		dimm_details to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_details_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_details *p_dimm_details);
/*!
 * Return a specific dimm_details for a given id
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct dimm_details
 * @param[out] p_dimm_details
 *		struct to put the dimm_details retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_details_by_id(const PersistentStore *p_ps,
	const unsigned int id,
	struct db_dimm_details *p_dimm_details);
/*!
 * Update a specific dimm_details given the original id
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the dimm_details to update
 * @param[in] *p_updated_dimm_details
 *		structure with new values for the dimm_details
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_details_by_id(const PersistentStore *p_ps,
	const unsigned int id,
	struct db_dimm_details *p_updated_dimm_details);
/*!
 * Delete a specific dimm_details given the id
 * @ingroup dimm_details
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_details_by_id(const PersistentStore *p_ps,
	const unsigned int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_details_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_details_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_details_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_details_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_details
 *		Structure type for row results
 * @param[in] p_dimm_details
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_details_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_details_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_details *p_dimm_details,
	int history_id,
	int dimm_details_count);
/*!
 * @defgroup dimm_security_info dimm_security_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_security_info table
 * @ingroup dimm_security_info
 */
struct db_dimm_security_info
{
	unsigned int device_handle;
	int security_state;
};
/*!
 * Helper function to print a db_dimm_security_info to the screen.
 * @ingroup dimm_security_info
 * @param p_dimm_security_info
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_security_info(struct db_dimm_security_info *p_value);
/*!
 * Create a new row in the dimm_security_info table
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_security_info
 *		Pointer to the object to be saved to the dimm_security_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_security_info(const PersistentStore *p_ps, struct db_dimm_security_info *p_dimm_security_info);
/*!
 * Get the total number of dimm_security_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_security_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_security_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_security_infos
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_security_info
 *		Pointer to an array of dimm_security_info objects that will contain all the dimm_security_infos
 * @param[in] dimm_security_info_count
 *		Size of p_dimm_security_info
 * @return The number of row (to max of dimm_security_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_security_infos(const PersistentStore *p_ps,
	struct db_dimm_security_info
	*p_dimm_security_info,
	int dimm_security_info_count);
/*!
 * Truncate all the data in the dimm_security_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_security_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_security_info history
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_security_info_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_security_info state
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_security_info to
 * @param[in] p_dimm_security_info
 *		dimm_security_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_security_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_security_info *p_dimm_security_info);
/*!
 * Return a specific dimm_security_info for a given device_handle
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_security_info
 * @param[out] p_dimm_security_info
 *		struct to put the dimm_security_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_security_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_security_info *p_dimm_security_info);
/*!
 * Update a specific dimm_security_info given the original device_handle
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_security_info to update
 * @param[in] *p_updated_dimm_security_info
 *		structure with new values for the dimm_security_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_security_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_security_info *p_updated_dimm_security_info);
/*!
 * Delete a specific dimm_security_info given the device_handle
 * @ingroup dimm_security_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_security_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_security_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_security_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_security_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_security_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_security_info
 *		Structure type for row results
 * @param[in] p_dimm_security_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_security_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_security_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_security_info *p_dimm_security_info,
	int history_id,
	int dimm_security_info_count);
/*!
 * @defgroup dimm_sanitize_info dimm_sanitize_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_sanitize_info table
 * @ingroup dimm_sanitize_info
 */
struct db_dimm_sanitize_info
{
	unsigned int device_handle;
	int sanitize_state;
	int sanitize_progress;
};
/*!
 * Helper function to print a db_dimm_sanitize_info to the screen.
 * @ingroup dimm_sanitize_info
 * @param p_dimm_sanitize_info
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_sanitize_info(struct db_dimm_sanitize_info *p_value);
/*!
 * Create a new row in the dimm_sanitize_info table
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_sanitize_info
 *		Pointer to the object to be saved to the dimm_sanitize_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_sanitize_info(const PersistentStore *p_ps, struct db_dimm_sanitize_info *p_dimm_sanitize_info);
/*!
 * Get the total number of dimm_sanitize_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_sanitize_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_sanitize_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_sanitize_infos
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_sanitize_info
 *		Pointer to an array of dimm_sanitize_info objects that will contain all the dimm_sanitize_infos
 * @param[in] dimm_sanitize_info_count
 *		Size of p_dimm_sanitize_info
 * @return The number of row (to max of dimm_sanitize_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_sanitize_infos(const PersistentStore *p_ps,
	struct db_dimm_sanitize_info
	*p_dimm_sanitize_info,
	int dimm_sanitize_info_count);
/*!
 * Truncate all the data in the dimm_sanitize_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_sanitize_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_sanitize_info history
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_sanitize_info_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_sanitize_info state
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_sanitize_info to
 * @param[in] p_dimm_sanitize_info
 *		dimm_sanitize_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_sanitize_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_sanitize_info *p_dimm_sanitize_info);
/*!
 * Return a specific dimm_sanitize_info for a given device_handle
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_sanitize_info
 * @param[out] p_dimm_sanitize_info
 *		struct to put the dimm_sanitize_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_sanitize_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_sanitize_info *p_dimm_sanitize_info);
/*!
 * Update a specific dimm_sanitize_info given the original device_handle
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_sanitize_info to update
 * @param[in] *p_updated_dimm_sanitize_info
 *		structure with new values for the dimm_sanitize_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_sanitize_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_sanitize_info *p_updated_dimm_sanitize_info);
/*!
 * Delete a specific dimm_sanitize_info given the device_handle
 * @ingroup dimm_sanitize_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_sanitize_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_sanitize_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_sanitize_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_sanitize_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_sanitize_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_sanitize_info
 *		Structure type for row results
 * @param[in] p_dimm_sanitize_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_sanitize_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_sanitize_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_sanitize_info *p_dimm_sanitize_info,
	int history_id,
	int dimm_sanitize_info_count);
/*!
 * @defgroup fw_media_low_log_entry fw_media_low_log_entry 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_media_low_log_entry table
 * @ingroup fw_media_low_log_entry
 */
struct db_fw_media_low_log_entry
{
	unsigned int device_handle;
	unsigned long long system_timestamp;
	unsigned long long dpa;
	unsigned long long pda;
	unsigned int range;
	unsigned int error_type;
	unsigned int error_flags;
	unsigned int transaction_type;
};
/*!
 * Helper function to print a db_fw_media_low_log_entry to the screen.
 * @ingroup fw_media_low_log_entry
 * @param p_fw_media_low_log_entry
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_media_low_log_entry(struct db_fw_media_low_log_entry *p_value);
/*!
 * Create a new row in the fw_media_low_log_entry table
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_media_low_log_entry
 *		Pointer to the object to be saved to the fw_media_low_log_entry table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_media_low_log_entry(const PersistentStore *p_ps, struct db_fw_media_low_log_entry *p_fw_media_low_log_entry);
/*!
 * Get the total number of fw_media_low_log_entrys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_media_low_log_entrys
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_media_low_log_entry_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_media_low_log_entrys
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_media_low_log_entry
 *		Pointer to an array of fw_media_low_log_entry objects that will contain all the fw_media_low_log_entrys
 * @param[in] fw_media_low_log_entry_count
 *		Size of p_fw_media_low_log_entry
 * @return The number of row (to max of fw_media_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_media_low_log_entrys(const PersistentStore *p_ps,
	struct db_fw_media_low_log_entry
	*p_fw_media_low_log_entry,
	int fw_media_low_log_entry_count);
/*!
 * Truncate all the data in the fw_media_low_log_entry table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_media_low_log_entrys(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_media_low_log_entry history
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_media_low_log_entry_history(const PersistentStore *p_ps);
 
/*!
 * save fw_media_low_log_entry state
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_media_low_log_entry to
 * @param[in] p_fw_media_low_log_entry
 *		fw_media_low_log_entry to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_media_low_log_entry_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_media_low_log_entry *p_fw_media_low_log_entry);
/*!
 * Return a specific fw_media_low_log_entry for a given system_timestamp
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp to identify the correct fw_media_low_log_entry
 * @param[out] p_fw_media_low_log_entry
 *		struct to put the fw_media_low_log_entry retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_low_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_media_low_log_entry *p_fw_media_low_log_entry);
/*!
 * Update a specific fw_media_low_log_entry given the original system_timestamp
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 * 		system_timestamp points to the fw_media_low_log_entry to update
 * @param[in] *p_updated_fw_media_low_log_entry
 *		structure with new values for the fw_media_low_log_entry
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_media_low_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_media_low_log_entry *p_updated_fw_media_low_log_entry);
/*!
 * Delete a specific fw_media_low_log_entry given the system_timestamp
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_media_low_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_low_log_entry_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_low_log_entry_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_media_low_log_entry
 *		Structure type for row results
 * @param[in] p_fw_media_low_log_entry
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_media_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_media_low_log_entry_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_media_low_log_entry *p_fw_media_low_log_entry,
	int history_id,
	int fw_media_low_log_entry_count);
/*!
 * Return the number of fw_media_low_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_media_low_log_entry and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_low_log_entry_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of fw_media_low_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_media_low_log_entry and get all with passed in device_handle
 * @param[out] p_fw_media_low_log_entry
 *		memory to hold the found fw_media_low_log_entrys
 * @param[in]   fw_media_low_log_entry_count
 *		Size of fw_media_low_log_entry array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_low_log_entrys_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_fw_media_low_log_entry *p_fw_media_low_log_entry,
	int fw_media_low_log_entry_count);
/*!
 * Delete a list of specific fw_media_low_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_media_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_media_low_log_entry and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_media_low_log_entry_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup fw_media_high_log_entry fw_media_high_log_entry 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_media_high_log_entry table
 * @ingroup fw_media_high_log_entry
 */
struct db_fw_media_high_log_entry
{
	unsigned int device_handle;
	unsigned long long system_timestamp;
	unsigned long long dpa;
	unsigned long long pda;
	unsigned int range;
	unsigned int error_type;
	unsigned int error_flags;
	unsigned int transaction_type;
};
/*!
 * Helper function to print a db_fw_media_high_log_entry to the screen.
 * @ingroup fw_media_high_log_entry
 * @param p_fw_media_high_log_entry
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_media_high_log_entry(struct db_fw_media_high_log_entry *p_value);
/*!
 * Create a new row in the fw_media_high_log_entry table
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_media_high_log_entry
 *		Pointer to the object to be saved to the fw_media_high_log_entry table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_media_high_log_entry(const PersistentStore *p_ps, struct db_fw_media_high_log_entry *p_fw_media_high_log_entry);
/*!
 * Get the total number of fw_media_high_log_entrys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_media_high_log_entrys
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_media_high_log_entry_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_media_high_log_entrys
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_media_high_log_entry
 *		Pointer to an array of fw_media_high_log_entry objects that will contain all the fw_media_high_log_entrys
 * @param[in] fw_media_high_log_entry_count
 *		Size of p_fw_media_high_log_entry
 * @return The number of row (to max of fw_media_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_media_high_log_entrys(const PersistentStore *p_ps,
	struct db_fw_media_high_log_entry
	*p_fw_media_high_log_entry,
	int fw_media_high_log_entry_count);
/*!
 * Truncate all the data in the fw_media_high_log_entry table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_media_high_log_entrys(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_media_high_log_entry history
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_media_high_log_entry_history(const PersistentStore *p_ps);
 
/*!
 * save fw_media_high_log_entry state
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_media_high_log_entry to
 * @param[in] p_fw_media_high_log_entry
 *		fw_media_high_log_entry to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_media_high_log_entry_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_media_high_log_entry *p_fw_media_high_log_entry);
/*!
 * Return a specific fw_media_high_log_entry for a given system_timestamp
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp to identify the correct fw_media_high_log_entry
 * @param[out] p_fw_media_high_log_entry
 *		struct to put the fw_media_high_log_entry retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_high_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_media_high_log_entry *p_fw_media_high_log_entry);
/*!
 * Update a specific fw_media_high_log_entry given the original system_timestamp
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 * 		system_timestamp points to the fw_media_high_log_entry to update
 * @param[in] *p_updated_fw_media_high_log_entry
 *		structure with new values for the fw_media_high_log_entry
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_media_high_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_media_high_log_entry *p_updated_fw_media_high_log_entry);
/*!
 * Delete a specific fw_media_high_log_entry given the system_timestamp
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_media_high_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_high_log_entry_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_high_log_entry_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_media_high_log_entry
 *		Structure type for row results
 * @param[in] p_fw_media_high_log_entry
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_media_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_media_high_log_entry_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_media_high_log_entry *p_fw_media_high_log_entry,
	int history_id,
	int fw_media_high_log_entry_count);
/*!
 * Return the number of fw_media_high_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_media_high_log_entry and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_high_log_entry_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of fw_media_high_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_media_high_log_entry and get all with passed in device_handle
 * @param[out] p_fw_media_high_log_entry
 *		memory to hold the found fw_media_high_log_entrys
 * @param[in]   fw_media_high_log_entry_count
 *		Size of fw_media_high_log_entry array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_high_log_entrys_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_fw_media_high_log_entry *p_fw_media_high_log_entry,
	int fw_media_high_log_entry_count);
/*!
 * Delete a list of specific fw_media_high_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_media_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_media_high_log_entry and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_media_high_log_entry_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup fw_thermal_low_log_entry fw_thermal_low_log_entry 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_thermal_low_log_entry table
 * @ingroup fw_thermal_low_log_entry
 */
struct db_fw_thermal_low_log_entry
{
	unsigned int device_handle;
	unsigned long long system_timestamp;
	unsigned int host_reported_temp_data;
};
/*!
 * Helper function to print a db_fw_thermal_low_log_entry to the screen.
 * @ingroup fw_thermal_low_log_entry
 * @param p_fw_thermal_low_log_entry
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_thermal_low_log_entry(struct db_fw_thermal_low_log_entry *p_value);
/*!
 * Create a new row in the fw_thermal_low_log_entry table
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_thermal_low_log_entry
 *		Pointer to the object to be saved to the fw_thermal_low_log_entry table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_thermal_low_log_entry(const PersistentStore *p_ps, struct db_fw_thermal_low_log_entry *p_fw_thermal_low_log_entry);
/*!
 * Get the total number of fw_thermal_low_log_entrys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_thermal_low_log_entrys
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_thermal_low_log_entry_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_thermal_low_log_entrys
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_thermal_low_log_entry
 *		Pointer to an array of fw_thermal_low_log_entry objects that will contain all the fw_thermal_low_log_entrys
 * @param[in] fw_thermal_low_log_entry_count
 *		Size of p_fw_thermal_low_log_entry
 * @return The number of row (to max of fw_thermal_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_thermal_low_log_entrys(const PersistentStore *p_ps,
	struct db_fw_thermal_low_log_entry
	*p_fw_thermal_low_log_entry,
	int fw_thermal_low_log_entry_count);
/*!
 * Truncate all the data in the fw_thermal_low_log_entry table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_thermal_low_log_entrys(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_thermal_low_log_entry history
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_thermal_low_log_entry_history(const PersistentStore *p_ps);
 
/*!
 * save fw_thermal_low_log_entry state
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_thermal_low_log_entry to
 * @param[in] p_fw_thermal_low_log_entry
 *		fw_thermal_low_log_entry to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_thermal_low_log_entry_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_thermal_low_log_entry *p_fw_thermal_low_log_entry);
/*!
 * Return a specific fw_thermal_low_log_entry for a given system_timestamp
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp to identify the correct fw_thermal_low_log_entry
 * @param[out] p_fw_thermal_low_log_entry
 *		struct to put the fw_thermal_low_log_entry retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_low_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_thermal_low_log_entry *p_fw_thermal_low_log_entry);
/*!
 * Update a specific fw_thermal_low_log_entry given the original system_timestamp
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 * 		system_timestamp points to the fw_thermal_low_log_entry to update
 * @param[in] *p_updated_fw_thermal_low_log_entry
 *		structure with new values for the fw_thermal_low_log_entry
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_thermal_low_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_thermal_low_log_entry *p_updated_fw_thermal_low_log_entry);
/*!
 * Delete a specific fw_thermal_low_log_entry given the system_timestamp
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_thermal_low_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_low_log_entry_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_low_log_entry_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_thermal_low_log_entry
 *		Structure type for row results
 * @param[in] p_fw_thermal_low_log_entry
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_thermal_low_log_entry_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_thermal_low_log_entry_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_thermal_low_log_entry *p_fw_thermal_low_log_entry,
	int history_id,
	int fw_thermal_low_log_entry_count);
/*!
 * Return the number of fw_thermal_low_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_thermal_low_log_entry and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_low_log_entry_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of fw_thermal_low_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_thermal_low_log_entry and get all with passed in device_handle
 * @param[out] p_fw_thermal_low_log_entry
 *		memory to hold the found fw_thermal_low_log_entrys
 * @param[in]   fw_thermal_low_log_entry_count
 *		Size of fw_thermal_low_log_entry array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_low_log_entrys_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_fw_thermal_low_log_entry *p_fw_thermal_low_log_entry,
	int fw_thermal_low_log_entry_count);
/*!
 * Delete a list of specific fw_thermal_low_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_thermal_low_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_thermal_low_log_entry and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_thermal_low_log_entry_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup fw_thermal_high_log_entry fw_thermal_high_log_entry 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_thermal_high_log_entry table
 * @ingroup fw_thermal_high_log_entry
 */
struct db_fw_thermal_high_log_entry
{
	unsigned int device_handle;
	unsigned long long system_timestamp;
	unsigned int host_reported_temp_data;
};
/*!
 * Helper function to print a db_fw_thermal_high_log_entry to the screen.
 * @ingroup fw_thermal_high_log_entry
 * @param p_fw_thermal_high_log_entry
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_thermal_high_log_entry(struct db_fw_thermal_high_log_entry *p_value);
/*!
 * Create a new row in the fw_thermal_high_log_entry table
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_thermal_high_log_entry
 *		Pointer to the object to be saved to the fw_thermal_high_log_entry table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_thermal_high_log_entry(const PersistentStore *p_ps, struct db_fw_thermal_high_log_entry *p_fw_thermal_high_log_entry);
/*!
 * Get the total number of fw_thermal_high_log_entrys
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_thermal_high_log_entrys
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_thermal_high_log_entry_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_thermal_high_log_entrys
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_thermal_high_log_entry
 *		Pointer to an array of fw_thermal_high_log_entry objects that will contain all the fw_thermal_high_log_entrys
 * @param[in] fw_thermal_high_log_entry_count
 *		Size of p_fw_thermal_high_log_entry
 * @return The number of row (to max of fw_thermal_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_thermal_high_log_entrys(const PersistentStore *p_ps,
	struct db_fw_thermal_high_log_entry
	*p_fw_thermal_high_log_entry,
	int fw_thermal_high_log_entry_count);
/*!
 * Truncate all the data in the fw_thermal_high_log_entry table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_thermal_high_log_entrys(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_thermal_high_log_entry history
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_thermal_high_log_entry_history(const PersistentStore *p_ps);
 
/*!
 * save fw_thermal_high_log_entry state
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_thermal_high_log_entry to
 * @param[in] p_fw_thermal_high_log_entry
 *		fw_thermal_high_log_entry to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_thermal_high_log_entry_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_thermal_high_log_entry *p_fw_thermal_high_log_entry);
/*!
 * Return a specific fw_thermal_high_log_entry for a given system_timestamp
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp to identify the correct fw_thermal_high_log_entry
 * @param[out] p_fw_thermal_high_log_entry
 *		struct to put the fw_thermal_high_log_entry retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_high_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_thermal_high_log_entry *p_fw_thermal_high_log_entry);
/*!
 * Update a specific fw_thermal_high_log_entry given the original system_timestamp
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 * 		system_timestamp points to the fw_thermal_high_log_entry to update
 * @param[in] *p_updated_fw_thermal_high_log_entry
 *		structure with new values for the fw_thermal_high_log_entry
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_thermal_high_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp,
	struct db_fw_thermal_high_log_entry *p_updated_fw_thermal_high_log_entry);
/*!
 * Delete a specific fw_thermal_high_log_entry given the system_timestamp
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] system_timestamp
 *		system_timestamp points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_thermal_high_log_entry_by_system_timestamp(const PersistentStore *p_ps,
	const unsigned long long system_timestamp);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_high_log_entry_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_high_log_entry_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_thermal_high_log_entry
 *		Structure type for row results
 * @param[in] p_fw_thermal_high_log_entry
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_thermal_high_log_entry_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_thermal_high_log_entry_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_thermal_high_log_entry *p_fw_thermal_high_log_entry,
	int history_id,
	int fw_thermal_high_log_entry_count);
/*!
 * Return the number of fw_thermal_high_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_thermal_high_log_entry and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_high_log_entry_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of fw_thermal_high_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_thermal_high_log_entry and get all with passed in device_handle
 * @param[out] p_fw_thermal_high_log_entry
 *		memory to hold the found fw_thermal_high_log_entrys
 * @param[in]   fw_thermal_high_log_entry_count
 *		Size of fw_thermal_high_log_entry array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_high_log_entrys_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_fw_thermal_high_log_entry *p_fw_thermal_high_log_entry,
	int fw_thermal_high_log_entry_count);
/*!
 * Delete a list of specific fw_thermal_high_log_entrys for a given dimm_topology.device_handle
 * @ingroup fw_thermal_high_log_entry
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search fw_thermal_high_log_entry and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_thermal_high_log_entry_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup fw_media_low_log_info fw_media_low_log_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_media_low_log_info table
 * @ingroup fw_media_low_log_info
 */
struct db_fw_media_low_log_info
{
	unsigned int device_handle;
	unsigned int max_log_entries;
	unsigned int new_log_entries;
	unsigned long long newest_log_entry_timestamp;
	unsigned long long oldest_log_entry_timestamp;
};
/*!
 * Helper function to print a db_fw_media_low_log_info to the screen.
 * @ingroup fw_media_low_log_info
 * @param p_fw_media_low_log_info
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_media_low_log_info(struct db_fw_media_low_log_info *p_value);
/*!
 * Create a new row in the fw_media_low_log_info table
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_media_low_log_info
 *		Pointer to the object to be saved to the fw_media_low_log_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_media_low_log_info(const PersistentStore *p_ps, struct db_fw_media_low_log_info *p_fw_media_low_log_info);
/*!
 * Get the total number of fw_media_low_log_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_media_low_log_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_media_low_log_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_media_low_log_infos
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_media_low_log_info
 *		Pointer to an array of fw_media_low_log_info objects that will contain all the fw_media_low_log_infos
 * @param[in] fw_media_low_log_info_count
 *		Size of p_fw_media_low_log_info
 * @return The number of row (to max of fw_media_low_log_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_media_low_log_infos(const PersistentStore *p_ps,
	struct db_fw_media_low_log_info
	*p_fw_media_low_log_info,
	int fw_media_low_log_info_count);
/*!
 * Truncate all the data in the fw_media_low_log_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_media_low_log_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_media_low_log_info history
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_media_low_log_info_history(const PersistentStore *p_ps);
 
/*!
 * save fw_media_low_log_info state
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_media_low_log_info to
 * @param[in] p_fw_media_low_log_info
 *		fw_media_low_log_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_media_low_log_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_media_low_log_info *p_fw_media_low_log_info);
/*!
 * Return a specific fw_media_low_log_info for a given device_handle
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct fw_media_low_log_info
 * @param[out] p_fw_media_low_log_info
 *		struct to put the fw_media_low_log_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_low_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_media_low_log_info *p_fw_media_low_log_info);
/*!
 * Update a specific fw_media_low_log_info given the original device_handle
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the fw_media_low_log_info to update
 * @param[in] *p_updated_fw_media_low_log_info
 *		structure with new values for the fw_media_low_log_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_media_low_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_media_low_log_info *p_updated_fw_media_low_log_info);
/*!
 * Delete a specific fw_media_low_log_info given the device_handle
 * @ingroup fw_media_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_media_low_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_low_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_low_log_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_low_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_low_log_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_media_low_log_info
 *		Structure type for row results
 * @param[in] p_fw_media_low_log_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_media_low_log_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_media_low_log_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_media_low_log_info *p_fw_media_low_log_info,
	int history_id,
	int fw_media_low_log_info_count);
/*!
 * @defgroup fw_media_high_log_info fw_media_high_log_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_media_high_log_info table
 * @ingroup fw_media_high_log_info
 */
struct db_fw_media_high_log_info
{
	unsigned int device_handle;
	unsigned int max_log_entries;
	unsigned int new_log_entries;
	unsigned long long newest_log_entry_timestamp;
	unsigned long long oldest_log_entry_timestamp;
};
/*!
 * Helper function to print a db_fw_media_high_log_info to the screen.
 * @ingroup fw_media_high_log_info
 * @param p_fw_media_high_log_info
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_media_high_log_info(struct db_fw_media_high_log_info *p_value);
/*!
 * Create a new row in the fw_media_high_log_info table
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_media_high_log_info
 *		Pointer to the object to be saved to the fw_media_high_log_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_media_high_log_info(const PersistentStore *p_ps, struct db_fw_media_high_log_info *p_fw_media_high_log_info);
/*!
 * Get the total number of fw_media_high_log_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_media_high_log_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_media_high_log_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_media_high_log_infos
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_media_high_log_info
 *		Pointer to an array of fw_media_high_log_info objects that will contain all the fw_media_high_log_infos
 * @param[in] fw_media_high_log_info_count
 *		Size of p_fw_media_high_log_info
 * @return The number of row (to max of fw_media_high_log_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_media_high_log_infos(const PersistentStore *p_ps,
	struct db_fw_media_high_log_info
	*p_fw_media_high_log_info,
	int fw_media_high_log_info_count);
/*!
 * Truncate all the data in the fw_media_high_log_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_media_high_log_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_media_high_log_info history
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_media_high_log_info_history(const PersistentStore *p_ps);
 
/*!
 * save fw_media_high_log_info state
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_media_high_log_info to
 * @param[in] p_fw_media_high_log_info
 *		fw_media_high_log_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_media_high_log_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_media_high_log_info *p_fw_media_high_log_info);
/*!
 * Return a specific fw_media_high_log_info for a given device_handle
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct fw_media_high_log_info
 * @param[out] p_fw_media_high_log_info
 *		struct to put the fw_media_high_log_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_media_high_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_media_high_log_info *p_fw_media_high_log_info);
/*!
 * Update a specific fw_media_high_log_info given the original device_handle
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the fw_media_high_log_info to update
 * @param[in] *p_updated_fw_media_high_log_info
 *		structure with new values for the fw_media_high_log_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_media_high_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_media_high_log_info *p_updated_fw_media_high_log_info);
/*!
 * Delete a specific fw_media_high_log_info given the device_handle
 * @ingroup fw_media_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_media_high_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_high_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_high_log_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_media_high_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_media_high_log_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_media_high_log_info
 *		Structure type for row results
 * @param[in] p_fw_media_high_log_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_media_high_log_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_media_high_log_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_media_high_log_info *p_fw_media_high_log_info,
	int history_id,
	int fw_media_high_log_info_count);
/*!
 * @defgroup fw_thermal_low_log_info fw_thermal_low_log_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_thermal_low_log_info table
 * @ingroup fw_thermal_low_log_info
 */
struct db_fw_thermal_low_log_info
{
	unsigned int device_handle;
	unsigned int max_log_entries;
	unsigned int new_log_entries;
	unsigned long long newest_log_entry_timestamp;
	unsigned long long oldest_log_entry_timestamp;
};
/*!
 * Helper function to print a db_fw_thermal_low_log_info to the screen.
 * @ingroup fw_thermal_low_log_info
 * @param p_fw_thermal_low_log_info
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_thermal_low_log_info(struct db_fw_thermal_low_log_info *p_value);
/*!
 * Create a new row in the fw_thermal_low_log_info table
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_thermal_low_log_info
 *		Pointer to the object to be saved to the fw_thermal_low_log_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_thermal_low_log_info(const PersistentStore *p_ps, struct db_fw_thermal_low_log_info *p_fw_thermal_low_log_info);
/*!
 * Get the total number of fw_thermal_low_log_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_thermal_low_log_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_thermal_low_log_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_thermal_low_log_infos
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_thermal_low_log_info
 *		Pointer to an array of fw_thermal_low_log_info objects that will contain all the fw_thermal_low_log_infos
 * @param[in] fw_thermal_low_log_info_count
 *		Size of p_fw_thermal_low_log_info
 * @return The number of row (to max of fw_thermal_low_log_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_thermal_low_log_infos(const PersistentStore *p_ps,
	struct db_fw_thermal_low_log_info
	*p_fw_thermal_low_log_info,
	int fw_thermal_low_log_info_count);
/*!
 * Truncate all the data in the fw_thermal_low_log_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_thermal_low_log_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_thermal_low_log_info history
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_thermal_low_log_info_history(const PersistentStore *p_ps);
 
/*!
 * save fw_thermal_low_log_info state
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_thermal_low_log_info to
 * @param[in] p_fw_thermal_low_log_info
 *		fw_thermal_low_log_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_thermal_low_log_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_thermal_low_log_info *p_fw_thermal_low_log_info);
/*!
 * Return a specific fw_thermal_low_log_info for a given device_handle
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct fw_thermal_low_log_info
 * @param[out] p_fw_thermal_low_log_info
 *		struct to put the fw_thermal_low_log_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_low_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_thermal_low_log_info *p_fw_thermal_low_log_info);
/*!
 * Update a specific fw_thermal_low_log_info given the original device_handle
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the fw_thermal_low_log_info to update
 * @param[in] *p_updated_fw_thermal_low_log_info
 *		structure with new values for the fw_thermal_low_log_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_thermal_low_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_thermal_low_log_info *p_updated_fw_thermal_low_log_info);
/*!
 * Delete a specific fw_thermal_low_log_info given the device_handle
 * @ingroup fw_thermal_low_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_thermal_low_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_low_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_low_log_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_low_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_low_log_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_thermal_low_log_info
 *		Structure type for row results
 * @param[in] p_fw_thermal_low_log_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_thermal_low_log_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_thermal_low_log_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_thermal_low_log_info *p_fw_thermal_low_log_info,
	int history_id,
	int fw_thermal_low_log_info_count);
/*!
 * @defgroup fw_thermal_high_log_info fw_thermal_high_log_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the fw_thermal_high_log_info table
 * @ingroup fw_thermal_high_log_info
 */
struct db_fw_thermal_high_log_info
{
	unsigned int device_handle;
	unsigned int max_log_entries;
	unsigned int new_log_entries;
	unsigned long long newest_log_entry_timestamp;
	unsigned long long oldest_log_entry_timestamp;
};
/*!
 * Helper function to print a db_fw_thermal_high_log_info to the screen.
 * @ingroup fw_thermal_high_log_info
 * @param p_fw_thermal_high_log_info
 * 		value to print
 * @return
 *		void
 */
void db_print_fw_thermal_high_log_info(struct db_fw_thermal_high_log_info *p_value);
/*!
 * Create a new row in the fw_thermal_high_log_info table
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_fw_thermal_high_log_info
 *		Pointer to the object to be saved to the fw_thermal_high_log_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_fw_thermal_high_log_info(const PersistentStore *p_ps, struct db_fw_thermal_high_log_info *p_fw_thermal_high_log_info);
/*!
 * Get the total number of fw_thermal_high_log_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of fw_thermal_high_log_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_fw_thermal_high_log_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all fw_thermal_high_log_infos
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_fw_thermal_high_log_info
 *		Pointer to an array of fw_thermal_high_log_info objects that will contain all the fw_thermal_high_log_infos
 * @param[in] fw_thermal_high_log_info_count
 *		Size of p_fw_thermal_high_log_info
 * @return The number of row (to max of fw_thermal_high_log_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_fw_thermal_high_log_infos(const PersistentStore *p_ps,
	struct db_fw_thermal_high_log_info
	*p_fw_thermal_high_log_info,
	int fw_thermal_high_log_info_count);
/*!
 * Truncate all the data in the fw_thermal_high_log_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_fw_thermal_high_log_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from fw_thermal_high_log_info history
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_fw_thermal_high_log_info_history(const PersistentStore *p_ps);
 
/*!
 * save fw_thermal_high_log_info state
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the fw_thermal_high_log_info to
 * @param[in] p_fw_thermal_high_log_info
 *		fw_thermal_high_log_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_fw_thermal_high_log_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_fw_thermal_high_log_info *p_fw_thermal_high_log_info);
/*!
 * Return a specific fw_thermal_high_log_info for a given device_handle
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct fw_thermal_high_log_info
 * @param[out] p_fw_thermal_high_log_info
 *		struct to put the fw_thermal_high_log_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_fw_thermal_high_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_thermal_high_log_info *p_fw_thermal_high_log_info);
/*!
 * Update a specific fw_thermal_high_log_info given the original device_handle
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the fw_thermal_high_log_info to update
 * @param[in] *p_updated_fw_thermal_high_log_info
 *		structure with new values for the fw_thermal_high_log_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_fw_thermal_high_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_fw_thermal_high_log_info *p_updated_fw_thermal_high_log_info);
/*!
 * Delete a specific fw_thermal_high_log_info given the device_handle
 * @ingroup fw_thermal_high_log_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_fw_thermal_high_log_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_high_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_high_log_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of fw_thermal_high_log_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_fw_thermal_high_log_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_fw_thermal_high_log_info
 *		Structure type for row results
 * @param[in] p_fw_thermal_high_log_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of fw_thermal_high_log_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_fw_thermal_high_log_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_fw_thermal_high_log_info *p_fw_thermal_high_log_info,
	int history_id,
	int fw_thermal_high_log_info_count);
/*!
 * @defgroup dimm_fw_log_level dimm_fw_log_level 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_fw_log_level table
 * @ingroup dimm_fw_log_level
 */
struct db_dimm_fw_log_level
{
	int device_handle;
	int log_level;
};
/*!
 * Helper function to print a db_dimm_fw_log_level to the screen.
 * @ingroup dimm_fw_log_level
 * @param p_dimm_fw_log_level
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_fw_log_level(struct db_dimm_fw_log_level *p_value);
/*!
 * Create a new row in the dimm_fw_log_level table
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_fw_log_level
 *		Pointer to the object to be saved to the dimm_fw_log_level table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_fw_log_level(const PersistentStore *p_ps, struct db_dimm_fw_log_level *p_dimm_fw_log_level);
/*!
 * Get the total number of dimm_fw_log_levels
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_fw_log_levels
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_fw_log_level_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_fw_log_levels
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_fw_log_level
 *		Pointer to an array of dimm_fw_log_level objects that will contain all the dimm_fw_log_levels
 * @param[in] dimm_fw_log_level_count
 *		Size of p_dimm_fw_log_level
 * @return The number of row (to max of dimm_fw_log_level_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_fw_log_levels(const PersistentStore *p_ps,
	struct db_dimm_fw_log_level
	*p_dimm_fw_log_level,
	int dimm_fw_log_level_count);
/*!
 * Truncate all the data in the dimm_fw_log_level table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_fw_log_levels(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_fw_log_level history
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_fw_log_level_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_fw_log_level state
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_fw_log_level to
 * @param[in] p_dimm_fw_log_level
 *		dimm_fw_log_level to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_fw_log_level_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_fw_log_level *p_dimm_fw_log_level);
/*!
 * Return a specific dimm_fw_log_level for a given device_handle
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_fw_log_level
 * @param[out] p_dimm_fw_log_level
 *		struct to put the dimm_fw_log_level retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_fw_log_level_by_device_handle(const PersistentStore *p_ps,
	const int device_handle,
	struct db_dimm_fw_log_level *p_dimm_fw_log_level);
/*!
 * Update a specific dimm_fw_log_level given the original device_handle
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_fw_log_level to update
 * @param[in] *p_updated_dimm_fw_log_level
 *		structure with new values for the dimm_fw_log_level
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_fw_log_level_by_device_handle(const PersistentStore *p_ps,
	const int device_handle,
	struct db_dimm_fw_log_level *p_updated_dimm_fw_log_level);
/*!
 * Delete a specific dimm_fw_log_level given the device_handle
 * @ingroup dimm_fw_log_level
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_fw_log_level_by_device_handle(const PersistentStore *p_ps,
	const int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_log_level_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_log_level_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_log_level_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_log_level_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_fw_log_level
 *		Structure type for row results
 * @param[in] p_dimm_fw_log_level
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_fw_log_level_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_fw_log_level_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_fw_log_level *p_dimm_fw_log_level,
	int history_id,
	int dimm_fw_log_level_count);
/*!
 * @defgroup dimm_fw_time dimm_fw_time 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_fw_time table
 * @ingroup dimm_fw_time
 */
struct db_dimm_fw_time
{
	int device_handle;
	unsigned long long time;
};
/*!
 * Helper function to print a db_dimm_fw_time to the screen.
 * @ingroup dimm_fw_time
 * @param p_dimm_fw_time
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_fw_time(struct db_dimm_fw_time *p_value);
/*!
 * Create a new row in the dimm_fw_time table
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_fw_time
 *		Pointer to the object to be saved to the dimm_fw_time table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_fw_time(const PersistentStore *p_ps, struct db_dimm_fw_time *p_dimm_fw_time);
/*!
 * Get the total number of dimm_fw_times
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_fw_times
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_fw_time_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_fw_times
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_fw_time
 *		Pointer to an array of dimm_fw_time objects that will contain all the dimm_fw_times
 * @param[in] dimm_fw_time_count
 *		Size of p_dimm_fw_time
 * @return The number of row (to max of dimm_fw_time_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_fw_times(const PersistentStore *p_ps,
	struct db_dimm_fw_time
	*p_dimm_fw_time,
	int dimm_fw_time_count);
/*!
 * Truncate all the data in the dimm_fw_time table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_fw_times(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_fw_time history
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_fw_time_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_fw_time state
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_fw_time to
 * @param[in] p_dimm_fw_time
 *		dimm_fw_time to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_fw_time_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_fw_time *p_dimm_fw_time);
/*!
 * Return a specific dimm_fw_time for a given device_handle
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_fw_time
 * @param[out] p_dimm_fw_time
 *		struct to put the dimm_fw_time retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_fw_time_by_device_handle(const PersistentStore *p_ps,
	const int device_handle,
	struct db_dimm_fw_time *p_dimm_fw_time);
/*!
 * Update a specific dimm_fw_time given the original device_handle
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_fw_time to update
 * @param[in] *p_updated_dimm_fw_time
 *		structure with new values for the dimm_fw_time
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_fw_time_by_device_handle(const PersistentStore *p_ps,
	const int device_handle,
	struct db_dimm_fw_time *p_updated_dimm_fw_time);
/*!
 * Delete a specific dimm_fw_time given the device_handle
 * @ingroup dimm_fw_time
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_fw_time_by_device_handle(const PersistentStore *p_ps,
	const int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_time_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_time_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_fw_time_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_fw_time_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_fw_time
 *		Structure type for row results
 * @param[in] p_dimm_fw_time
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_fw_time_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_fw_time_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_fw_time *p_dimm_fw_time,
	int history_id,
	int dimm_fw_time_count);
/*!
 * @defgroup dimm_platform_config dimm_platform_config 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_PLATFORM_CONFIG_SIGNATURE_LEN 4 //!< Max length for signature
#define	DIMM_PLATFORM_CONFIG_OEM_ID_LEN 6 //!< Max length for oem_id
#define	DIMM_PLATFORM_CONFIG_OEM_TABLE_ID_LEN 8 //!< Max length for oem_table_id
/*!
 * struct representing the dimm_platform_config table
 * @ingroup dimm_platform_config
 */
struct db_dimm_platform_config
{
	unsigned int device_handle;
	char   signature[DIMM_PLATFORM_CONFIG_SIGNATURE_LEN];
	unsigned int length;
	unsigned int revision;
	unsigned int checksum;
	char   oem_id[DIMM_PLATFORM_CONFIG_OEM_ID_LEN];
	char   oem_table_id[DIMM_PLATFORM_CONFIG_OEM_TABLE_ID_LEN];
	unsigned int oem_revision;
	unsigned int creator_id;
	unsigned int creator_revision;
	unsigned int current_config_size;
	unsigned int current_config_offset;
	unsigned int config_input_size;
	unsigned int config_input_offset;
	unsigned int config_output_size;
	unsigned int config_output_offset;
};
/*!
 * Helper function to print a db_dimm_platform_config to the screen.
 * @ingroup dimm_platform_config
 * @param p_dimm_platform_config
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_platform_config(struct db_dimm_platform_config *p_value);
/*!
 * Create a new row in the dimm_platform_config table
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_platform_config
 *		Pointer to the object to be saved to the dimm_platform_config table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_platform_config(const PersistentStore *p_ps, struct db_dimm_platform_config *p_dimm_platform_config);
/*!
 * Get the total number of dimm_platform_configs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_platform_configs
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_platform_config_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_platform_configs
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_platform_config
 *		Pointer to an array of dimm_platform_config objects that will contain all the dimm_platform_configs
 * @param[in] dimm_platform_config_count
 *		Size of p_dimm_platform_config
 * @return The number of row (to max of dimm_platform_config_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_platform_configs(const PersistentStore *p_ps,
	struct db_dimm_platform_config
	*p_dimm_platform_config,
	int dimm_platform_config_count);
/*!
 * Truncate all the data in the dimm_platform_config table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_platform_configs(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_platform_config history
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_platform_config_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_platform_config state
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_platform_config to
 * @param[in] p_dimm_platform_config
 *		dimm_platform_config to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_platform_config_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_platform_config *p_dimm_platform_config);
/*!
 * Return a specific dimm_platform_config for a given device_handle
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_platform_config
 * @param[out] p_dimm_platform_config
 *		struct to put the dimm_platform_config retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_platform_config_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_platform_config *p_dimm_platform_config);
/*!
 * Update a specific dimm_platform_config given the original device_handle
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_platform_config to update
 * @param[in] *p_updated_dimm_platform_config
 *		structure with new values for the dimm_platform_config
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_platform_config_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_platform_config *p_updated_dimm_platform_config);
/*!
 * Delete a specific dimm_platform_config given the device_handle
 * @ingroup dimm_platform_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_platform_config_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_platform_config_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_platform_config_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_platform_config_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_platform_config_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_platform_config
 *		Structure type for row results
 * @param[in] p_dimm_platform_config
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_platform_config_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_platform_config_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_platform_config *p_dimm_platform_config,
	int history_id,
	int dimm_platform_config_count);
/*!
 * @defgroup dimm_current_config dimm_current_config 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_CURRENT_CONFIG_SIGNATURE_LEN 4 //!< Max length for signature
#define	DIMM_CURRENT_CONFIG_OEM_ID_LEN 6 //!< Max length for oem_id
#define	DIMM_CURRENT_CONFIG_OEM_TABLE_ID_LEN 8 //!< Max length for oem_table_id
/*!
 * struct representing the dimm_current_config table
 * @ingroup dimm_current_config
 */
struct db_dimm_current_config
{
	unsigned int device_handle;
	char   signature[DIMM_CURRENT_CONFIG_SIGNATURE_LEN];
	unsigned int length;
	unsigned int revision;
	unsigned int checksum;
	char   oem_id[DIMM_CURRENT_CONFIG_OEM_ID_LEN];
	char   oem_table_id[DIMM_CURRENT_CONFIG_OEM_TABLE_ID_LEN];
	unsigned int oem_revision;
	unsigned int creator_id;
	unsigned int creator_revision;
	unsigned int config_status;
	unsigned long long mapped_memory_capacity;
	unsigned long long mapped_app_direct_capacity;
};
/*!
 * Helper function to print a db_dimm_current_config to the screen.
 * @ingroup dimm_current_config
 * @param p_dimm_current_config
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_current_config(struct db_dimm_current_config *p_value);
/*!
 * Create a new row in the dimm_current_config table
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_current_config
 *		Pointer to the object to be saved to the dimm_current_config table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_current_config(const PersistentStore *p_ps, struct db_dimm_current_config *p_dimm_current_config);
/*!
 * Get the total number of dimm_current_configs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_current_configs
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_current_config_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_current_configs
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_current_config
 *		Pointer to an array of dimm_current_config objects that will contain all the dimm_current_configs
 * @param[in] dimm_current_config_count
 *		Size of p_dimm_current_config
 * @return The number of row (to max of dimm_current_config_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_current_configs(const PersistentStore *p_ps,
	struct db_dimm_current_config
	*p_dimm_current_config,
	int dimm_current_config_count);
/*!
 * Truncate all the data in the dimm_current_config table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_current_configs(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_current_config history
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_current_config_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_current_config state
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_current_config to
 * @param[in] p_dimm_current_config
 *		dimm_current_config to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_current_config_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_current_config *p_dimm_current_config);
/*!
 * Return a specific dimm_current_config for a given device_handle
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_current_config
 * @param[out] p_dimm_current_config
 *		struct to put the dimm_current_config retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_current_config_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_current_config *p_dimm_current_config);
/*!
 * Update a specific dimm_current_config given the original device_handle
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_current_config to update
 * @param[in] *p_updated_dimm_current_config
 *		structure with new values for the dimm_current_config
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_current_config_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_current_config *p_updated_dimm_current_config);
/*!
 * Delete a specific dimm_current_config given the device_handle
 * @ingroup dimm_current_config
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_current_config_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_current_config_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_current_config_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_current_config_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_current_config_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_current_config
 *		Structure type for row results
 * @param[in] p_dimm_current_config
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_current_config_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_current_config_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_current_config *p_dimm_current_config,
	int history_id,
	int dimm_current_config_count);
/*!
 * @defgroup dimm_config_input dimm_config_input 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_CONFIG_INPUT_SIGNATURE_LEN 4 //!< Max length for signature
#define	DIMM_CONFIG_INPUT_OEM_ID_LEN 6 //!< Max length for oem_id
#define	DIMM_CONFIG_INPUT_OEM_TABLE_ID_LEN 8 //!< Max length for oem_table_id
/*!
 * struct representing the dimm_config_input table
 * @ingroup dimm_config_input
 */
struct db_dimm_config_input
{
	unsigned int device_handle;
	char   signature[DIMM_CONFIG_INPUT_SIGNATURE_LEN];
	unsigned int length;
	unsigned int revision;
	unsigned int checksum;
	char   oem_id[DIMM_CONFIG_INPUT_OEM_ID_LEN];
	char   oem_table_id[DIMM_CONFIG_INPUT_OEM_TABLE_ID_LEN];
	unsigned int oem_revision;
	unsigned int creator_id;
	unsigned int creator_revision;
	unsigned int sequence_number;
};
/*!
 * Helper function to print a db_dimm_config_input to the screen.
 * @ingroup dimm_config_input
 * @param p_dimm_config_input
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_config_input(struct db_dimm_config_input *p_value);
/*!
 * Create a new row in the dimm_config_input table
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_config_input
 *		Pointer to the object to be saved to the dimm_config_input table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_config_input(const PersistentStore *p_ps, struct db_dimm_config_input *p_dimm_config_input);
/*!
 * Get the total number of dimm_config_inputs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_config_inputs
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_config_input_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_config_inputs
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_config_input
 *		Pointer to an array of dimm_config_input objects that will contain all the dimm_config_inputs
 * @param[in] dimm_config_input_count
 *		Size of p_dimm_config_input
 * @return The number of row (to max of dimm_config_input_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_config_inputs(const PersistentStore *p_ps,
	struct db_dimm_config_input
	*p_dimm_config_input,
	int dimm_config_input_count);
/*!
 * Truncate all the data in the dimm_config_input table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_config_inputs(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_config_input history
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_config_input_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_config_input state
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_config_input to
 * @param[in] p_dimm_config_input
 *		dimm_config_input to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_config_input_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_config_input *p_dimm_config_input);
/*!
 * Return a specific dimm_config_input for a given device_handle
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_config_input
 * @param[out] p_dimm_config_input
 *		struct to put the dimm_config_input retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_config_input_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_config_input *p_dimm_config_input);
/*!
 * Update a specific dimm_config_input given the original device_handle
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_config_input to update
 * @param[in] *p_updated_dimm_config_input
 *		structure with new values for the dimm_config_input
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_config_input_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_config_input *p_updated_dimm_config_input);
/*!
 * Delete a specific dimm_config_input given the device_handle
 * @ingroup dimm_config_input
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_config_input_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_config_input_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_config_input_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_config_input_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_config_input_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_config_input
 *		Structure type for row results
 * @param[in] p_dimm_config_input
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_config_input_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_config_input_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_config_input *p_dimm_config_input,
	int history_id,
	int dimm_config_input_count);
/*!
 * @defgroup dimm_config_output dimm_config_output 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DIMM_CONFIG_OUTPUT_SIGNATURE_LEN 4 //!< Max length for signature
#define	DIMM_CONFIG_OUTPUT_OEM_ID_LEN 6 //!< Max length for oem_id
#define	DIMM_CONFIG_OUTPUT_OEM_TABLE_ID_LEN 8 //!< Max length for oem_table_id
/*!
 * struct representing the dimm_config_output table
 * @ingroup dimm_config_output
 */
struct db_dimm_config_output
{
	unsigned int device_handle;
	char   signature[DIMM_CONFIG_OUTPUT_SIGNATURE_LEN];
	unsigned int length;
	unsigned int revision;
	unsigned int checksum;
	char   oem_id[DIMM_CONFIG_OUTPUT_OEM_ID_LEN];
	char   oem_table_id[DIMM_CONFIG_OUTPUT_OEM_TABLE_ID_LEN];
	unsigned int oem_revision;
	unsigned int creator_id;
	unsigned int creator_revision;
	unsigned int sequence_number;
	unsigned int validation_status;
};
/*!
 * Helper function to print a db_dimm_config_output to the screen.
 * @ingroup dimm_config_output
 * @param p_dimm_config_output
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_config_output(struct db_dimm_config_output *p_value);
/*!
 * Create a new row in the dimm_config_output table
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_config_output
 *		Pointer to the object to be saved to the dimm_config_output table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_config_output(const PersistentStore *p_ps, struct db_dimm_config_output *p_dimm_config_output);
/*!
 * Get the total number of dimm_config_outputs
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_config_outputs
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_config_output_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_config_outputs
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_config_output
 *		Pointer to an array of dimm_config_output objects that will contain all the dimm_config_outputs
 * @param[in] dimm_config_output_count
 *		Size of p_dimm_config_output
 * @return The number of row (to max of dimm_config_output_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_config_outputs(const PersistentStore *p_ps,
	struct db_dimm_config_output
	*p_dimm_config_output,
	int dimm_config_output_count);
/*!
 * Truncate all the data in the dimm_config_output table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_config_outputs(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_config_output history
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_config_output_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_config_output state
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_config_output to
 * @param[in] p_dimm_config_output
 *		dimm_config_output to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_config_output_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_config_output *p_dimm_config_output);
/*!
 * Return a specific dimm_config_output for a given device_handle
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct dimm_config_output
 * @param[out] p_dimm_config_output
 *		struct to put the dimm_config_output retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_config_output_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_config_output *p_dimm_config_output);
/*!
 * Update a specific dimm_config_output given the original device_handle
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the dimm_config_output to update
 * @param[in] *p_updated_dimm_config_output
 *		structure with new values for the dimm_config_output
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_config_output_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_dimm_config_output *p_updated_dimm_config_output);
/*!
 * Delete a specific dimm_config_output given the device_handle
 * @ingroup dimm_config_output
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_config_output_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_config_output_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_config_output_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_config_output_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_config_output_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_config_output
 *		Structure type for row results
 * @param[in] p_dimm_config_output
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_config_output_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_config_output_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_config_output *p_dimm_config_output,
	int history_id,
	int dimm_config_output_count);
/*!
 * @defgroup dimm_partition_change dimm_partition_change 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_partition_change table
 * @ingroup dimm_partition_change
 */
struct db_dimm_partition_change
{
	unsigned int device_handle;
	int id;
	unsigned int config_table_type;
	unsigned int extension_table_type;
	unsigned int length;
	unsigned long long partition_size;
	unsigned int status;
};
/*!
 * Helper function to print a db_dimm_partition_change to the screen.
 * @ingroup dimm_partition_change
 * @param p_dimm_partition_change
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_partition_change(struct db_dimm_partition_change *p_value);
/*!
 * Create a new row in the dimm_partition_change table
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_partition_change
 *		Pointer to the object to be saved to the dimm_partition_change table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_partition_change(const PersistentStore *p_ps, struct db_dimm_partition_change *p_dimm_partition_change);
/*!
 * Get the total number of dimm_partition_changes
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_partition_changes
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_partition_change_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_partition_changes
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_partition_change
 *		Pointer to an array of dimm_partition_change objects that will contain all the dimm_partition_changes
 * @param[in] dimm_partition_change_count
 *		Size of p_dimm_partition_change
 * @return The number of row (to max of dimm_partition_change_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_partition_changes(const PersistentStore *p_ps,
	struct db_dimm_partition_change
	*p_dimm_partition_change,
	int dimm_partition_change_count);
/*!
 * Truncate all the data in the dimm_partition_change table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_partition_changes(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_partition_change history
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_partition_change_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_partition_change state
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_partition_change to
 * @param[in] p_dimm_partition_change
 *		dimm_partition_change to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_partition_change_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_partition_change *p_dimm_partition_change);
/*!
 * Return a specific dimm_partition_change for a given id
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct dimm_partition_change
 * @param[out] p_dimm_partition_change
 *		struct to put the dimm_partition_change retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_partition_change_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_dimm_partition_change *p_dimm_partition_change);
/*!
 * Update a specific dimm_partition_change given the original id
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the dimm_partition_change to update
 * @param[in] *p_updated_dimm_partition_change
 *		structure with new values for the dimm_partition_change
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_partition_change_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_dimm_partition_change *p_updated_dimm_partition_change);
/*!
 * Delete a specific dimm_partition_change given the id
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_partition_change_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_partition_change_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_partition_change_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_partition_change_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_partition_change_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_partition_change
 *		Structure type for row results
 * @param[in] p_dimm_partition_change
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_partition_change_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_partition_change_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_partition_change *p_dimm_partition_change,
	int history_id,
	int dimm_partition_change_count);
/*!
 * Return the number of dimm_partition_changes for a given dimm_topology.device_handle
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_partition_change and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_partition_change_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of dimm_partition_changes for a given dimm_topology.device_handle
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_partition_change and get all with passed in device_handle
 * @param[out] p_dimm_partition_change
 *		memory to hold the found dimm_partition_changes
 * @param[in]   dimm_partition_change_count
 *		Size of dimm_partition_change array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_partition_changes_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_dimm_partition_change *p_dimm_partition_change,
	int dimm_partition_change_count);
/*!
 * Delete a list of specific dimm_partition_changes for a given dimm_topology.device_handle
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_partition_change and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_partition_change_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * Roll dimm_partition_changes by id to specified max.
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  max_rows
 *		The max table size
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_roll_dimm_partition_changes_by_id(const PersistentStore *p_ps, int max_rows);
/*!
 * Get the max id in the dimm_partition_change table.
 * @ingroup dimm_partition_change
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in,out]  p_max
 *		The max id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_next_dimm_partition_change_id(const PersistentStore *p_ps, int *p_max);
/*!
 * @defgroup dimm_interleave_set dimm_interleave_set 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the dimm_interleave_set table
 * @ingroup dimm_interleave_set
 */
struct db_dimm_interleave_set
{
	int id;
	unsigned int device_handle;
	unsigned int config_table_type;
	unsigned int extension_table_type;
	unsigned int length;
	unsigned int index_id;
	unsigned int dimm_count;
	unsigned int memory_type;
	unsigned int interleave_format;
	unsigned int mirror_enable;
	unsigned int status;
};
/*!
 * Helper function to print a db_dimm_interleave_set to the screen.
 * @ingroup dimm_interleave_set
 * @param p_dimm_interleave_set
 * 		value to print
 * @return
 *		void
 */
void db_print_dimm_interleave_set(struct db_dimm_interleave_set *p_value);
/*!
 * Create a new row in the dimm_interleave_set table
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_dimm_interleave_set
 *		Pointer to the object to be saved to the dimm_interleave_set table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_dimm_interleave_set(const PersistentStore *p_ps, struct db_dimm_interleave_set *p_dimm_interleave_set);
/*!
 * Get the total number of dimm_interleave_sets
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of dimm_interleave_sets
 * @return whether successful or not
 */
enum db_return_codes db_get_dimm_interleave_set_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all dimm_interleave_sets
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_dimm_interleave_set
 *		Pointer to an array of dimm_interleave_set objects that will contain all the dimm_interleave_sets
 * @param[in] dimm_interleave_set_count
 *		Size of p_dimm_interleave_set
 * @return The number of row (to max of dimm_interleave_set_count) on success.  DB_FAILURE on failure.
 */
int db_get_dimm_interleave_sets(const PersistentStore *p_ps,
	struct db_dimm_interleave_set
	*p_dimm_interleave_set,
	int dimm_interleave_set_count);
/*!
 * Truncate all the data in the dimm_interleave_set table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_dimm_interleave_sets(const PersistentStore *p_ps);

/*!
 * delete all entries from dimm_interleave_set history
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_dimm_interleave_set_history(const PersistentStore *p_ps);
 
/*!
 * save dimm_interleave_set state
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the dimm_interleave_set to
 * @param[in] p_dimm_interleave_set
 *		dimm_interleave_set to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_dimm_interleave_set_state(const PersistentStore *p_ps,
	int history_id,
	struct db_dimm_interleave_set *p_dimm_interleave_set);
/*!
 * Return a specific dimm_interleave_set for a given id
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct dimm_interleave_set
 * @param[out] p_dimm_interleave_set
 *		struct to put the dimm_interleave_set retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_interleave_set_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_dimm_interleave_set *p_dimm_interleave_set);
/*!
 * Update a specific dimm_interleave_set given the original id
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the dimm_interleave_set to update
 * @param[in] *p_updated_dimm_interleave_set
 *		structure with new values for the dimm_interleave_set
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_dimm_interleave_set_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_dimm_interleave_set *p_updated_dimm_interleave_set);
/*!
 * Delete a specific dimm_interleave_set given the id
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_interleave_set_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_interleave_set_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_interleave_set_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of dimm_interleave_set_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_dimm_interleave_set_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_dimm_interleave_set
 *		Structure type for row results
 * @param[in] p_dimm_interleave_set
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of dimm_interleave_set_count) on success.  DB_FAILURE on failure.
 */
 int db_get_dimm_interleave_set_history_by_history_id(const PersistentStore *p_ps,
	struct db_dimm_interleave_set *p_dimm_interleave_set,
	int history_id,
	int dimm_interleave_set_count);
/*!
 * Roll dimm_interleave_sets by id to specified max.
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  max_rows
 *		The max table size
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_roll_dimm_interleave_sets_by_id(const PersistentStore *p_ps, int max_rows);
/*!
 * Get the max id in the dimm_interleave_set table.
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in,out]  p_max
 *		The max id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_next_dimm_interleave_set_id(const PersistentStore *p_ps, int *p_max);
/*!
 * Return the number of dimm_interleave_sets for a given dimm_topology.device_handle
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_interleave_set and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_interleave_set_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of dimm_interleave_sets for a given dimm_topology.device_handle
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_interleave_set and get all with passed in device_handle
 * @param[out] p_dimm_interleave_set
 *		memory to hold the found dimm_interleave_sets
 * @param[in]   dimm_interleave_set_count
 *		Size of dimm_interleave_set array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_dimm_interleave_sets_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_dimm_interleave_set *p_dimm_interleave_set,
	int dimm_interleave_set_count);
/*!
 * Delete a list of specific dimm_interleave_sets for a given dimm_topology.device_handle
 * @ingroup dimm_interleave_set
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search dimm_interleave_set and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_dimm_interleave_set_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup interleave_set_dimm_info interleave_set_dimm_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	INTERLEAVE_SET_DIMM_INFO_MODEL_NUM_LEN 21 //!< Max length for model_num
/*!
 * struct representing the interleave_set_dimm_info table
 * @ingroup interleave_set_dimm_info
 */
struct db_interleave_set_dimm_info
{
	int id;
	unsigned int config_table_type;
	unsigned int index_id;
	unsigned int device_handle;
	unsigned int manufacturer;
	unsigned int serial_num;
	char   model_num[INTERLEAVE_SET_DIMM_INFO_MODEL_NUM_LEN];
	unsigned long long offset;
	unsigned long long size;
};
/*!
 * Helper function to print a db_interleave_set_dimm_info to the screen.
 * @ingroup interleave_set_dimm_info
 * @param p_interleave_set_dimm_info
 * 		value to print
 * @return
 *		void
 */
void db_print_interleave_set_dimm_info(struct db_interleave_set_dimm_info *p_value);
/*!
 * Create a new row in the interleave_set_dimm_info table
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_interleave_set_dimm_info
 *		Pointer to the object to be saved to the interleave_set_dimm_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_interleave_set_dimm_info(const PersistentStore *p_ps, struct db_interleave_set_dimm_info *p_interleave_set_dimm_info);
/*!
 * Get the total number of interleave_set_dimm_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of interleave_set_dimm_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_interleave_set_dimm_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all interleave_set_dimm_infos
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_interleave_set_dimm_info
 *		Pointer to an array of interleave_set_dimm_info objects that will contain all the interleave_set_dimm_infos
 * @param[in] interleave_set_dimm_info_count
 *		Size of p_interleave_set_dimm_info
 * @return The number of row (to max of interleave_set_dimm_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_interleave_set_dimm_infos(const PersistentStore *p_ps,
	struct db_interleave_set_dimm_info
	*p_interleave_set_dimm_info,
	int interleave_set_dimm_info_count);
/*!
 * Truncate all the data in the interleave_set_dimm_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_interleave_set_dimm_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from interleave_set_dimm_info history
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_interleave_set_dimm_info_history(const PersistentStore *p_ps);
 
/*!
 * save interleave_set_dimm_info state
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the interleave_set_dimm_info to
 * @param[in] p_interleave_set_dimm_info
 *		interleave_set_dimm_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_interleave_set_dimm_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_interleave_set_dimm_info *p_interleave_set_dimm_info);
/*!
 * Return a specific interleave_set_dimm_info for a given id
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct interleave_set_dimm_info
 * @param[out] p_interleave_set_dimm_info
 *		struct to put the interleave_set_dimm_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_interleave_set_dimm_info_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_interleave_set_dimm_info *p_interleave_set_dimm_info);
/*!
 * Update a specific interleave_set_dimm_info given the original id
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the interleave_set_dimm_info to update
 * @param[in] *p_updated_interleave_set_dimm_info
 *		structure with new values for the interleave_set_dimm_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_interleave_set_dimm_info_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_interleave_set_dimm_info *p_updated_interleave_set_dimm_info);
/*!
 * Delete a specific interleave_set_dimm_info given the id
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_interleave_set_dimm_info_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of interleave_set_dimm_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_interleave_set_dimm_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of interleave_set_dimm_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_interleave_set_dimm_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_interleave_set_dimm_info
 *		Structure type for row results
 * @param[in] p_interleave_set_dimm_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of interleave_set_dimm_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_interleave_set_dimm_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_interleave_set_dimm_info *p_interleave_set_dimm_info,
	int history_id,
	int interleave_set_dimm_info_count);
/*!
 * Roll interleave_set_dimm_infos by id to specified max.
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  max_rows
 *		The max table size
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_roll_interleave_set_dimm_infos_by_id(const PersistentStore *p_ps, int max_rows);
/*!
 * Get the max id in the interleave_set_dimm_info table.
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in,out]  p_max
 *		The max id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_next_interleave_set_dimm_info_id(const PersistentStore *p_ps, int *p_max);
/*!
 * Return the number of interleave_set_dimm_infos for a given dimm_interleave_set.index_id
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  index_id
 *		Search interleave_set_dimm_info and get count for all with passed in index_id
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_interleave_set_dimm_info_count_by_dimm_interleave_set_index_id (const PersistentStore *p_ps,
	const unsigned int index_id, int *p_count);
/*!
 * Return a list of interleave_set_dimm_infos for a given dimm_interleave_set.index_id
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  index_id
 *		Search interleave_set_dimm_info and get all with passed in index_id
 * @param[out] p_interleave_set_dimm_info
 *		memory to hold the found interleave_set_dimm_infos
 * @param[in]   interleave_set_dimm_info_count
 *		Size of interleave_set_dimm_info array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_interleave_set_dimm_infos_by_dimm_interleave_set_index_id(const PersistentStore *p_ps,
	unsigned int index_id,
	struct db_interleave_set_dimm_info *p_interleave_set_dimm_info,
	int interleave_set_dimm_info_count);
/*!
 * Delete a list of specific interleave_set_dimm_infos for a given dimm_interleave_set.index_id
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  index_id
 *		Search interleave_set_dimm_info and get all with passed in index_id
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_interleave_set_dimm_info_by_dimm_interleave_set_index_id(const PersistentStore *p_ps,
	unsigned int index_id);
/*!
 * Return the number of interleave_set_dimm_infos for a given dimm_topology.device_handle
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search interleave_set_dimm_info and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_interleave_set_dimm_info_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of interleave_set_dimm_infos for a given dimm_topology.device_handle
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search interleave_set_dimm_info and get all with passed in device_handle
 * @param[out] p_interleave_set_dimm_info
 *		memory to hold the found interleave_set_dimm_infos
 * @param[in]   interleave_set_dimm_info_count
 *		Size of interleave_set_dimm_info array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_interleave_set_dimm_infos_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_interleave_set_dimm_info *p_interleave_set_dimm_info,
	int interleave_set_dimm_info_count);
/*!
 * Delete a list of specific interleave_set_dimm_infos for a given dimm_topology.device_handle
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search interleave_set_dimm_info and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_interleave_set_dimm_info_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * Clear interleave_set_dimm_info.serial_num for all rows
 * @ingroup interleave_set_dimm_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_clear_interleave_set_dimm_info_serial_num(PersistentStore *p_ps);
/*!
 * @defgroup enable_error_injection_info enable_error_injection_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the enable_error_injection_info table
 * @ingroup enable_error_injection_info
 */
struct db_enable_error_injection_info
{
	unsigned int device_handle;
	unsigned int enable;
};
/*!
 * Helper function to print a db_enable_error_injection_info to the screen.
 * @ingroup enable_error_injection_info
 * @param p_enable_error_injection_info
 * 		value to print
 * @return
 *		void
 */
void db_print_enable_error_injection_info(struct db_enable_error_injection_info *p_value);
/*!
 * Create a new row in the enable_error_injection_info table
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_enable_error_injection_info
 *		Pointer to the object to be saved to the enable_error_injection_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_enable_error_injection_info(const PersistentStore *p_ps, struct db_enable_error_injection_info *p_enable_error_injection_info);
/*!
 * Get the total number of enable_error_injection_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of enable_error_injection_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_enable_error_injection_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all enable_error_injection_infos
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_enable_error_injection_info
 *		Pointer to an array of enable_error_injection_info objects that will contain all the enable_error_injection_infos
 * @param[in] enable_error_injection_info_count
 *		Size of p_enable_error_injection_info
 * @return The number of row (to max of enable_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_enable_error_injection_infos(const PersistentStore *p_ps,
	struct db_enable_error_injection_info
	*p_enable_error_injection_info,
	int enable_error_injection_info_count);
/*!
 * Truncate all the data in the enable_error_injection_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_enable_error_injection_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from enable_error_injection_info history
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_enable_error_injection_info_history(const PersistentStore *p_ps);
 
/*!
 * save enable_error_injection_info state
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the enable_error_injection_info to
 * @param[in] p_enable_error_injection_info
 *		enable_error_injection_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_enable_error_injection_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_enable_error_injection_info *p_enable_error_injection_info);
/*!
 * Return a specific enable_error_injection_info for a given device_handle
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct enable_error_injection_info
 * @param[out] p_enable_error_injection_info
 *		struct to put the enable_error_injection_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_enable_error_injection_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_enable_error_injection_info *p_enable_error_injection_info);
/*!
 * Update a specific enable_error_injection_info given the original device_handle
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the enable_error_injection_info to update
 * @param[in] *p_updated_enable_error_injection_info
 *		structure with new values for the enable_error_injection_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_enable_error_injection_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_enable_error_injection_info *p_updated_enable_error_injection_info);
/*!
 * Delete a specific enable_error_injection_info given the device_handle
 * @ingroup enable_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_enable_error_injection_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of enable_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_enable_error_injection_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of enable_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_enable_error_injection_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_enable_error_injection_info
 *		Structure type for row results
 * @param[in] p_enable_error_injection_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of enable_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_enable_error_injection_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_enable_error_injection_info *p_enable_error_injection_info,
	int history_id,
	int enable_error_injection_info_count);
/*!
 * @defgroup temperature_error_injection_info temperature_error_injection_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the temperature_error_injection_info table
 * @ingroup temperature_error_injection_info
 */
struct db_temperature_error_injection_info
{
	unsigned int device_handle;
	unsigned int temperature;
};
/*!
 * Helper function to print a db_temperature_error_injection_info to the screen.
 * @ingroup temperature_error_injection_info
 * @param p_temperature_error_injection_info
 * 		value to print
 * @return
 *		void
 */
void db_print_temperature_error_injection_info(struct db_temperature_error_injection_info *p_value);
/*!
 * Create a new row in the temperature_error_injection_info table
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_temperature_error_injection_info
 *		Pointer to the object to be saved to the temperature_error_injection_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_temperature_error_injection_info(const PersistentStore *p_ps, struct db_temperature_error_injection_info *p_temperature_error_injection_info);
/*!
 * Get the total number of temperature_error_injection_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of temperature_error_injection_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_temperature_error_injection_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all temperature_error_injection_infos
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_temperature_error_injection_info
 *		Pointer to an array of temperature_error_injection_info objects that will contain all the temperature_error_injection_infos
 * @param[in] temperature_error_injection_info_count
 *		Size of p_temperature_error_injection_info
 * @return The number of row (to max of temperature_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_temperature_error_injection_infos(const PersistentStore *p_ps,
	struct db_temperature_error_injection_info
	*p_temperature_error_injection_info,
	int temperature_error_injection_info_count);
/*!
 * Truncate all the data in the temperature_error_injection_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_temperature_error_injection_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from temperature_error_injection_info history
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_temperature_error_injection_info_history(const PersistentStore *p_ps);
 
/*!
 * save temperature_error_injection_info state
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the temperature_error_injection_info to
 * @param[in] p_temperature_error_injection_info
 *		temperature_error_injection_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_temperature_error_injection_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_temperature_error_injection_info *p_temperature_error_injection_info);
/*!
 * Return a specific temperature_error_injection_info for a given device_handle
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct temperature_error_injection_info
 * @param[out] p_temperature_error_injection_info
 *		struct to put the temperature_error_injection_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_temperature_error_injection_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_temperature_error_injection_info *p_temperature_error_injection_info);
/*!
 * Update a specific temperature_error_injection_info given the original device_handle
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the temperature_error_injection_info to update
 * @param[in] *p_updated_temperature_error_injection_info
 *		structure with new values for the temperature_error_injection_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_temperature_error_injection_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_temperature_error_injection_info *p_updated_temperature_error_injection_info);
/*!
 * Delete a specific temperature_error_injection_info given the device_handle
 * @ingroup temperature_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_temperature_error_injection_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of temperature_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_temperature_error_injection_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of temperature_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_temperature_error_injection_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_temperature_error_injection_info
 *		Structure type for row results
 * @param[in] p_temperature_error_injection_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of temperature_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_temperature_error_injection_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_temperature_error_injection_info *p_temperature_error_injection_info,
	int history_id,
	int temperature_error_injection_info_count);
/*!
 * @defgroup poison_error_injection_info poison_error_injection_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the poison_error_injection_info table
 * @ingroup poison_error_injection_info
 */
struct db_poison_error_injection_info
{
	int id;
	unsigned int device_handle;
	unsigned long long dpa_address;
};
/*!
 * Helper function to print a db_poison_error_injection_info to the screen.
 * @ingroup poison_error_injection_info
 * @param p_poison_error_injection_info
 * 		value to print
 * @return
 *		void
 */
void db_print_poison_error_injection_info(struct db_poison_error_injection_info *p_value);
/*!
 * Create a new row in the poison_error_injection_info table
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_poison_error_injection_info
 *		Pointer to the object to be saved to the poison_error_injection_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_poison_error_injection_info(const PersistentStore *p_ps, struct db_poison_error_injection_info *p_poison_error_injection_info);
/*!
 * Get the total number of poison_error_injection_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of poison_error_injection_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_poison_error_injection_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all poison_error_injection_infos
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_poison_error_injection_info
 *		Pointer to an array of poison_error_injection_info objects that will contain all the poison_error_injection_infos
 * @param[in] poison_error_injection_info_count
 *		Size of p_poison_error_injection_info
 * @return The number of row (to max of poison_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_poison_error_injection_infos(const PersistentStore *p_ps,
	struct db_poison_error_injection_info
	*p_poison_error_injection_info,
	int poison_error_injection_info_count);
/*!
 * Truncate all the data in the poison_error_injection_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_poison_error_injection_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from poison_error_injection_info history
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_poison_error_injection_info_history(const PersistentStore *p_ps);
 
/*!
 * save poison_error_injection_info state
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the poison_error_injection_info to
 * @param[in] p_poison_error_injection_info
 *		poison_error_injection_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_poison_error_injection_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_poison_error_injection_info *p_poison_error_injection_info);
/*!
 * Return a specific poison_error_injection_info for a given id
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct poison_error_injection_info
 * @param[out] p_poison_error_injection_info
 *		struct to put the poison_error_injection_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_poison_error_injection_info_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_poison_error_injection_info *p_poison_error_injection_info);
/*!
 * Update a specific poison_error_injection_info given the original id
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the poison_error_injection_info to update
 * @param[in] *p_updated_poison_error_injection_info
 *		structure with new values for the poison_error_injection_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_poison_error_injection_info_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_poison_error_injection_info *p_updated_poison_error_injection_info);
/*!
 * Delete a specific poison_error_injection_info given the id
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_poison_error_injection_info_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of poison_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_poison_error_injection_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of poison_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_poison_error_injection_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_poison_error_injection_info
 *		Structure type for row results
 * @param[in] p_poison_error_injection_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of poison_error_injection_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_poison_error_injection_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_poison_error_injection_info *p_poison_error_injection_info,
	int history_id,
	int poison_error_injection_info_count);
/*!
 * Return the number of poison_error_injection_infos for a given dimm_topology.device_handle
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search poison_error_injection_info and get count for all with passed in device_handle
 * @param[out]   p_count
 *		Resulting count
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_poison_error_injection_info_count_by_dimm_topology_device_handle (const PersistentStore *p_ps,
	const unsigned int device_handle, int *p_count);
/*!
 * Return a list of poison_error_injection_infos for a given dimm_topology.device_handle
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search poison_error_injection_info and get all with passed in device_handle
 * @param[out] p_poison_error_injection_info
 *		memory to hold the found poison_error_injection_infos
 * @param[in]   poison_error_injection_info_count
 *		Size of poison_error_injection_info array passed in
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_poison_error_injection_infos_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle,
	struct db_poison_error_injection_info *p_poison_error_injection_info,
	int poison_error_injection_info_count);
/*!
 * Delete a list of specific poison_error_injection_infos for a given dimm_topology.device_handle
 * @ingroup poison_error_injection_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in]  device_handle
 *		Search poison_error_injection_info and get all with passed in device_handle
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_poison_error_injection_info_by_dimm_topology_device_handle(const PersistentStore *p_ps,
	unsigned int device_handle);
/*!
 * @defgroup software_trigger_info software_trigger_info 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the software_trigger_info table
 * @ingroup software_trigger_info
 */
struct db_software_trigger_info
{
	unsigned int device_handle;
	unsigned int die_sparing_trigger;
	unsigned int user_spare_block_alarm_trip_trigger;
	unsigned int fatal_error_trigger;
};
/*!
 * Helper function to print a db_software_trigger_info to the screen.
 * @ingroup software_trigger_info
 * @param p_software_trigger_info
 * 		value to print
 * @return
 *		void
 */
void db_print_software_trigger_info(struct db_software_trigger_info *p_value);
/*!
 * Create a new row in the software_trigger_info table
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_software_trigger_info
 *		Pointer to the object to be saved to the software_trigger_info table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_software_trigger_info(const PersistentStore *p_ps, struct db_software_trigger_info *p_software_trigger_info);
/*!
 * Get the total number of software_trigger_infos
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of software_trigger_infos
 * @return whether successful or not
 */
enum db_return_codes db_get_software_trigger_info_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all software_trigger_infos
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_software_trigger_info
 *		Pointer to an array of software_trigger_info objects that will contain all the software_trigger_infos
 * @param[in] software_trigger_info_count
 *		Size of p_software_trigger_info
 * @return The number of row (to max of software_trigger_info_count) on success.  DB_FAILURE on failure.
 */
int db_get_software_trigger_infos(const PersistentStore *p_ps,
	struct db_software_trigger_info
	*p_software_trigger_info,
	int software_trigger_info_count);
/*!
 * Truncate all the data in the software_trigger_info table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_software_trigger_infos(const PersistentStore *p_ps);

/*!
 * delete all entries from software_trigger_info history
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_software_trigger_info_history(const PersistentStore *p_ps);
 
/*!
 * save software_trigger_info state
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the software_trigger_info to
 * @param[in] p_software_trigger_info
 *		software_trigger_info to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_software_trigger_info_state(const PersistentStore *p_ps,
	int history_id,
	struct db_software_trigger_info *p_software_trigger_info);
/*!
 * Return a specific software_trigger_info for a given device_handle
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct software_trigger_info
 * @param[out] p_software_trigger_info
 *		struct to put the software_trigger_info retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_software_trigger_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_software_trigger_info *p_software_trigger_info);
/*!
 * Update a specific software_trigger_info given the original device_handle
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the software_trigger_info to update
 * @param[in] *p_updated_software_trigger_info
 *		structure with new values for the software_trigger_info
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_software_trigger_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_software_trigger_info *p_updated_software_trigger_info);
/*!
 * Delete a specific software_trigger_info given the device_handle
 * @ingroup software_trigger_info
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_software_trigger_info_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of software_trigger_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_software_trigger_info_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of software_trigger_info_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_software_trigger_info_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_software_trigger_info
 *		Structure type for row results
 * @param[in] p_software_trigger_info
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of software_trigger_info_count) on success.  DB_FAILURE on failure.
 */
 int db_get_software_trigger_info_history_by_history_id(const PersistentStore *p_ps,
	struct db_software_trigger_info *p_software_trigger_info,
	int history_id,
	int software_trigger_info_count);
/*!
 * @defgroup performance performance 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	PERFORMANCE_DIMM_UID_LEN 37 //!< Max length for dimm_uid
/*!
 * struct representing the performance table
 * @ingroup performance
 */
struct db_performance
{
	int id;
	char   dimm_uid[PERFORMANCE_DIMM_UID_LEN];
	unsigned long long time;
	unsigned long long bytes_read;
	unsigned long long bytes_written;
	unsigned long long read_reqs;
	unsigned long long host_write_cmds;
	unsigned long long block_reads;
	unsigned long long block_writes;
};
/*!
 * Helper function to print a db_performance to the screen.
 * @ingroup performance
 * @param p_performance
 * 		value to print
 * @return
 *		void
 */
void db_print_performance(struct db_performance *p_value);
/*!
 * Create a new row in the performance table
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_performance
 *		Pointer to the object to be saved to the performance table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_performance(const PersistentStore *p_ps, struct db_performance *p_performance);
/*!
 * Get the total number of performances
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of performances
 * @return whether successful or not
 */
enum db_return_codes db_get_performance_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all performances
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_performance
 *		Pointer to an array of performance objects that will contain all the performances
 * @param[in] performance_count
 *		Size of p_performance
 * @return The number of row (to max of performance_count) on success.  DB_FAILURE on failure.
 */
int db_get_performances(const PersistentStore *p_ps,
	struct db_performance
	*p_performance,
	int performance_count);
/*!
 * Truncate all the data in the performance table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_performances(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from performance history
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_performance_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save performance state
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the performance to
 * @param[in] p_performance
 *		performance to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_performance_state(const PersistentStore *p_ps,
	int history_id,
	struct db_performance *p_performance);
/*!
 * Return a specific performance for a given id
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct performance
 * @param[out] p_performance
 *		struct to put the performance retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_performance_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_performance *p_performance);
/*!
 * Update a specific performance given the original id
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the performance to update
 * @param[in] *p_updated_performance
 *		structure with new values for the performance
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_performance_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_performance *p_updated_performance);
/*!
 * Delete a specific performance given the id
 * @ingroup performance
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_performance_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of performance_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_performance_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of performance_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_performance_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_performance
 *		Structure type for row results
 * @param[in] p_performance
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of performance_count) on success.  DB_FAILURE on failure.
 */
 int db_get_performance_history_by_history_id(const PersistentStore *p_ps,
	struct db_performance *p_performance,
	int history_id,
	int performance_count);
/*!
 * @defgroup driver_metadata_check_diag_result driver_metadata_check_diag_result 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
#define	DRIVER_METADATA_CHECK_DIAG_RESULT_NS_UID_LEN 37 //!< Max length for ns_uid
/*!
 * struct representing the driver_metadata_check_diag_result table
 * @ingroup driver_metadata_check_diag_result
 */
struct db_driver_metadata_check_diag_result
{
	int id;
	int result_type;
	char   ns_uid[DRIVER_METADATA_CHECK_DIAG_RESULT_NS_UID_LEN];
	unsigned int device_handle;
	unsigned int health_flag;
};
/*!
 * Helper function to print a db_driver_metadata_check_diag_result to the screen.
 * @ingroup driver_metadata_check_diag_result
 * @param p_driver_metadata_check_diag_result
 * 		value to print
 * @return
 *		void
 */
void db_print_driver_metadata_check_diag_result(struct db_driver_metadata_check_diag_result *p_value);
/*!
 * Create a new row in the driver_metadata_check_diag_result table
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_driver_metadata_check_diag_result
 *		Pointer to the object to be saved to the driver_metadata_check_diag_result table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_driver_metadata_check_diag_result(const PersistentStore *p_ps, struct db_driver_metadata_check_diag_result *p_driver_metadata_check_diag_result);
/*!
 * Get the total number of driver_metadata_check_diag_results
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of driver_metadata_check_diag_results
 * @return whether successful or not
 */
enum db_return_codes db_get_driver_metadata_check_diag_result_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all driver_metadata_check_diag_results
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_driver_metadata_check_diag_result
 *		Pointer to an array of driver_metadata_check_diag_result objects that will contain all the driver_metadata_check_diag_results
 * @param[in] driver_metadata_check_diag_result_count
 *		Size of p_driver_metadata_check_diag_result
 * @return The number of row (to max of driver_metadata_check_diag_result_count) on success.  DB_FAILURE on failure.
 */
int db_get_driver_metadata_check_diag_results(const PersistentStore *p_ps,
	struct db_driver_metadata_check_diag_result
	*p_driver_metadata_check_diag_result,
	int driver_metadata_check_diag_result_count);
/*!
 * Truncate all the data in the driver_metadata_check_diag_result table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_driver_metadata_check_diag_results(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from driver_metadata_check_diag_result history
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_driver_metadata_check_diag_result_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save driver_metadata_check_diag_result state
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the driver_metadata_check_diag_result to
 * @param[in] p_driver_metadata_check_diag_result
 *		driver_metadata_check_diag_result to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_driver_metadata_check_diag_result_state(const PersistentStore *p_ps,
	int history_id,
	struct db_driver_metadata_check_diag_result *p_driver_metadata_check_diag_result);
/*!
 * Return a specific driver_metadata_check_diag_result for a given id
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id to identify the correct driver_metadata_check_diag_result
 * @param[out] p_driver_metadata_check_diag_result
 *		struct to put the driver_metadata_check_diag_result retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_driver_metadata_check_diag_result_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_driver_metadata_check_diag_result *p_driver_metadata_check_diag_result);
/*!
 * Update a specific driver_metadata_check_diag_result given the original id
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 * 		id points to the driver_metadata_check_diag_result to update
 * @param[in] *p_updated_driver_metadata_check_diag_result
 *		structure with new values for the driver_metadata_check_diag_result
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_driver_metadata_check_diag_result_by_id(const PersistentStore *p_ps,
	const int id,
	struct db_driver_metadata_check_diag_result *p_updated_driver_metadata_check_diag_result);
/*!
 * Delete a specific driver_metadata_check_diag_result given the id
 * @ingroup driver_metadata_check_diag_result
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] id
 *		id points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_driver_metadata_check_diag_result_by_id(const PersistentStore *p_ps,
	const int id);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of driver_metadata_check_diag_result_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_driver_metadata_check_diag_result_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of driver_metadata_check_diag_result_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_driver_metadata_check_diag_result_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_driver_metadata_check_diag_result
 *		Structure type for row results
 * @param[in] p_driver_metadata_check_diag_result
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of driver_metadata_check_diag_result_count) on success.  DB_FAILURE on failure.
 */
 int db_get_driver_metadata_check_diag_result_history_by_history_id(const PersistentStore *p_ps,
	struct db_driver_metadata_check_diag_result *p_driver_metadata_check_diag_result,
	int history_id,
	int driver_metadata_check_diag_result_count);
/*!
 * @defgroup boot_status_register boot_status_register 
 * @ingroup db_schema
 */
 // Lengths for strings and arrays
/*!
 * struct representing the boot_status_register table
 * @ingroup boot_status_register
 */
struct db_boot_status_register
{
	unsigned int device_handle;
	unsigned long long bsr;
};
/*!
 * Helper function to print a db_boot_status_register to the screen.
 * @ingroup boot_status_register
 * @param p_boot_status_register
 * 		value to print
 * @return
 *		void
 */
void db_print_boot_status_register(struct db_boot_status_register *p_value);
/*!
 * Create a new row in the boot_status_register table
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] p_boot_status_register
 *		Pointer to the object to be saved to the boot_status_register table
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_add_boot_status_register(const PersistentStore *p_ps, struct db_boot_status_register *p_boot_status_register);
/*!
 * Get the total number of boot_status_registers
 * @param[in] p_ps
 *		Pointer to the instance of the PersistentStore
 * @param[out] p_count
 * 		Set to the number of boot_status_registers
 * @return whether successful or not
 */
enum db_return_codes db_get_boot_status_register_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all boot_status_registers
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] p_boot_status_register
 *		Pointer to an array of boot_status_register objects that will contain all the boot_status_registers
 * @param[in] boot_status_register_count
 *		Size of p_boot_status_register
 * @return The number of row (to max of boot_status_register_count) on success.  DB_FAILURE on failure.
 */
int db_get_boot_status_registers(const PersistentStore *p_ps,
	struct db_boot_status_register
	*p_boot_status_register,
	int boot_status_register_count);
/*!
 * Truncate all the data in the boot_status_register table
 * @ingroup 
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */	
enum db_return_codes db_delete_all_boot_status_registers(const PersistentStore *p_ps);

#if 0
//NON-HISTORY TABLE

/*!
 * delete all entries from boot_status_register history
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @return return_code whether or not it was successful
 */
 enum db_return_codes db_delete_boot_status_register_history(const PersistentStore *p_ps);
 
#endif

/*!
 * save boot_status_register state
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		ID of the history to add the boot_status_register to
 * @param[in] p_boot_status_register
 *		boot_status_register to save to history
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_save_boot_status_register_state(const PersistentStore *p_ps,
	int history_id,
	struct db_boot_status_register *p_boot_status_register);
/*!
 * Return a specific boot_status_register for a given device_handle
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle to identify the correct boot_status_register
 * @param[out] p_boot_status_register
 *		struct to put the boot_status_register retrieved
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_get_boot_status_register_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_boot_status_register *p_boot_status_register);
/*!
 * Update a specific boot_status_register given the original device_handle
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 * 		device_handle points to the boot_status_register to update
 * @param[in] *p_updated_boot_status_register
 *		structure with new values for the boot_status_register
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_update_boot_status_register_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle,
	struct db_boot_status_register *p_updated_boot_status_register);
/*!
 * Delete a specific boot_status_register given the device_handle
 * @ingroup boot_status_register
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] device_handle
 *		device_handle points to the record to delete
 * @return return_code whether or not it was successful
 */
enum db_return_codes db_delete_boot_status_register_by_device_handle(const PersistentStore *p_ps,
	const unsigned int device_handle);
/*!
 * Return number of matching history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] history_id
 *		history_id of rows to count
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of boot_status_register_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_boot_status_register_history_by_history_id_count(const PersistentStore *p_ps, 
	int history_id,
	int *p_count);
/*!
 * Return number of history rows
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] count
 *		count of rows matching this history_id
 * @return The number of row (to max of boot_status_register_count) on success.  DB_FAILURE on failure.
 */
 enum db_return_codes db_get_boot_status_register_history_count(const PersistentStore *p_ps, int *p_count);
/*!
 * Return all rows of matching custom sql
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[out] struct db_boot_status_register
 *		Structure type for row results
 * @param[in] p_boot_status_register
 *		Pointer to memory to hold row results
 * @param[in] history_id
 *		history_id of rows to return
 * @return The number of row (to max of boot_status_register_count) on success.  DB_FAILURE on failure.
 */
 int db_get_boot_status_register_history_by_history_id(const PersistentStore *p_ps,
	struct db_boot_status_register *p_boot_status_register,
	int history_id,
	int boot_status_register_count);
/*!
 * Delete all history
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @ingroup db_schema
 */
enum db_return_codes db_clear_history(PersistentStore *p_ps);
/*!
 * Delete all state tables
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @ingroup db_schema
 */
enum db_return_codes db_clear_state(PersistentStore *p_ps);
/*!
 * Delete all history
 * @param[in] p_ps
 *		Pointer to the PersistentStore
 * @param[in] max
 * 		Maximum number of histories to keep
 * @ingroup db_schema
 */
enum db_return_codes db_roll_history(PersistentStore *p_ps, int max);
/*!
 * Call sqlite3_update_hook
 * Done here to keep all the persistent store -> db access in this file.
 * @param xCallback
 *		callback to send to sqlite3_update_hook
 */
void update_sqlite3_hook(PersistentStore *p_ps, void (*xCallback)(void*,int,char const *,char const *, long long));
#ifdef __cplusplus
}
#endif
#endif /* _SCHEMA_H_ */