h01698
s 00004/00003/00116
d D 1.9 02/02/23 19:44:36 shannon 10 9
c call setDoOutput on URLConnection before returning OutputStream - bug 4505282
e
s 00006/00016/00113
d D 1.8 99/12/06 16:33:43 shannon 9 8
c Update copyright for SCSL release
e
s 00030/00031/00099
d D 1.7 99/03/25 17:35:01 shannon 8 7
c clean up code and javadocs
e
s 00013/00013/00117
d D 1.6 98/02/20 19:32:37 miltonb 7 6
c edit 0.6 version
e
s 00031/00015/00099
d D 1.5 98/02/05 11:10:18 bhc 6 5
c JavaDocs cleaned up..
c 
e
s 00030/00018/00084
d D 1.4 98/01/22 13:45:37 bhc 5 4
c clean up javadocs, change getName to return URL.getFile()
c 
e
s 00010/00001/00092
d D 1.3 97/12/09 10:36:53 bhc 4 3
c added getURL 
e
s 00001/00001/00092
d D 1.2 97/12/08 08:13:13 bhc 3 1
c made this a public class
e
s 00000/00000/00000
d R 1.2 97/12/08 07:48:06 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/URLDataSource.java
c Name history : 1 0 src/classes/javax/activation/URLDataSource.java
e
s 00093/00000/00000
d D 1.1 97/12/08 07:48:05 bhc 1 0
c date and time created 97/12/08 07:48:05 by bhc
e
u
U
f e 0
t
T
I 1
/*
D 7
 * %W% %E%
E 7
I 7
D 8
 * @(#)URLDataSource.java	1.5 98/02/05
E 7
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 8
I 8
D 9
 * %W%	%E%
E 9
I 9
 * %W% %E%
E 9
 *
D 9
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 8
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 8
 * 
E 8
I 8
 *
E 8
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 8
 * 
E 8
I 8
 *
E 9
I 9
D 10
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 10
I 10
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
E 10
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 9
E 8
 */
I 8

E 8
package javax.activation;

import java.net.URL;
import java.net.URLConnection;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

D 8
//////////////////////////////////////////////////////////////////////////
E 8
/**
D 5
 * The URLConnectionDataSource class provides a DataSource wrapper around
 * the URLConnection class which allows for some URL support in the DataHandler
 * class.
E 5
I 5
D 8
 * The URLDataSource class provides an object that wraps a <code>URL</code> 
E 8
I 8
 * The URLDataSource class provides an object that wraps a <code>URL</code>
E 8
D 7
 * object in a DataSource interface. This class allows simplified handling
D 6
 * data described by URL's within the JavaBeans Activation Framework as
 * this class can be used to create new DataHandlers. NOTE: The <code>
 * DataHandler</code> object will internally create a <code>URLDataSource
 * </code> when it is constructed with a <code>URL</code>.
E 6
I 6
 * of data described by URL's within the JavaBeans(tm) Activation Framework as
 * this class can be used to create new DataHandlers. <i>NOTE: The
 * DataHandler object will internally create a URLDataSource
 *  when it is constructed with a URL.</i>
E 7
I 7
 * object in a DataSource interface. URLDataSource simplifies the handling
D 8
 * of data described by URLs within the JavaBeans(tm) Activation Framework 
E 8
I 8
 * of data described by URLs within the JavaBeans Activation Framework
E 8
 * because this class can be used to create new DataHandlers. <i>NOTE: The
 * DataHandler object creates a URLDataSource internally,
 * when it is constructed with a URL.</i>
E 7
 *
 * @see javax.activation.DataSource
 * @see javax.activation.DataHandler
E 6
E 5
 */
D 3
class URLDataSource implements DataSource {
E 3
I 3
public class URLDataSource implements DataSource {
E 3
    private URL url = null;
    private URLConnection url_conn = null;
D 8
    
E 8
I 8

E 8
    /**
D 5
     * The constructor for URLConnectionDataSource. It takes a 
     * URLConnectionDataSource. It takes a 
E 5
I 5
D 6
     * The constructor for URLDataSource. It takes a 
E 5
     * URL which it will lazily retrieve the URLConnection from.
I 5
     * @param URL
E 6
I 6
D 7
     * The constructor for URLDataSource. The URLDataSource class will
E 7
I 7
     * URLDataSource constructor. The URLDataSource class will
E 7
     * not open a connection to the URL until a method requiring it
     * to do so is called.
     *
     * @param url The URL to be encapsulated in this object.
E 6
E 5
     */
    public URLDataSource(URL url) {
	this.url = url;
    }

I 5
    /**
D 6
     * Returns the value of the content-type header field of the
     * URL. (calls the URL's URLConnection.getContentType method)
     * If this value cannot be obtained, it returns the default
     * value which is "application/octet-stream".
E 6
I 6
D 7
     * Returns the value of the content-type header field 
     * of the URL. (calls the URL's URLConnection.getContentType method
     * after retrieving a URLConnection object.)
     * <i>Note: this method will attempt to call the openConnection method on
E 7
I 7
     * Returns the value of the URL content-type header field.
D 8
     * It calls the URL's URLConnection.getContentType method
E 8
I 8
     * It calls the URL's <code>URLConnection.getContentType</code> method
E 8
     * after retrieving a URLConnection object.
D 8
     * <i>Note: this method attempts to call the openConnection method on
E 7
     * the URL. If this method fails, or if a content type is not
D 7
     * returned from the URLConnection, "application/octet-stream"
     * is returned as the content type.</i>
E 7
I 7
     * returned from the URLConnection, getContentType returns 
     * "application/octet-stream" as the content type.</i> 
E 8
I 8
     * <i>Note: this method attempts to call the <code>openConnection</code>
     * method on the URL. If this method fails, or if a content type is not
     * returned from the URLConnection, getContentType returns
     * "application/octet-stream" as the content type.</i>
     *
E 8
E 7
E 6
     * @return the content type.
     */
E 5
D 8
    public String getContentType(){
E 8
I 8
    public String getContentType() {
E 8
I 5
	String type = null;

E 5
	try {
D 8
	    if(url_conn == null)
E 8
I 8
	    if (url_conn == null)
E 8
		url_conn = url.openConnection();
D 5
	} catch(IOException e){ 
	    e.printStackTrace();
	}
E 5
I 5
D 8
	} catch(IOException e){	}
E 8
I 8
	} catch (IOException e) { }
E 8
E 5
	
D 8
	if(url_conn != null)
E 8
I 8
	if (url_conn != null)
E 8
D 5
	    return url_conn.getContentType();
	else
	    return null;
E 5
I 5
	    type = url_conn.getContentType();

D 8
	if(type == null)
E 8
I 8
	if (type == null)
E 8
	    type = "application/octet-stream";
	
	return type;
E 5
    }

    /**
D 5
     * The getName method from DataSource, always returns null
     * for now.
E 5
I 5
     * Calls the <code>getFile</code> method on the URL used to
     * instantiate the object.
I 8
     *
E 8
D 6
     * @return the name.
E 6
I 6
     * @return the result of calling the URL's getFile method.
E 6
E 5
     */
D 8
    public String getName(){ 
E 8
I 8
    public String getName() {
E 8
D 5
	return null;
E 5
I 5
	return url.getFile();
E 5
    }
D 8
    
E 8
I 8

E 8
    /**
D 5
     * The getOutputStream method from DataSource
E 5
I 5
D 6
     * The getOutputStream method from the URL.
E 6
I 6
D 8
     * The getInputStream method from the URL. Calls the openStream
     * method on the URL.
E 8
I 8
     * The getInputStream method from the URL. Calls the
     * <code>openStream</code> method on the URL.
E 8
     *
     * @return the InputStream.
D 8
     *
E 8
E 6
E 5
     */
    public InputStream getInputStream() throws IOException {
D 6
	// get the url connection if it is available
E 6
	return url.openStream();
    }

    /**
D 5
     * The getOutputStream method from DataSource
E 5
I 5
D 6
     * The getOutputStream method from the URL.
E 6
I 6
     * The getOutputStream method from the URL. First an attempt is
     * made to get the URLConnection object for the URL. If that
     * succeeds, the getOutputStream method on the URLConnection
     * is returned.
D 8
     * 
E 8
I 8
     *
E 8
     * @return the OutputStream.
E 6
E 5
     */
    public OutputStream getOutputStream() throws IOException {
	// get the url connection if it is available
	url_conn = url.openConnection();
	
D 8
	if(url_conn != null)
E 8
I 8
D 10
	if (url_conn != null)
E 10
I 10
	if (url_conn != null) {
	    url_conn.setDoOutput(true);
E 10
E 8
	    return url_conn.getOutputStream();
D 10
	else
E 10
I 10
	} else
E 10
	    return null;
D 5

	
E 5
    }
D 4
    
E 4
I 4

D 8

E 8
    /**
D 8
     * Return the URL used to create this DataSource
E 8
I 8
     * Return the URL used to create this DataSource.
E 8
     *
     * @return The URL.
     */
D 8
    public URL getURL(){
E 8
I 8
    public URL getURL() {
E 8
	return url;
    }
E 4
}
D 8

E 8
E 1
