h22459
s 00000/00000/00000
d R 1.2 70/01/01 00:00:02 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 src/share/classes/javax/activation/SecuritySupport.java
e
s 00088/00000/00000
d D 1.1 02/03/10 20:01:56 shannon 1 0
c date and time created 02/03/10 20:01:56 by shannon
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc. 
 * Use is subject to license terms.
 *
 */

package javax.activation;

import java.lang.reflect.*;
import java.net.*;
import java.io.*;

/**
 * Base class with security related methods that work on JDK 1.1.
 */
class SecuritySupport {

    /*
     * Make this of type Object so that the verifier won't try to
     * prove its type, thus possibly trying to load the SecuritySupport12
     * class.
     */
    private static final Object securitySupport;

    static {
	SecuritySupport ss = null;
	try {
	    Class c = Class.forName("java.security.AccessController");
	    // if that worked, we're on 1.2.
	    /*
	    // don't reference the class explicitly so it doesn't
	    // get dragged in accidentally.
	    c = Class.forName( "javax.activation.SecuritySupport12");
	    Constructor cons = c.getConstructor(new Class[] { });
	    ss = (SecuritySupport)cons.newInstance(new Object[] { });
	    */
	    /*
	     * Unfortunately, we can't load the class using reflection
	     * because the class is package private.  And the class has
	     * to be package private so the APIs aren't exposed to other
	     * code that could use them to circumvent security.  Thus,
	     * we accept the risk that the direct reference might fail
	     * on some JDK 1.1 JVMs, even though we would never execute
	     * this code in such a case.  Sigh...
	     */
	    ss = new SecuritySupport12();
	} catch (Exception ex) {
	    // ignore it
	} finally {
	    if (ss == null)
		ss = new SecuritySupport();
	    securitySupport = ss;
	}
    }

    /**
     * Return an appropriate instance of this class, depending on whether
     * we're on a JDK 1.1 or J2SE 1.2 (or later) system.
     */
    public static SecuritySupport getInstance() {
	return (SecuritySupport)securitySupport;
    }

    public ClassLoader getContextClassLoader() {
	return null;
    }

    public InputStream getResourceAsStream(Class c, String name)
				throws IOException {
	return c.getResourceAsStream(name);
    }

    public URL[] getResources(ClassLoader cl, String name) {
	return null;
    }

    public URL[] getSystemResources(String name) {
	return null;
    }

    public InputStream openStream(URL url) throws IOException {
	return url.openStream();
    }
}
E 1
