h38030
s 00005/00016/00096
d D 1.6 99/12/06 16:33:41 shannon 7 6
c Update copyright for SCSL release
e
s 00040/00025/00072
d D 1.5 99/03/25 17:37:37 shannon 6 5
c clean up code and javadocs; add security check when setting
c default file type map
e
s 00006/00000/00091
d D 1.4 98/02/06 15:26:47 bhc 5 4
c javadoc overhaul
e
s 00032/00004/00059
d D 1.3 98/02/06 10:23:07 bhc 4 3
c JavaDoc updates
c 
e
s 00009/00002/00054
d D 1.2 97/12/09 10:36:18 bhc 3 1
c changed getDefaultMap to getDefaultFileTypeMap
e
s 00000/00000/00000
d R 1.2 97/12/08 07:30:42 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/FileTypeMap.java
c Name history : 1 0 src/classes/javax/activation/FileTypeMap.java
e
s 00056/00000/00000
d D 1.1 97/12/08 07:30:41 bhc 1 0
c date and time created 97/12/08 07:30:41 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 6
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
E 6
 *
I 6
D 7
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 6
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * @author Bart Calder
E 7
I 7
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 7
 */

package javax.activation;

import java.io.File;

I 4
D 6
/**  
E 6
I 6
/**
E 6
 * The FileTypeMap is an abstract class that provides a data typing
D 6
 * interface based on a file. Implementations of this class will
E 6
I 6
 * interface for files. Implementations of this class will
E 6
 * implement the getContentType methods which will derive a content
D 6
 * type from a filename or a file object. FileTypeMaps could use any
 * scheme to determine the data type from examining the file extension
E 6
I 6
 * type from a file name or a File object. FileTypeMaps could use any
 * scheme to determine the data type, from examining the file extension
E 6
 * of a file (like the MimetypesFileTypeMap) to opening the file and
D 6
 * trying to derive its type from the contents of the file. The 
 * FileDataSource class uses the MimetypesFileTypeMap (and implementation
 * of FileTypeMap) to determine the content type of files.
 * 
E 6
I 6
 * trying to derive its type from the contents of the file. The
 * FileDataSource class uses the default FileTypeMap (a MimetypesFileTypeMap
 * unless changed) to determine the content type of files.
 *
E 6
 * @see javax.activation.FileTypeMap
 * @see javax.activation.FileDataSource
 * @see javax.activation.MimetypesFileTypeMap
 */

E 4
public abstract class FileTypeMap {

    private static FileTypeMap defaultMap = null;

    /**
I 5
     * The default constructor.
     */
D 6
    public FileTypeMap(){
E 6
I 6
    public FileTypeMap() {
E 6
	super();
    }
I 6

E 6
    /**
E 5
     * Return the type of the file object. This method should
D 4
     * always return a valid MIME type.
E 4
I 4
D 6
     * always return a valid MIME type.  
     * 
E 6
I 6
     * always return a valid MIME type.
     *
E 6
     * @param f A file to be typed.
     * @return The content type.
E 4
     */
D 4
    abstract public String getContentType(File f);
E 4
I 4
    abstract public String getContentType(File file);
E 4

    /**
D 6
     * Return the type of the file passed inThis method should
E 6
I 6
     * Return the type of the file passed in.  This method should
E 6
     * always return a valid MIME type.
I 4
     *
     * @param filename the pathname of the file.
     * @return The content type.
E 4
     */
    abstract public String getContentType(String filename);

D 3
    public static void setDefaultMap(FileTypeMap map){
E 3
I 3
    /**
D 6
     * Sets the default FileTypeMap for the system. This instance 
E 6
I 6
     * Sets the default FileTypeMap for the system. This instance
E 6
     * will be returned to callers of getDefaultFileTypeMap.
I 4
     *
     * @param map The FileTypeMap.
I 6
     * @exception SecurityException if the caller doesn't have permission
     *					to change the default
E 6
E 4
     */
D 6
    public static void setDefaultFileTypeMap(FileTypeMap map){
E 6
I 6
    public static void setDefaultFileTypeMap(FileTypeMap map) {
	SecurityManager security = System.getSecurityManager();
	if (security != null) {
	    try {
		// if it's ok with the SecurityManager, it's ok with me...
		security.checkSetFactory();
	    } catch (SecurityException ex) {
		// otherwise, we also allow it if this code and the
		// factory come from the same class loader (e.g.,
		// the JAF classes were loaded with the applet classes).
		if (FileTypeMap.class.getClassLoader() !=
			map.getClass().getClassLoader())
		    throw ex;
	    }
	}
E 6
E 3
	defaultMap = map;	
    }
D 6
    
E 6
I 6

E 6
D 3
    public static FileTypeMap getDefaultMap() {
E 3
I 3
    /**
     * Return the default FileTypeMap for the system.
I 4
D 6
     * If a call to setDefaultFileTypeMap is called, return
     * that instance, otherwise return an instance of 
     * MimetypesFileTypeMap.
E 6
I 6
     * If setDefaultFileTypeMap was called, return
     * that instance, otherwise return an instance of
     * <code>MimetypesFileTypeMap</code>.
E 6
     *
     * @return The default FileTypeMap
     * @see javax.activation.FileTypeMap#setDefaultFileTypeMap
E 4
     */
    public static FileTypeMap getDefaultFileTypeMap() {
E 3
D 6
	if(defaultMap != null)
	    return defaultMap;
	else {
E 6
I 6
	// XXX - probably should be synchronized
	if (defaultMap == null)
E 6
	    defaultMap = new MimetypesFileTypeMap();
D 6
	    return defaultMap;
	}
E 6
I 6
	return defaultMap;
E 6
D 4
	    

E 4
    }
D 6

E 6
}
E 1
