h39197
s 00006/00017/00106
d D 1.16 99/12/06 16:33:39 shannon 17 16
c Update copyright for SCSL release
e
s 00003/00003/00120
d D 1.15 99/05/21 13:49:16 shannon 16 15
c minor javadoc polish
e
s 00008/00001/00115
d D 1.14 99/05/11 09:19:59 shannon 15 14
c add missing javadoc @param and @return clauses
e
s 00016/00000/00100
d D 1.13 99/03/25 17:35:53 shannon 14 13
c add security check when setting default command map
e
s 00032/00030/00068
d D 1.12 99/03/06 17:41:46 shannon 13 12
c clean up code and comments
e
s 00005/00005/00093
d D 1.11 98/02/20 17:45:46 miltonb 12 11
c 0.6 edit updates
e
s 00006/00004/00092
d D 1.10 98/01/30 10:42:16 bhc 11 10
c Fix to the JavaDocs
e
s 00008/00004/00088
d D 1.9 98/01/22 13:40:10 bhc 10 9
c clean up javadocs
c 
e
s 00003/00003/00089
d D 1.8 98/01/21 07:49:48 bhc 9 8
c update javadocs
e
s 00008/00006/00084
d D 1.7 97/12/19 14:32:46 bhc 8 7
c javadoc fixes
c 
e
s 00018/00008/00072
d D 1.6 97/12/16 14:45:00 bhc 7 6
c update java docs, fix bug where default not properly cached
e
s 00007/00001/00073
d D 1.5 97/12/09 10:31:21 bhc 6 5
c added createDataContentHandler abs method
e
s 00001/00001/00073
d D 1.4 97/12/08 07:45:44 bhc 5 4
c renamed 'setDefaultCommandMap' method from old broken 'setCOmmandMap'
e
s 00005/00006/00069
d D 1.3 97/12/02 09:48:38 bhc 4 3
c changed for updated API's
e
s 00001/00001/00074
d D 1.2 97/10/06 10:53:11 bhc 3 1
c changed to reflect DefaultCommandMap name change
e
s 00000/00000/00000
d R 1.2 97/09/05 16:22:24 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/CommandMap.java
c Name history : 1 0 src/classes/javax/activation/CommandMap.java
e
s 00075/00000/00000
d D 1.1 97/09/05 16:22:23 bhc 1 0
c date and time created 97/09/05 16:22:23 by bhc
e
u
U
f e 0
t
T
I 1
/*
D 12
 * %W% %E%
E 12
I 12
D 13
 * @(#)CommandMap.java	1.10 98/01/30
E 12
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 13
I 13
D 17
 * %W%	%E%
E 17
I 17
 * %W% %E%
E 17
 *
D 17
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 13
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 13
 * 
E 13
I 13
 *
E 13
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 13
 * 
 * 
E 13
I 13
 *
 *
E 17
I 17
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 17
E 13
 */

package javax.activation;

D 4
import java.beans.BeanInfo;
E 4
I 4
D 7
// import java.beans.BeanInfo;
E 7
E 4

D 7

E 7
/**
D 8
 * The Command Map interface provides an interface to the registry of 
D 7
 * viewer/editors/print objects available in the system.
E 7
I 7
 * viewer/editors/print/etc objects available in the system. Developers 
 * are expected to either use the CommandMap implementation included with
 * this package. Note that some of the methods in this class are abstract.
E 8
I 8
D 13
 *The <code>CommandMap</code> class  provides an interface to the registry of
 * viewer/editors/print/etc objects available in the
E 13
I 13
D 16
 * The <code>CommandMap</code> class provides an interface to the registry of
 * viewer, editor, print, etc. objects available in the
E 13
 * system. Developers are expected to either use the CommandMap
E 16
I 16
 * The CommandMap class provides an interface to a registry of
 * command objects available in the system.
 * Developers are expected to either use the CommandMap
E 16
 * implementation included with this package (MailcapCommandMap) or
D 12
 * develop thier own. Note that some of the methods in this class are
E 12
I 12
 * develop their own. Note that some of the methods in this class are
E 12
D 13
 * abstract.  
E 13
I 13
 * abstract.
E 13
E 8
E 7
 */
public abstract class CommandMap {
    private static CommandMap defaultCommandMap = null;
I 13

E 13
    /**
D 7
     * Get the default CommandMap.
E 7
I 7
D 11
     * Get the default CommandMap.<p>
E 11
I 11
     * Get the default CommandMap.
     * <p>
D 13
     * 
E 13
I 13
     *
E 13
E 11
     * <ul>
     * <li> In cases where a CommandMap instance has been previously set
D 11
     *      to some value (via <i>setDefaultCommandMap</i>) return the CommandMap.
     * </li>
E 11
I 11
D 13
     *      to some value (via <i>setDefaultCommandMap</i>) 
E 13
I 13
     *      to some value (via <i>setDefaultCommandMap</i>)
E 13
     *  return the CommandMap.
E 11
     * <li>
D 8
     * </li> In cases where no CommandMap has been set, the CommandMap
E 8
I 8
     *  In cases where no CommandMap has been set, the CommandMap
E 8
D 12
     *       will create an instance of <code>MailcapCommandMap</code> and
     *       set that to the default, returning it's value.
E 12
I 12
     *       creates an instance of <code>MailcapCommandMap</code> and
     *       set that to the default, returning its value.
E 12
D 11
     * </li>
E 11
I 11
D 13
     * 
E 13
I 13
     *
E 13
E 11
     * </ul>
E 7
D 13
     * @return the CommandMap
E 13
D 10
     * @see java.beans.DefaultCommandMap
E 10
I 10
     *
I 13
     * @return the CommandMap
E 13
E 10
     */
D 4
    public static CommandMap getDefaultCommandMap() { // remind throws Exception;
E 4
I 4
D 13
    public static CommandMap getDefaultCommandMap() { 
E 4
D 7
	if(defaultCommandMap != null)
	    return defaultCommandMap;
	else
D 3
	    return new DefaultCommandMap();
E 3
I 3
	    return new MailcapCommandMap();
E 7
I 7
	if(defaultCommandMap == null)
E 13
I 13
    public static CommandMap getDefaultCommandMap() {
	if (defaultCommandMap == null)
E 13
	    defaultCommandMap = new MailcapCommandMap();

	return defaultCommandMap;
E 7
E 3
    }

    /**
D 8
     * Set the default CommandMap. Reset the CommandMap to the JDK default by 
E 8
I 8
D 13
     * Set the default CommandMap. Reset the CommandMap to the JAF default by 
E 13
I 13
     * Set the default CommandMap. Reset the CommandMap to the default by
E 13
E 8
     * calling this method with <code>null</code>.
I 13
     *
E 13
     * @param commandMap The new default CommandMap.
I 14
     * @exception SecurityException if the caller doesn't have permission
     *					to change the default
E 14
     */
D 5
    public static void setCommandMap(CommandMap commandMap) {
E 5
I 5
    public static void setDefaultCommandMap(CommandMap commandMap) {
I 14
	SecurityManager security = System.getSecurityManager();
	if (security != null) {
	    try {
		// if it's ok with the SecurityManager, it's ok with me...
		security.checkSetFactory();
	    } catch (SecurityException ex) {
		// otherwise, we also allow it if this code and the
		// factory come from the same class loader (e.g.,
		// the JAF classes were loaded with the applet classes).
		if (CommandMap.class.getClassLoader() !=
			    commandMap.getClass().getClassLoader())
		    throw ex;
	    }
	}
E 14
E 5
	defaultCommandMap = commandMap;
    }
I 13

E 13
    /**
D 10
     * Get preferred command list from a MIME Type.
E 10
I 10
D 12
     * Get preferred command list from a MIME Type. The actual semantics 
E 12
I 12
D 13
     * Get the preferred command list from a MIME Type. The actual semantics 
E 12
     * are determined by the implementation of the CommandMap. 
E 13
I 13
     * Get the preferred command list from a MIME Type. The actual semantics
     * are determined by the implementation of the CommandMap.
E 13
E 10
     *
I 15
     * @param mimeType	the MIME type
E 15
D 9
     * @return the BeanInfo classes the represent the command Beans.
E 9
I 9
D 13
     * @return the CommandInfo classes the represent the command Beans.
E 13
I 13
     * @return the CommandInfo classes that represent the command Beans.
E 13
E 9
     */
D 4
    abstract public  BeanInfo[] getPreferredCommands(String mimeType);// REMIND throws Exception;
E 4
I 4
    abstract public  CommandInfo[] getPreferredCommands(String mimeType);
I 13

E 13
E 4
    /**
D 10
     * Get all the available commands for this type.
E 10
I 10
     * Get all the available commands for this type. This method
     * should return all the possible commands for this MIME type.
E 10
     *
D 9
     * @return returns the BeanInfo objects representing all the commands.
E 9
I 9
D 15
     * @return returns the CommandInfo objects representing all the commands.
E 15
I 15
     * @param mimeType	the MIME type
     * @return the CommandInfo objects representing all the commands.
E 15
E 9
D 13
     */        
D 4
    abstract public BeanInfo[] getAllCommands(String mimeType); // REMIND throws Exception
E 4
I 4
    abstract public CommandInfo[] getAllCommands(String mimeType); 
E 4
    
E 13
I 13
     */
    abstract public CommandInfo[] getAllCommands(String mimeType);

E 13
    /**
D 10
     * Get the default <code>command</code> corresonding to the MIME type. 
E 10
I 10
D 13
     * Get the default command corresonding to the MIME type. 
E 13
I 13
     * Get the default command corresponding to the MIME type.
E 13
E 10
     *
I 15
     * @param mimeType	the MIME type
     * @param cmdName	the command name
E 15
D 9
     * @return the Bean Info corresponding to the command.
E 9
I 9
     * @return the CommandInfo corresponding to the command.
E 9
     */
D 4
    abstract public BeanInfo getCommand(String mimeType,String cmdName); // REMIND thows Exception;
    
E 4
I 4
D 6
    abstract public CommandInfo getCommand(String mimeType,String cmdName);    
E 6
I 6
D 13
    abstract public CommandInfo getCommand(String mimeType,String cmdName);
E 13
I 13
    abstract public CommandInfo getCommand(String mimeType, String cmdName);
E 13

    /**
     * Locate a DataContentHandler that corresponds to the MIME type.
I 10
D 13
     * The mechanism and semantics for determining this are determined 
E 13
I 13
     * The mechanism and semantics for determining this are determined
E 13
     * by the implementation of the particular CommandMap.
I 15
     *
     * @param mimeType	the MIME type
     * @return		the DataContentHandler for the MIME type
E 15
E 10
     */
D 13
    abstract public DataContentHandler createDataContentHandler(String 
E 13
I 13
    abstract public DataContentHandler createDataContentHandler(String
E 13
								mimeType);
E 6
E 4
D 13
} 


E 13
I 13
}
E 13
E 1
