h29989
s 00005/00014/00325
d D 1.5 99/12/06 16:33:32 shannon 6 5
c Update copyright for SCSL release
e
s 00269/00300/00070
d D 1.4 99/11/03 11:45:42 shannon 5 4
c add missing copyrights
e
s 00028/00014/00342
d D 1.3 97/12/18 11:32:31 jmoore 4 3
c fix bug in autoquote handling
e
s 00000/00000/00356
d D 1.2 97/10/10 13:54:38 jmoore 3 1
c fix a few small bugs
e
s 00000/00000/00000
d R 1.2 97/10/09 16:08:55 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/com/sun/activation/registries/MailcapTokenizer.java
c Name history : 1 0 src/classes/com/sun/activation/registries/MailcapTokenizer.java
e
s 00356/00000/00000
d D 1.1 97/10/09 15:08:54 jmoore 1 0
c date and time created 97/10/09 15:08:54 by jmoore
e
u
U
f e 0
t
T
I 5
/*
 * %W% %E%
 *
D 6
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
E 6
I 6
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 6
 */

E 5
I 1
package	com.sun.activation.registries;

/**
 *	A tokenizer for strings in the form of "foo/bar; prop1=val1; ... ".
 *	Useful for parsing MIME content types.
 */
D 5
public class	MailcapTokenizer
{
E 5
I 5
public class MailcapTokenizer {
E 5

D 5
public static final int	UNKNOWN_TOKEN = 0;
public static final int	START_TOKEN = 1;
public static final int	STRING_TOKEN = 2;
public static final int	EOI_TOKEN = 5;
public static final int	SLASH_TOKEN = '/';
public static final int	SEMICOLON_TOKEN = ';';
public static final int	EQUALS_TOKEN = '=';
E 5
I 5
    public static final int UNKNOWN_TOKEN = 0;
    public static final int START_TOKEN = 1;
    public static final int STRING_TOKEN = 2;
    public static final int EOI_TOKEN = 5;
    public static final int SLASH_TOKEN = '/';
    public static final int SEMICOLON_TOKEN = ';';
    public static final int EQUALS_TOKEN = '=';
E 5

D 5
/**
 *	Constructor
 *
 *	@parameter	inputString	the string to tokenize
 */
public	MailcapTokenizer(String inputString)
{
E 5
I 5
    /**
     *  Constructor
     *
     *  @parameter  inputString the string to tokenize
     */
    public MailcapTokenizer(String inputString) {
E 5
	data = inputString;
	dataIndex = 0;
	dataLength = inputString.length();
D 5
	
E 5
I 5

E 5
	currentToken = START_TOKEN;
	currentTokenValue = "";
D 5
	
E 5
I 5

E 5
	isAutoquoting = false;
	autoquoteChar = ';';
D 5
}
E 5
I 5
    }
E 5

D 5
/**
 *	Set whether auto-quoting is on or off.
 *	
 *	Auto-quoting means that all characters after the first non-whitespace, non-control character
 *	up to the auto-quote terminator character or EOI (minus any whitespace immediatley preceeding it)
 *	is considered a token.
 *
 *	This is required for handling command strings in a mailcap entry.
 */
public void	setIsAutoquoting(boolean value)
{
E 5
I 5
    /**
     *  Set whether auto-quoting is on or off.
     *
     *  Auto-quoting means that all characters after the first
     *  non-whitespace, non-control character up to the auto-quote
     *  terminator character or EOI (minus any whitespace immediatley
     *  preceeding it) is considered a token.
     *
     *  This is required for handling command strings in a mailcap entry.
     */
    public void setIsAutoquoting(boolean value) {
E 5
	isAutoquoting = value;
D 5
}
E 5
I 5
    }
E 5

D 5
/**
 *	Set the auto-quote terminating character.
 */
public void	setAutoquoteChar(char value)
{
E 5
I 5
    /**
     *  Set the auto-quote terminating character.
     */
    public void setAutoquoteChar(char value) {
E 5
	autoquoteChar = value;
D 5
}
E 5
I 5
    }
E 5

D 5
/**
 *	Retrieve current token.
 *
 *	@returns	The current token value
 */
public int	getCurrentToken()
{
E 5
I 5
    /**
     *  Retrieve current token.
     *
     *  @returns    The current token value
     */
    public int getCurrentToken() {
E 5
	return currentToken;
D 5
}
E 5
I 5
    }
E 5

D 5
/*
 *	Get a String that describes the given token.
 */
public static String	nameForToken(int token)
{
E 5
I 5
    /*
     *  Get a String that describes the given token.
     */
    public static String nameForToken(int token) {
E 5
	String name = "really unknown";
D 5
	
	switch(token)
	{
		case UNKNOWN_TOKEN:
			name = "unknown";
			break;
		case START_TOKEN:
			name = "start";
			break;
		case STRING_TOKEN:
			name = "string";
			break;
		case EOI_TOKEN:
			name = "EOI";
			break;
		case SLASH_TOKEN:
			name = "'/'";
			break;
		case SEMICOLON_TOKEN:
			name = "';'";
			break;
		case EQUALS_TOKEN:
			name = "'='";
			break;
E 5
I 5

	switch(token) {
	    case UNKNOWN_TOKEN:
		name = "unknown";
		break;
	    case START_TOKEN:
		name = "start";
		break;
	    case STRING_TOKEN:
		name = "string";
		break;
	    case EOI_TOKEN:
		name = "EOI";
		break;
	    case SLASH_TOKEN:
		name = "'/'";
		break;
	    case SEMICOLON_TOKEN:
		name = "';'";
		break;
	    case EQUALS_TOKEN:
		name = "'='";
		break;
E 5
	}
D 5
	
E 5
I 5

E 5
	return name;
D 5
}
E 5
I 5
    }
E 5

D 5
/*
 *	Retrieve current token value.
 *
 *	@returns	A String containing the current token value
 */
public String	getCurrentTokenValue()
{
E 5
I 5
    /*
     *  Retrieve current token value.
     *
     *  @returns    A String containing the current token value
     */
    public String getCurrentTokenValue() {
E 5
	return currentTokenValue;
D 5
}
E 5
I 5
    }
E 5

D 5
/*
 *	Process the next token.
 *
 *	@returns	the next token
 */
public int	nextToken()
{
	if(dataIndex < dataLength)
	{
		//	skip white space
		while((dataIndex < dataLength) && (isWhiteSpaceChar(data.charAt(dataIndex))))
		{
E 5
I 5
    /*
     *  Process the next token.
     *
     *  @returns    the next token
     */
    public int nextToken() {
	if (dataIndex < dataLength) {
	    //  skip white space
	    while ((dataIndex < dataLength) &&
		    (isWhiteSpaceChar(data.charAt(dataIndex)))) {
		++dataIndex;
	    }

	    if (dataIndex < dataLength) {
		//  examine the current character and see what kind of token we have
		char c = data.charAt(dataIndex);
		if (isAutoquoting) {
		    if (!isAutoquoteSpecialChar(c)) {
			processAutoquoteToken();
		    } else if ((c == ';') || (c == '=')) {
			currentToken = c;
			currentTokenValue = new Character(c).toString();
E 5
			++dataIndex;
I 5
		    } else {
			currentToken = UNKNOWN_TOKEN;
			currentTokenValue = new Character(c).toString();
			++dataIndex;
		    }
		} else {
		    if (isStringTokenChar(c)) {
			processStringToken();
		    } else if ((c == '/') || (c == ';') || (c == '=')) {
			currentToken = c;
			currentTokenValue = new Character(c).toString();
			++dataIndex;
		    } else {
			currentToken = UNKNOWN_TOKEN;
			currentTokenValue = new Character(c).toString();
			++dataIndex;
		    }
E 5
		}
D 5
		
		if(dataIndex < dataLength)
		{
			//	examine the current character and see what kind of token we have
			char c = data.charAt(dataIndex);
D 4
			
			if(isStringTokenChar(c))
E 4
I 4
			if(isAutoquoting)
E 4
			{
D 4
				if(isAutoquoting)
E 4
I 4
				if(!isAutoquoteSpecialChar(c))
E 4
				{
					processAutoquoteToken();
				}
I 4
				else if((c == ';') || (c == '='))
				{
					currentToken = c;
					currentTokenValue = new Character(c).toString();
					++dataIndex;
				}
E 4
				else
				{
D 4
					processStringToken();
E 4
I 4
					currentToken = UNKNOWN_TOKEN;
					currentTokenValue = new Character(c).toString();
					++dataIndex;
E 4
				}
			}
D 4
			else if((c == '/') || (c == ';') || (c == '='))
			{
				currentToken = c;
				currentTokenValue = new Character(c).toString();
				++dataIndex;
			}
E 4
			else
			{
D 4
				currentToken = UNKNOWN_TOKEN;
				currentTokenValue = new Character(c).toString();
				++dataIndex;
E 4
I 4
				if(isStringTokenChar(c))
				{
					processStringToken();
				}
				else if((c == '/') || (c == ';') || (c == '='))
				{
					currentToken = c;
					currentTokenValue = new Character(c).toString();
					++dataIndex;
				}
				else
				{
					currentToken = UNKNOWN_TOKEN;
					currentTokenValue = new Character(c).toString();
					++dataIndex;
				}
E 4
			}
		}
		else
		{
			currentToken = EOI_TOKEN;
			currentTokenValue = null;
		}
	}
	else
	{
E 5
I 5
	    } else {
E 5
		currentToken = EOI_TOKEN;
		currentTokenValue = null;
I 5
	    }
	} else {
	    currentToken = EOI_TOKEN;
	    currentTokenValue = null;
E 5
	}
D 5
	
E 5
I 5

E 5
	return currentToken;
D 5
}
E 5
I 5
    }
E 5

D 5
private void	processStringToken()
{
	//	capture the initial index
E 5
I 5
    private void processStringToken() {
	//  capture the initial index
E 5
	int initialIndex = dataIndex;
D 5
	
	//	skip to 1st non string token character
	while((dataIndex < dataLength) && isStringTokenChar(data.charAt(dataIndex)))
	{
		++dataIndex;
E 5
I 5

	//  skip to 1st non string token character
	while ((dataIndex < dataLength) &&
		isStringTokenChar(data.charAt(dataIndex))) {
	    ++dataIndex;
E 5
	}
D 5
	
E 5
I 5

E 5
	currentToken = STRING_TOKEN;
	currentTokenValue = data.substring(initialIndex, dataIndex);
D 5
}
E 5
I 5
    }
E 5

D 5
private void	processAutoquoteToken()
{
	//	capture the initial index
E 5
I 5
    private void processAutoquoteToken() {
	//  capture the initial index
E 5
	int initialIndex = dataIndex;
D 5
	
	//	now skip to the 1st non-escaped autoquote termination character
E 5
I 5

	//  now skip to the 1st non-escaped autoquote termination character
E 5
	boolean foundTerminator = false;
D 5
	while((dataIndex < dataLength) && !foundTerminator)
	{
		char c = data.charAt(dataIndex);
		if(c != autoquoteChar)
		{
			++dataIndex;
		}
		else
		{
			foundTerminator = true;
		}
E 5
I 5
	while ((dataIndex < dataLength) && !foundTerminator) {
	    char c = data.charAt(dataIndex);
	    if (c != autoquoteChar) {
		++dataIndex;
	    } else {
		foundTerminator = true;
	    }
E 5
	}
D 5
	
E 5
I 5

E 5
	currentToken = STRING_TOKEN;
D 5
	currentTokenValue = fixEscapeSequences(data.substring(initialIndex, dataIndex));
}
E 5
I 5
	currentTokenValue =
	    fixEscapeSequences(data.substring(initialIndex, dataIndex));
    }
E 5

D 5
public static boolean	isSpecialChar(char c)
{
E 5
I 5
    public static boolean isSpecialChar(char c) {
E 5
	boolean lAnswer = false;
D 5
	
	switch(c)
	{
		case '(':
		case ')':
		case '<':
		case '>':
		case '@':
		case ',':
		case ';':
		case ':':
		case '\\':
		case '"':
		case '/':
		case '[':
		case ']':
		case '?':
		case '=':
			lAnswer = true;
			break;
E 5
I 5

	switch(c) {
	    case '(':
	    case ')':
	    case '<':
	    case '>':
	    case '@':
	    case ',':
	    case ';':
	    case ':':
	    case '\\':
	    case '"':
	    case '/':
	    case '[':
	    case ']':
	    case '?':
	    case '=':
		lAnswer = true;
		break;
E 5
	}
D 5
		
E 5
I 5

E 5
	return lAnswer;
D 5
}
E 5
I 5
    }
E 5

D 5
public static boolean	isAutoquoteSpecialChar(char c)
{
E 5
I 5
    public static boolean isAutoquoteSpecialChar(char c) {
E 5
	boolean lAnswer = false;
D 5
	
	switch(c)
	{
		case ';':
D 4
		case '\\':
E 4
I 4
		case '=':
E 4
			lAnswer = true;
			break;
E 5
I 5

	switch(c) {
	    case ';':
	    case '=':
		lAnswer = true;
		break;
E 5
	}
D 5
		
E 5
I 5

E 5
	return lAnswer;
D 5
}
E 5
I 5
    }
E 5

D 5
public static boolean	isControlChar(char c)
{
E 5
I 5
    public static boolean isControlChar(char c) {
E 5
	return Character.isISOControl(c);
D 5
}
E 5
I 5
    }
E 5

D 5
public static boolean	isWhiteSpaceChar(char c)
{
E 5
I 5
    public static boolean isWhiteSpaceChar(char c) {
E 5
	return Character.isWhitespace(c);
D 5
}
E 5
I 5
    }
E 5

D 5
public static boolean	isStringTokenChar(char c)
{
E 5
I 5
    public static boolean isStringTokenChar(char c) {
E 5
	return !isSpecialChar(c) && !isControlChar(c) && !isWhiteSpaceChar(c);
D 5
}
E 5
I 5
    }
E 5

D 5
private static String	fixEscapeSequences(String inputString)
{
E 5
I 5
    private static String fixEscapeSequences(String inputString) {
E 5
	int inputLength = inputString.length();
	StringBuffer buffer = new StringBuffer();
	buffer.ensureCapacity(inputLength);
D 5
	
	for(int i = 0; i < inputLength; ++i)
	{
		char currentChar = inputString.charAt(i);
		if(currentChar != '\\')
		{
			buffer.append(currentChar);
E 5
I 5

	for (int i = 0; i < inputLength; ++i) {
	    char currentChar = inputString.charAt(i);
	    if (currentChar != '\\') {
		buffer.append(currentChar);
	    } else {
		if (i < inputLength - 1) {
		    char nextChar = inputString.charAt(i + 1);
		    buffer.append(nextChar);

		    //  force a skip over the next character too
		    ++i;
		} else {
		    buffer.append(currentChar);
E 5
		}
D 5
		else
		{
			if(i < inputLength - 1)
			{
				char nextChar = inputString.charAt(i + 1);
				buffer.append(nextChar);
				
				//	force a skip over the next character too
				++i;
			}
			else
			{
				buffer.append(currentChar);
			}
		}
E 5
I 5
	    }
E 5
	}
D 5
	
E 5
I 5

E 5
	return buffer.toString();
D 5
}
E 5
I 5
    }
E 5

D 5
private String	data;
private int		dataIndex;
private int		dataLength;
private int		currentToken;
private String	currentTokenValue;
private boolean	isAutoquoting;
private char	autoquoteChar;
E 5
I 5
    private String  data;
    private int     dataIndex;
    private int     dataLength;
    private int     currentToken;
    private String  currentTokenValue;
    private boolean isAutoquoting;
    private char    autoquoteChar;
E 5

D 5
public static void	main(String[] args)
{
	for(int i = 0; i < args.length; ++i)
	{
		MailcapTokenizer tokenizer = new MailcapTokenizer(args[i]);
		
		System.out.println("Original: |" + args[i] + "|");
		
		int currentToken = tokenizer.nextToken();
		while(currentToken != EOI_TOKEN)
		{
			switch(currentToken)
			{
				case UNKNOWN_TOKEN:
					System.out.println("  Unknown Token:           |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				case START_TOKEN:
					System.out.println("  Start Token:             |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				case STRING_TOKEN:
					System.out.println("  String Token:            |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				case EOI_TOKEN:
					System.out.println("  EOI Token:               |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				case SLASH_TOKEN:
					System.out.println("  Slash Token:             |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				case SEMICOLON_TOKEN:
					System.out.println("  Semicolon Token:         |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				case EQUALS_TOKEN:
					System.out.println("  Equals Token:            |" + tokenizer.getCurrentTokenValue() + "|");
					break;
				default:
					System.out.println("  Really Unknown Token:    |" + tokenizer.getCurrentTokenValue() + "|");
					break;
			}
			
			currentToken = tokenizer.nextToken();
E 5
I 5
    /*
    public static void main(String[] args) {
	for (int i = 0; i < args.length; ++i) {
	    MailcapTokenizer tokenizer = new MailcapTokenizer(args[i]);

	    System.out.println("Original: |" + args[i] + "|");

	    int currentToken = tokenizer.nextToken();
	    while (currentToken != EOI_TOKEN) {
		switch(currentToken) {
		    case UNKNOWN_TOKEN:
			System.out.println("  Unknown Token:           |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    case START_TOKEN:
			System.out.println("  Start Token:             |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    case STRING_TOKEN:
			System.out.println("  String Token:            |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    case EOI_TOKEN:
			System.out.println("  EOI Token:               |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    case SLASH_TOKEN:
			System.out.println("  Slash Token:             |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    case SEMICOLON_TOKEN:
			System.out.println("  Semicolon Token:         |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    case EQUALS_TOKEN:
			System.out.println("  Equals Token:            |" + tokenizer.getCurrentTokenValue() + "|");
			break;
		    default:
			System.out.println("  Really Unknown Token:    |" + tokenizer.getCurrentTokenValue() + "|");
			break;
E 5
		}
D 5
		
		System.out.println("");
	}
}
E 5

I 5
		currentToken = tokenizer.nextToken();
	    }

	    System.out.println("");
	}
    }
    */
E 5
}
E 1
